/*
 * Decompiled with CFR 0.152.
 */
package org.productivity.java.syslog4j.impl.unix.socket;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import org.productivity.java.syslog4j.SyslogRuntimeException;
import org.productivity.java.syslog4j.impl.AbstractSyslog;
import org.productivity.java.syslog4j.impl.AbstractSyslogWriter;
import org.productivity.java.syslog4j.impl.unix.socket.UnixSocketSyslogConfig;
import org.productivity.java.syslog4j.util.OSDetectUtility;

public class UnixSocketSyslog
extends AbstractSyslog {
    private static final long serialVersionUID = 39878807911936785L;
    protected boolean libraryLoaded = false;
    protected CLibrary libraryInstance = null;
    protected UnixSocketSyslogConfig unixSocketSyslogConfig = null;
    protected int fd = -1;
    static /* synthetic */ Class class$org$productivity$java$syslog4j$impl$unix$socket$UnixSocketSyslog$CLibrary;

    protected synchronized void loadLibrary() {
        if (!OSDetectUtility.isUnix()) {
            throw new SyslogRuntimeException("UnixSyslog not supported on non-Unix platforms");
        }
        if (!this.libraryLoaded) {
            this.libraryInstance = (CLibrary)Native.loadLibrary((String)this.unixSocketSyslogConfig.getLibrary(), (Class)(class$org$productivity$java$syslog4j$impl$unix$socket$UnixSocketSyslog$CLibrary == null ? (class$org$productivity$java$syslog4j$impl$unix$socket$UnixSocketSyslog$CLibrary = UnixSocketSyslog.class$("org.productivity.java.syslog4j.impl.unix.socket.UnixSocketSyslog$CLibrary")) : class$org$productivity$java$syslog4j$impl$unix$socket$UnixSocketSyslog$CLibrary));
            this.libraryLoaded = true;
        }
    }

    public void initialize() throws SyslogRuntimeException {
        try {
            this.unixSocketSyslogConfig = (UnixSocketSyslogConfig)this.syslogConfig;
        }
        catch (ClassCastException classCastException) {
            throw new SyslogRuntimeException("config must be of type UnixSocketSyslogConfig");
        }
        this.loadLibrary();
    }

    protected synchronized void connect() {
        if (this.fd != -1) {
            return;
        }
        this.fd = this.libraryInstance.socket(this.unixSocketSyslogConfig.getFamily(), this.unixSocketSyslogConfig.getType(), this.unixSocketSyslogConfig.getProtocol());
        if (this.fd == -1) {
            this.fd = -1;
            return;
        }
        SockAddr sockAddr = new SockAddr();
        sockAddr.sun_family = this.unixSocketSyslogConfig.getFamily();
        sockAddr.setSunPath(this.unixSocketSyslogConfig.getPath());
        int n = this.libraryInstance.connect(this.fd, sockAddr, sockAddr.size());
        if (n == -1) {
            this.fd = -1;
            return;
        }
    }

    protected void write(byte[] byArray) throws SyslogRuntimeException {
        if (this.fd == -1) {
            this.connect();
        }
        if (this.fd == -1) {
            return;
        }
        this.libraryInstance.write(this.fd, byArray, byArray.length);
    }

    public void flush() throws SyslogRuntimeException {
        this.shutdown();
        this.fd = this.libraryInstance.socket(this.unixSocketSyslogConfig.getFamily(), this.unixSocketSyslogConfig.getType(), this.unixSocketSyslogConfig.getProtocol());
    }

    public void shutdown() throws SyslogRuntimeException {
        if (this.fd == -1) {
            return;
        }
        this.libraryInstance.shutdown(this.fd, 1);
        this.fd = -1;
    }

    public AbstractSyslogWriter getWriter() {
        return null;
    }

    public void returnWriter(AbstractSyslogWriter abstractSyslogWriter) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected static interface CLibrary
    extends Library {
        public int socket(int var1, int var2, int var3);

        public int connect(int var1, SockAddr var2, int var3);

        public int write(int var1, byte[] var2, int var3);

        public int shutdown(int var1, int var2);

        public String strerror(int var1);
    }

    protected static class SockAddr
    extends Structure {
        public static final int SUN_PATH_SIZE = 108;
        public static final byte[] ZERO_BYTE = new byte[]{0};
        public short sun_family = 1;
        public byte[] sun_path = new byte[108];

        protected SockAddr() {
        }

        public void setSunPath(String string) {
            System.arraycopy(string.getBytes(), 0, this.sun_path, 0, string.length());
            System.arraycopy(ZERO_BYTE, 0, this.sun_path, string.length(), 1);
        }
    }
}

