/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLBARINFO;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    long callWindowProc(long l, int n, long l2, long l3) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.DefWindowProc(l, n, l2, l3);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        long l = this.scrolledHandle();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = OS.GetWindowLong(l, -16);
        int n6 = OS.GetWindowLong(l, -20);
        OS.AdjustWindowRectEx(rECT, n5, false, n6);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        int n7 = rECT.right - rECT.left;
        int n8 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n7, n8);
    }

    ScrollBar createScrollBar(int n) {
        ScrollBar scrollBar = new ScrollBar(this, n);
        if ((this.state & 2) != 0) {
            scrollBar.setMaximum(100);
            scrollBar.setThumb(10);
        }
        return scrollBar;
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void destroyScrollBar(int n) {
        long l = this.scrolledHandle();
        int n2 = OS.GetWindowLong(l, -16);
        if ((n & 0x100) != 0) {
            this.style &= 0xFFFFFEFF;
            n2 &= 0xFFEFFFFF;
        }
        if ((n & 0x200) != 0) {
            this.style &= 0xFFFFFDFF;
            n2 &= 0xFFDFFFFF;
        }
        OS.SetWindowLong(l, -16, n2);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        long l = this.scrolledHandle();
        OS.GetClientRect(l, rECT);
        int n = rECT.left;
        int n2 = rECT.top;
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        if (l != this.handle) {
            OS.GetClientRect(this.handle, rECT);
            OS.MapWindowPoints(this.handle, l, rECT, 2);
            n = -rECT.left;
            n2 = -rECT.top;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    void releaseChildren(boolean bl) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl);
    }

    long scrolledHandle() {
        return this.handle;
    }

    int widgetExtStyle() {
        return super.widgetExtStyle();
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 0x10000;
        if ((this.style & 0x100) != 0) {
            n |= 0x100000;
        }
        if ((this.style & 0x200) != 0) {
            n |= 0x200000;
        }
        return n;
    }

    TCHAR windowClass() {
        return this.display.windowClass;
    }

    long windowProc() {
        return this.display.windowProc;
    }

    LRESULT WM_HSCROLL(long l, long l2) {
        LRESULT lRESULT = super.WM_HSCROLL(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.horizontalBar != null && (l2 == 0L || l2 == this.handle)) {
            return this.wmScroll(this.horizontalBar, (this.state & 2) != 0, this.handle, 276, l, l2);
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEWHEEL(long l, long l2) {
        return this.wmScrollWheel((this.state & 2) != 0, l, l2);
    }

    LRESULT WM_SIZE(long l, long l2) {
        long l3 = this.callWindowProc(this.handle, 5, l, l2);
        super.WM_SIZE(l, l2);
        if (l3 == 0L) {
            return LRESULT.ZERO;
        }
        return new LRESULT(l3);
    }

    LRESULT WM_VSCROLL(long l, long l2) {
        LRESULT lRESULT = super.WM_VSCROLL(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.verticalBar != null && (l2 == 0L || l2 == this.handle)) {
            return this.wmScroll(this.verticalBar, (this.state & 2) != 0, this.handle, 277, l, l2);
        }
        return lRESULT;
    }

    LRESULT wmNCPaint(long l, long l2, long l3) {
        int n;
        LRESULT lRESULT = super.wmNCPaint(l, l2, l3);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && !OS.IsWinCE && OS.WIN32_VERSION < OS.VERSION(6, 0) && ((n = OS.GetWindowLong(l, -16)) & 0x300000) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(l, rECT);
            RECT rECT2 = new RECT();
            int n2 = OS.GetWindowLong(l, -20);
            OS.AdjustWindowRectEx(rECT2, n, false, n2);
            boolean bl = false;
            boolean bl2 = false;
            SCROLLBARINFO sCROLLBARINFO = new SCROLLBARINFO();
            sCROLLBARINFO.cbSize = SCROLLBARINFO.sizeof;
            if (OS.GetScrollBarInfo(l, -6, sCROLLBARINFO)) {
                boolean bl3 = bl = (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
            }
            if (OS.GetScrollBarInfo(l, -5, sCROLLBARINFO)) {
                bl2 = (sCROLLBARINFO.rgstate[0] & 0x8000) == 0;
            }
            RECT rECT3 = new RECT();
            rECT3.right = rECT.right - rECT.left - rECT2.right;
            rECT3.bottom = rECT.bottom - rECT.top - rECT2.bottom;
            rECT3.left = rECT3.right - (bl ? OS.GetSystemMetrics(2) : 0);
            rECT3.top = rECT3.bottom - (bl2 ? OS.GetSystemMetrics(3) : 0);
            if (rECT3.left != rECT3.right && rECT3.top != rECT3.bottom) {
                long l4 = OS.GetWindowDC(l);
                OS.FillRect(l4, rECT3, OS.COLOR_BTNFACE + 1);
                Decorations decorations = this.menuShell();
                if ((decorations.style & 0x10) != 0) {
                    boolean bl4;
                    long l5 = decorations.scrolledHandle();
                    boolean bl5 = bl4 = l == l5;
                    if (!bl4) {
                        RECT rECT4 = new RECT();
                        OS.GetClientRect(l5, rECT4);
                        OS.MapWindowPoints(l5, 0L, rECT4, 2);
                        boolean bl6 = bl4 = rECT4.right == rECT.right && rECT4.bottom == rECT.bottom;
                    }
                    if (bl4) {
                        OS.DrawThemeBackground(this.display.hScrollBarTheme(), l4, 10, 0, rECT3, null);
                    }
                }
                OS.ReleaseDC(l, l4);
            }
        }
        return lRESULT;
    }

    LRESULT wmScrollWheel(boolean bl, long l, long l2) {
        Event event;
        int n;
        int n2 = this.display.scrollRemainder;
        LRESULT lRESULT = super.WM_MOUSEWHEEL(l, l2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (bl) {
            boolean bl2;
            int n3;
            boolean bl3;
            if ((l & 0xCL) != 0L) {
                return lRESULT;
            }
            boolean bl4 = this.verticalBar != null && this.verticalBar.getEnabled();
            boolean bl5 = bl3 = this.horizontalBar != null && this.horizontalBar.getEnabled();
            int n4 = bl4 ? 277 : (n3 = bl3 ? 276 : 0);
            if (n3 == 0) {
                return lRESULT;
            }
            int[] nArray = new int[1];
            OS.SystemParametersInfo(104, 0, nArray, 0);
            int n5 = OS.GET_WHEEL_DELTA_WPARAM(l);
            boolean bl6 = bl2 = nArray[0] == -1;
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
                ScrollBar scrollBar = bl4 ? this.verticalBar : this.horizontalBar;
                SCROLLINFO sCROLLINFO = new SCROLLINFO();
                sCROLLINFO.cbSize = SCROLLINFO.sizeof;
                sCROLLINFO.fMask = 4;
                OS.GetScrollInfo(this.handle, scrollBar.scrollBarType(), sCROLLINFO);
                if (bl4 && !bl2) {
                    n5 *= nArray[0];
                }
                int n6 = bl2 ? scrollBar.getPageIncrement() : scrollBar.getIncrement();
                sCROLLINFO.nPos -= n6 * n5 / 120;
                OS.SetScrollInfo(this.handle, scrollBar.scrollBarType(), sCROLLINFO, true);
                OS.SendMessage(this.handle, n3, 4L, 0L);
            } else {
                int n7 = 0;
                if (bl2) {
                    n7 = n5 < 0 ? 3 : 2;
                } else {
                    int n8 = n7 = n5 < 0 ? 1 : 0;
                    if (n3 == 277) {
                        n5 *= nArray[0];
                    }
                }
                if ((n5 ^ n2) >= 0) {
                    n5 += n2;
                }
                int n9 = Math.abs(n5) / 120;
                int n10 = 0;
                while (n10 < n9) {
                    OS.SendMessage(this.handle, n3, (long)n7, 0L);
                    ++n10;
                }
            }
            return LRESULT.ZERO;
        }
        int n11 = this.verticalBar == null ? 0 : this.verticalBar.getSelection();
        int n12 = this.horizontalBar == null ? 0 : this.horizontalBar.getSelection();
        long l3 = this.callWindowProc(this.handle, 522, l, l2);
        if (this.verticalBar != null && (n = this.verticalBar.getSelection()) != n11) {
            event = new Event();
            event.detail = n < n11 ? 0x1000005 : 0x1000006;
            this.verticalBar.sendEvent(13, event);
        }
        if (this.horizontalBar != null && (n = this.horizontalBar.getSelection()) != n12) {
            event = new Event();
            event.detail = n < n12 ? 0x1000005 : 0x1000006;
            this.horizontalBar.sendEvent(13, event);
        }
        return new LRESULT(l3);
    }

    LRESULT wmScroll(ScrollBar scrollBar, boolean bl, long l, int n, long l2, long l3) {
        LRESULT lRESULT = null;
        if (bl) {
            int n2 = n == 276 ? 0 : 1;
            SCROLLINFO sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 21;
            OS.GetScrollInfo(l, n2, sCROLLINFO);
            sCROLLINFO.fMask = 4;
            int n3 = OS.LOWORD(l2);
            switch (n3) {
                case 8: {
                    return null;
                }
                case 4: 
                case 5: {
                    sCROLLINFO.nPos = sCROLLINFO.nTrackPos;
                    break;
                }
                case 6: {
                    sCROLLINFO.nPos = sCROLLINFO.nMin;
                    break;
                }
                case 7: {
                    sCROLLINFO.nPos = sCROLLINFO.nMax;
                    break;
                }
                case 1: {
                    sCROLLINFO.nPos += scrollBar.getIncrement();
                    break;
                }
                case 0: {
                    int n4 = scrollBar.getIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n4);
                    break;
                }
                case 3: {
                    sCROLLINFO.nPos += scrollBar.getPageIncrement();
                    break;
                }
                case 2: {
                    int n5 = scrollBar.getPageIncrement();
                    sCROLLINFO.nPos = Math.max(sCROLLINFO.nMin, sCROLLINFO.nPos - n5);
                }
            }
            OS.SetScrollInfo(l, n2, sCROLLINFO, true);
        } else {
            long l4 = this.callWindowProc(l, n, l2, l3);
            lRESULT = l4 == 0L ? LRESULT.ZERO : new LRESULT(l4);
        }
        scrollBar.wmScrollChild(l2, l3);
        return lRESULT;
    }
}

