/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.xpath;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathTableModel;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class XPathDataFactory
implements DataFactory,
Cloneable {
    private static final Log logger = LogFactory.getLog(XPathDataFactory.class);
    private HashMap<String, String> queries = new HashMap();
    private String xqueryDataFile;
    private transient ResourceManager resourceManager = new ResourceManager();
    private transient ResourceKey contextKey;

    public XPathDataFactory() {
        this.resourceManager.registerDefaults();
    }

    public String getXqueryDataFile() {
        return this.xqueryDataFile;
    }

    public void setXqueryDataFile(String xqueryDataFile) {
        this.xqueryDataFile = xqueryDataFile;
    }

    public void setQuery(String name, String value) {
        if (value == null) {
            this.queries.remove(name);
        } else {
            this.queries.put(name, value);
        }
    }

    public String getQuery(String name) {
        return this.queries.get(name);
    }

    public String[] getQueryNames() {
        return this.queries.keySet().toArray(new String[this.queries.size()]);
    }

    public void initialize(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        this.contextKey = contextKey;
    }

    public TableModel queryData(String query, DataRow parameters) throws ReportDataFactoryException {
        int queryLimitVal;
        String xpath = this.queries.get(query);
        if (xpath == null) {
            throw new ReportDataFactoryException("No such query");
        }
        Object queryLimit = parameters.get("::org.pentaho.reporting::query-limit");
        if (queryLimit instanceof Number) {
            Number i = (Number)queryLimit;
            queryLimitVal = i.intValue();
        } else {
            queryLimitVal = -1;
        }
        try {
            ResourceData resource = this.load();
            return new XPathTableModel(resource, this.resourceManager, xpath, parameters, queryLimitVal);
        }
        catch (ResourceException re) {
            throw new ReportDataFactoryException("Failed to load XML data", (Throwable)re);
        }
    }

    private ResourceData load() throws ResourceException {
        try {
            if (this.contextKey != null) {
                ResourceKey resourceKey = this.resourceManager.deriveKey(this.contextKey, this.getXqueryDataFile());
                return this.resourceManager.load(resourceKey);
            }
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load datasource as derived path: " + (Object)((Object)re)));
        }
        try {
            ResourceKey resourceKey = this.resourceManager.createKey((Object)new URL(this.getXqueryDataFile()));
            return this.resourceManager.load(resourceKey);
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load datasource as URL: " + (Object)((Object)re)));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        try {
            ResourceKey resourceKey = this.resourceManager.createKey((Object)new File(this.getXqueryDataFile()));
            return this.resourceManager.load(resourceKey);
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load datasource as file: " + (Object)((Object)re)));
            throw new ResourceException("Unable to load the resource");
        }
    }

    public Object clone() {
        try {
            XPathDataFactory dataFactory = (XPathDataFactory)super.clone();
            dataFactory.queries = (HashMap)this.queries.clone();
            return dataFactory;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Failed to clone datafactory", e);
        }
    }

    public DataFactory derive() {
        return (XPathDataFactory)this.clone();
    }

    public void open() throws ReportDataFactoryException {
    }

    public void close() {
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return this.queries.containsKey(query);
    }

    public void cancelRunningQuery() {
    }
}

