/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.xpath;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.table.AbstractTableModel;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.util.IntegerCache;
import org.pentaho.reporting.libraries.base.util.GenericObjectTable;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XPathTableModel
extends AbstractTableModel {
    private static final Log logger = LogFactory.getLog(XPathTableModel.class);
    private static final Map SUPPORTED_TYPES;
    private GenericObjectTable data;
    private ArrayList columnTypes;
    private ArrayList columnNames;

    public XPathTableModel(ResourceData xmlResource, ResourceManager resourceManager, String xPathExpression, DataRow parameters, int maxRowsToProcess) throws ReportDataFactoryException {
        try {
            int count;
            this.columnTypes = new ArrayList();
            this.columnNames = new ArrayList();
            XPath xPath = XPathFactory.newInstance().newXPath();
            xPath.setXPathVariableResolver(new InternalXPathVariableResolver(parameters));
            String nodeValue = this.computeColDeclaration(xmlResource, resourceManager, xPath);
            if (nodeValue != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(nodeValue, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String className = stringTokenizer.nextToken();
                    if (SUPPORTED_TYPES.containsKey(className)) {
                        this.columnTypes.add(SUPPORTED_TYPES.get(className));
                        continue;
                    }
                    this.columnTypes.add(String.class);
                }
            }
            NodeList rows = this.evaluateNodeList(xPath, xPathExpression, xmlResource, resourceManager);
            HashMap<String, Integer> columnNamesToPositionMap = new HashMap<String, Integer>();
            int rowCount = rows.getLength();
            this.data = new GenericObjectTable(Math.max(1, rowCount), Math.max(1, this.columnTypes.size()));
            logger.debug((Object)("Processing " + rowCount + " rows"));
            for (int row = 0; row < rowCount && (maxRowsToProcess < 0 || (count = this.data.getRowCount()) <= 0 || count < maxRowsToProcess); ++row) {
                Node node = rows.item(row);
                if (node.getNodeType() != 1) continue;
                logger.debug((Object)("Processing row " + row));
                NodeList childNodes = node.getChildNodes();
                for (int column = 0; column < childNodes.getLength(); ++column) {
                    int columnPosition;
                    Node child = childNodes.item(column);
                    if (child.getNodeType() != 1) continue;
                    String columnName = child.getNodeName();
                    String textContent = this.extractText(child);
                    Integer rawPos = (Integer)columnNamesToPositionMap.get(columnName);
                    if (rawPos == null) {
                        columnPosition = this.columnNames.size();
                        this.columnNames.add(columnName);
                        columnNamesToPositionMap.put(columnName, IntegerCache.getInteger((int)columnPosition));
                    } else {
                        columnPosition = rawPos;
                    }
                    logger.debug((Object)("Processing column " + columnPosition + " Name=" + columnName + " value=" + textContent));
                    Class columnClass = columnPosition < this.columnTypes.size() ? (Class)this.columnTypes.get(columnPosition) : String.class;
                    if (String.class.equals(columnClass)) {
                        this.data.setObject(row, columnPosition, (Object)textContent);
                        continue;
                    }
                    if (columnClass == Date.class) {
                        this.data.setObject(row, columnPosition, (Object)new Date(Long.parseLong(textContent)));
                        continue;
                    }
                    if (columnClass == BigDecimal.class) {
                        this.data.setObject(row, columnPosition, (Object)new BigDecimal(textContent));
                        continue;
                    }
                    if (columnClass == Timestamp.class) {
                        this.data.setObject(row, columnPosition, (Object)new Timestamp(Long.parseLong(textContent)));
                        continue;
                    }
                    if (columnClass == Integer.class) {
                        this.data.setObject(row, columnPosition, (Object)Integer.valueOf(textContent));
                        continue;
                    }
                    if (columnClass == Double.class) {
                        this.data.setObject(row, columnPosition, (Object)Double.valueOf(textContent));
                        continue;
                    }
                    if (columnClass == Long.class) {
                        this.data.setObject(row, columnPosition, (Object)Long.valueOf(textContent));
                        continue;
                    }
                    this.data.setObject(row, columnPosition, (Object)textContent);
                }
            }
        }
        catch (Exception e) {
            throw new ReportDataFactoryException("Failed to query XPath datasource", (Throwable)e);
        }
    }

    private String computeColDeclaration(ResourceData xmlResource, ResourceManager resourceManager, XPath xPath) throws XPathExpressionException, ResourceLoadingException, IOException {
        String text;
        String text2;
        String text3;
        Node pi = this.evaluateNode(xPath, "/processing-instruction('pentaho-dataset')", xmlResource, resourceManager);
        if (pi != null && (text3 = pi.getNodeValue()).length() > 0) {
            return text3;
        }
        Node types = this.evaluateNode(xPath, "/comment()", xmlResource, resourceManager);
        if (types != null && (text2 = types.getNodeValue()).length() > 0) {
            return text2;
        }
        Node resultsetComment = this.evaluateNode(xPath, "/result-set/comment()", xmlResource, resourceManager);
        if (resultsetComment != null && (text = resultsetComment.getNodeValue()).length() > 0) {
            return text;
        }
        return null;
    }

    private String extractText(Node child) {
        NodeList contentNodes = child.getChildNodes();
        StringBuilder textContent = new StringBuilder(32);
        for (int k = 0; k < contentNodes.getLength(); ++k) {
            Node t = contentNodes.item(k);
            if (t.getNodeType() != 3) continue;
            textContent.append(t.getNodeValue());
        }
        return textContent.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeList evaluateNodeList(XPath xpath, String xpathQuery, ResourceData xmlResourceData, ResourceManager resourceManager) throws XPathExpressionException, ResourceLoadingException, IOException {
        InputStream stream = xmlResourceData.getResourceAsStream(resourceManager);
        try {
            NodeList nodeList = (NodeList)xpath.evaluate(xpathQuery, new InputSource(stream), XPathConstants.NODESET);
            return nodeList;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node evaluateNode(XPath xpath, String xpathQuery, ResourceData xmlResourceData, ResourceManager resourceManager) throws XPathExpressionException, ResourceLoadingException, IOException {
        InputStream stream = xmlResourceData.getResourceAsStream(resourceManager);
        try {
            Node node = (Node)xpath.evaluate(xpathQuery, new InputSource(stream), XPathConstants.NODE);
            return node;
        }
        finally {
            stream.close();
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex < this.columnTypes.size()) {
            return (Class)this.columnTypes.get(columnIndex);
        }
        return String.class;
    }

    public int getRowCount() {
        return this.data.getRowCount();
    }

    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public String getColumnName(int column) {
        return (String)this.columnNames.get(column);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.data.getObject(rowIndex, columnIndex);
    }

    static {
        HashMap<String, Class<Long>> types = new HashMap<String, Class<Long>>();
        types.put("java.lang.String", String.class);
        types.put("java.sql.Date", Date.class);
        types.put("java.math.BigDecimal", BigDecimal.class);
        types.put("java.sql.Timestamp", Timestamp.class);
        types.put("java.lang.Integer", Integer.class);
        types.put("java.lang.Double", Double.class);
        types.put("java.lang.Long", Long.class);
        SUPPORTED_TYPES = Collections.unmodifiableMap(types);
    }

    private static class InternalXPathVariableResolver
    implements XPathVariableResolver {
        private final DataRow parameters;

        private InternalXPathVariableResolver(DataRow parameters) {
            this.parameters = parameters;
        }

        public Object resolveVariable(QName variableName) {
            if (this.parameters != null) {
                String var = variableName.getLocalPart();
                return this.parameters.get(var);
            }
            return null;
        }
    }
}

