/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.xpath.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.extensions.datasources.xpath.XPathDataFactory;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class XPathDataFactoryBundleWriteHandler
implements BundleDataFactoryWriterHandler {
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/xpath-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription(ClassicEngineBoot.getInstance().getGlobalConfig(), "org.pentaho.reporting.engine.classic.extensions.datasources.xpath.tag-def.");
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/xpath");
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/xpath", "xpath-datasource", rootAttrs, false);
        XPathDataFactory pmdDataFactory = (XPathDataFactory)dataFactory;
        AttributeList configAttrs = new AttributeList();
        configAttrs.setAttribute("http://reporting.pentaho.org/namespaces/datasources/xpath", "source-file", String.valueOf(pmdDataFactory.getXqueryDataFile()));
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/xpath", "config", configAttrs, true);
        String[] queryNames = pmdDataFactory.getQueryNames();
        for (int i = 0; i < queryNames.length; ++i) {
            String queryName = queryNames[i];
            String query = pmdDataFactory.getQuery(queryName);
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/xpath", "query", "name", queryName, false);
            xmlWriter.writeTextNormalized(query, false);
            xmlWriter.writeCloseTag();
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }
}

