/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.ObjectExistsException;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.TerracottaConfigConfiguration;
import net.sf.ehcache.config.generator.ConfigurationSource;
import net.sf.ehcache.transaction.manager.DefaultTransactionManagerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Configuration {
    private String cacheManagerName;
    private boolean updateCheck = true;
    private Monitoring monitoring = Monitoring.AUTODETECT;
    private DiskStoreConfiguration diskStoreConfiguration;
    private CacheConfiguration defaultCacheConfiguration;
    private List<FactoryConfiguration> cacheManagerPeerProviderFactoryConfiguration = new ArrayList<FactoryConfiguration>();
    private List<FactoryConfiguration> cacheManagerPeerListenerFactoryConfiguration = new ArrayList<FactoryConfiguration>();
    private FactoryConfiguration transactionManagerLookupConfiguration;
    private FactoryConfiguration cacheManagerEventListenerFactoryConfiguration;
    private TerracottaConfigConfiguration terracottaConfigConfiguration;
    private final Map<String, CacheConfiguration> cacheConfigurations = new HashMap<String, CacheConfiguration>();
    private ConfigurationSource configurationSource;
    private boolean dynamicConfig = true;

    private FactoryConfiguration getDefaultTransactionManagerLookupConfiguration() {
        FactoryConfiguration configuration = new FactoryConfiguration();
        configuration.setClass(DefaultTransactionManagerLookup.class.getName());
        return configuration;
    }

    public final void setName(String name) {
        this.cacheManagerName = name;
    }

    public final String getName() {
        return this.cacheManagerName;
    }

    public final void setUpdateCheck(boolean updateCheck) {
        this.updateCheck = updateCheck;
    }

    public final boolean getUpdateCheck() {
        return this.updateCheck;
    }

    public final void setMonitoring(String monitoring) {
        if (monitoring == null) {
            throw new IllegalArgumentException("Monitoring value must be non-null");
        }
        this.monitoring = Monitoring.valueOf(Monitoring.class, monitoring.toUpperCase());
    }

    public final Monitoring getMonitoring() {
        return this.monitoring;
    }

    public final void setDynamicConfig(boolean dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public final boolean getDynamicConfig() {
        return this.dynamicConfig;
    }

    public final void addDiskStore(DiskStoreConfiguration diskStoreConfigurationParameter) throws ObjectExistsException {
        if (this.diskStoreConfiguration != null) {
            throw new ObjectExistsException("The Disk Store has already been configured");
        }
        this.diskStoreConfiguration = diskStoreConfigurationParameter;
    }

    public final void addTransactionManagerLookup(FactoryConfiguration transactionManagerLookupParameter) throws ObjectExistsException {
        if (this.transactionManagerLookupConfiguration != null) {
            throw new ObjectExistsException("The TransactionManagerLookup class has already been configured");
        }
        this.transactionManagerLookupConfiguration = transactionManagerLookupParameter;
    }

    public final void addCacheManagerEventListenerFactory(FactoryConfiguration cacheManagerEventListenerFactoryConfiguration) throws ObjectExistsException {
        if (this.cacheManagerEventListenerFactoryConfiguration == null) {
            this.cacheManagerEventListenerFactoryConfiguration = cacheManagerEventListenerFactoryConfiguration;
        }
    }

    public final void addCacheManagerPeerProviderFactory(FactoryConfiguration factory) {
        this.cacheManagerPeerProviderFactoryConfiguration.add(factory);
    }

    public final void addCacheManagerPeerListenerFactory(FactoryConfiguration factory) {
        this.cacheManagerPeerListenerFactoryConfiguration.add(factory);
    }

    public final void addTerracottaConfig(TerracottaConfigConfiguration terracottaConfiguration) {
        this.terracottaConfigConfiguration = terracottaConfiguration;
    }

    public final void addDefaultCache(CacheConfiguration defaultCacheConfiguration) throws ObjectExistsException {
        if (this.defaultCacheConfiguration != null) {
            throw new ObjectExistsException("The Default Cache has already been configured");
        }
        this.defaultCacheConfiguration = defaultCacheConfiguration;
    }

    public final void addCache(CacheConfiguration cacheConfiguration) throws ObjectExistsException {
        if (this.cacheConfigurations.get(cacheConfiguration.name) != null) {
            throw new ObjectExistsException("Cannot create cache: " + cacheConfiguration.name + " with the same name as an existing one.");
        }
        if (cacheConfiguration.name.equalsIgnoreCase("default")) {
            throw new ObjectExistsException("The Default Cache has already been configured");
        }
        this.cacheConfigurations.put(cacheConfiguration.name, cacheConfiguration);
    }

    public final Set<String> getCacheConfigurationsKeySet() {
        return this.cacheConfigurations.keySet();
    }

    public final CacheConfiguration getDefaultCacheConfiguration() {
        return this.defaultCacheConfiguration;
    }

    public final void setDefaultCacheConfiguration(CacheConfiguration defaultCacheConfiguration) {
        this.defaultCacheConfiguration = defaultCacheConfiguration;
    }

    public final DiskStoreConfiguration getDiskStoreConfiguration() {
        return this.diskStoreConfiguration;
    }

    public final FactoryConfiguration getTransactionManagerLookupConfiguration() {
        if (this.transactionManagerLookupConfiguration == null) {
            return this.getDefaultTransactionManagerLookupConfiguration();
        }
        return this.transactionManagerLookupConfiguration;
    }

    public final List<FactoryConfiguration> getCacheManagerPeerProviderFactoryConfiguration() {
        return this.cacheManagerPeerProviderFactoryConfiguration;
    }

    public final List<FactoryConfiguration> getCacheManagerPeerListenerFactoryConfigurations() {
        return this.cacheManagerPeerListenerFactoryConfiguration;
    }

    public final FactoryConfiguration getCacheManagerEventListenerFactoryConfiguration() {
        return this.cacheManagerEventListenerFactoryConfiguration;
    }

    public final TerracottaConfigConfiguration getTerracottaConfiguration() {
        return this.terracottaConfigConfiguration;
    }

    public final Map<String, CacheConfiguration> getCacheConfigurations() {
        return this.cacheConfigurations;
    }

    public final void setSource(ConfigurationSource configurationSource) {
        this.configurationSource = configurationSource;
    }

    public final ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Monitoring {
        AUTODETECT,
        ON,
        OFF;

    }
}

