/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.marketplace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionData
implements Comparable<VersionData> {
    int major;
    int minor;
    int patch;
    String info;

    public VersionData(String info) {
        int majorStop;
        this.info = info;
        if (this.info == null) {
            this.info = "";
        }
        if ((majorStop = this.info.indexOf(".")) >= 0) {
            try {
                this.major = Integer.parseInt(this.info.substring(0, majorStop));
            }
            catch (Exception e) {
                this.major = Integer.MAX_VALUE;
                this.minor = Integer.MAX_VALUE;
                this.patch = Integer.MAX_VALUE;
                return;
            }
            int minorStop = this.info.indexOf(".", majorStop + 1);
            if (minorStop >= 0) {
                try {
                    this.minor = Integer.parseInt(this.info.substring(majorStop + 1, minorStop));
                }
                catch (Exception e) {
                    this.minor = Integer.MAX_VALUE;
                    this.patch = Integer.MAX_VALUE;
                    return;
                }
                int patchStop = this.info.indexOf(".", minorStop + 1);
                if (patchStop < 0) {
                    patchStop = this.info.indexOf("-", minorStop + 1);
                }
                if (patchStop < 0) {
                    patchStop = this.info.length();
                }
                try {
                    this.patch = Integer.parseInt(this.info.substring(minorStop + 1, patchStop));
                }
                catch (Exception e) {
                    this.patch = Integer.MAX_VALUE;
                    return;
                }
            }
            minorStop = this.info.indexOf("-", majorStop + 1);
            if (minorStop >= 0) {
                try {
                    this.minor = Integer.parseInt(this.info.substring(majorStop + 1, minorStop));
                }
                catch (Exception e) {
                    this.minor = Integer.MAX_VALUE;
                    this.patch = Integer.MAX_VALUE;
                    return;
                }
                this.patch = Integer.MAX_VALUE;
                return;
            }
            minorStop = this.info.length();
            try {
                this.minor = Integer.parseInt(this.info.substring(majorStop + 1, minorStop));
            }
            catch (Exception e) {
                this.minor = Integer.MAX_VALUE;
                this.patch = Integer.MAX_VALUE;
                return;
            }
            this.patch = 0;
            return;
        }
        majorStop = this.info.indexOf("-");
        if (majorStop >= 0) {
            try {
                this.major = Integer.parseInt(this.info.substring(0, majorStop));
            }
            catch (Exception e) {
                this.major = Integer.MAX_VALUE;
                this.minor = Integer.MAX_VALUE;
                this.patch = Integer.MAX_VALUE;
                return;
            }
            this.minor = Integer.MAX_VALUE;
            this.patch = Integer.MAX_VALUE;
            return;
        }
        try {
            this.major = Integer.parseInt(this.info);
        }
        catch (Exception e) {
            this.major = Integer.MAX_VALUE;
            this.minor = Integer.MAX_VALUE;
            this.patch = Integer.MAX_VALUE;
            return;
        }
        this.minor = 0;
        this.patch = 0;
        return;
    }

    public boolean within(VersionData min, VersionData max) {
        if (min.info.equals("") && max.info.equals("")) {
            return true;
        }
        if (min.info.equals(max.info)) {
            return this.info.equals(min.info);
        }
        return this.compareTo(min) <= 0 && this.compareTo(max) >= 0;
    }

    @Override
    public int compareTo(VersionData arg0) {
        if (arg0.major > this.major) {
            return 1;
        }
        if (arg0.major < this.major) {
            return -1;
        }
        if (arg0.minor > this.minor) {
            return 1;
        }
        if (arg0.minor < this.minor) {
            return -1;
        }
        if (arg0.patch > this.patch) {
            return 1;
        }
        if (arg0.patch < this.patch) {
            return -1;
        }
        return 0;
    }
}

