/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.telemetry;

import flexjson.JSONSerializer;
import java.io.Serializable;
import java.util.Map;
import org.pentaho.telemetry.ITelemetryDataProvider;
import org.pentaho.telemetry.TelemetryHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TelemetryEvent
implements Serializable {
    private String urlToCall;
    private String pluginName;
    private String pluginVersion;
    private String platformVersion;
    private long eventTimestamp;
    private TelemetryHelper.TelemetryEventType eventType;
    private Map<String, String> extraInfo;

    public TelemetryEvent(ITelemetryDataProvider dataProvider) {
        this.urlToCall = dataProvider.getBaseUrl();
        this.eventType = dataProvider.getEventType();
        this.pluginName = dataProvider.getPluginName();
        this.pluginVersion = dataProvider.getPluginVersion();
        this.platformVersion = dataProvider.getPlatformVersion();
        this.extraInfo = dataProvider.getExtraInformation();
        this.eventTimestamp = System.currentTimeMillis();
    }

    public String encodeEvent() {
        JSONSerializer serializer = new JSONSerializer();
        return serializer.deepSerialize((Object)this);
    }

    public String getUrlToCall() {
        return this.urlToCall;
    }

    public void setUrlToCall(String urlToCall) {
        this.urlToCall = urlToCall;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPluginVersion() {
        return this.pluginVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public long getEventTimestamp() {
        return this.eventTimestamp;
    }

    public TelemetryHelper.TelemetryEventType getEventType() {
        return this.eventType;
    }

    public Map<String, String> getExtraInfo() {
        return this.extraInfo;
    }
}

