/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterPluginComms {
    private static final Log logger = LogFactory.getLog(InterPluginComms.class);

    public static String callPlugin(Plugin plugin, String method, Map<String, Object> params) {
        return InterPluginComms.callPlugin(plugin, method, params, false);
    }

    public static String callPlugin(Plugin plugin, String method, Map<String, Object> params, boolean switchClassLoader) {
        SimpleParameterProvider requestParams = new SimpleParameterProvider(params);
        return InterPluginComms.callPlugin(plugin, method, (IParameterProvider)requestParams, switchClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String callPlugin(Plugin plugin, String method, IParameterProvider params, boolean switchClassLoader) {
        IContentGenerator contentGenerator;
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        IPluginManager pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)userSession);
        try {
            contentGenerator = pluginManager.getContentGenerator(plugin.getName(), userSession);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to acquire " + plugin.getName() + " plugin: " + e.toString()));
            return null;
        }
        if (contentGenerator == null) {
            logger.error((Object)("Failed to acquire " + plugin.getName() + " plugin."));
            return null;
        }
        if (switchClassLoader) {
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader pluginClassLoader = pluginManager.getClassLoader(plugin.getTitle());
                if (pluginClassLoader != null) {
                    Thread.currentThread().setContextClassLoader(pluginClassLoader);
                } else {
                    logger.error((Object)("Couldn't fetch PluginClassLoader for " + plugin.getTitle()));
                }
                String string = InterPluginComms.callPlugin(userSession, contentGenerator, method, params);
                return string;
            }
            finally {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return InterPluginComms.callPlugin(userSession, contentGenerator, method, params);
    }

    public static String callPlugin(IPentahoSession userSession, IContentGenerator contentGenerator, String method, Map<String, Object> params) {
        SimpleParameterProvider requestParams = new SimpleParameterProvider(params);
        return InterPluginComms.callPlugin(userSession, contentGenerator, method, (IParameterProvider)requestParams);
    }

    public static String callPlugin(IPentahoSession userSession, IContentGenerator contentGenerator, String method, IParameterProvider params) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        IParameterProvider requestParams = params;
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("path", "/" + method);
        SimpleParameterProvider pathParams = new SimpleParameterProvider(pathMap);
        HashMap<String, IParameterProvider> paramProvider = new HashMap<String, IParameterProvider>();
        paramProvider.put("request", requestParams);
        paramProvider.put("path", (IParameterProvider)pathParams);
        return InterPluginComms.callPlugin(userSession, contentGenerator, outputStream, paramProvider);
    }

    public static String callPlugin(IPentahoSession userSession, IContentGenerator contentGenerator, OutputStream outputStream, Map<String, IParameterProvider> paramProvider) {
        SimpleOutputHandler outputHandler = new SimpleOutputHandler(outputStream, false);
        try {
            contentGenerator.setSession(userSession);
            contentGenerator.setOutputHandler((IOutputHandler)outputHandler);
            contentGenerator.setParameterProviders(paramProvider);
            contentGenerator.createContent();
            return outputStream.toString();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to execute call to plugin: " + e.toString()));
            return null;
        }
    }

    public static class Plugin {
        public static final Plugin CDA = new Plugin("cda", "cda");
        public static final Plugin CDE = new Plugin("pentaho-cdf-dd", "pentaho-cdf-dd");
        public static final Plugin CDC = new Plugin("cdc", "cdc");
        public static final Plugin CDF = new Plugin("pentaho-cdf", "Pentaho Community Dashboard Framework");
        private String name;
        private String title;

        public String getName() {
            return this.name;
        }

        public String getTitle() {
            return this.title;
        }

        public Plugin(String name, String title) {
            this.name = name;
            this.title = title;
        }
    }
}

