/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.analyzer.report;

import com.pentaho.analyzer.content.yf;
import com.pentaho.analyzer.report.ep;
import com.pentaho.analyzer.report.eu;
import com.pentaho.analyzer.report.fx;
import com.pentaho.analyzer.report.lw;
import com.pentaho.analyzer.report.rk;
import com.pentaho.analyzer.report.vu;
import com.pentaho.analyzer.report.y;
import com.pentaho.analyzer.report.yb;
import com.pentaho.analyzer.service.gm;
import com.pentaho.analyzer.service.mc;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jmx.export.annotation.ManagedAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportRequestService
implements Serializable {
    private static final long serialVersionUID = 1795687283078096566L;
    gm pl;
    mc appContext;
    static Log log = LogFactory.getLog(ReportRequestService.class);
    private long oo = 0L;
    private Map<String, yb> bt;
    private ThreadPoolExecutor xv;
    private int ix;
    private int m;

    public ReportRequestService(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m = n5;
        this.ix = n6;
        this.bt = new ConcurrentHashMap<String, yb>();
        this.reconfigure(n, n2, n3, n4);
    }

    public void reconfigure(int n, int n2, int n3, int n4) {
        ArrayBlockingQueue<Runnable> arrayBlockingQueue = new ArrayBlockingQueue<Runnable>(n);
        ThreadFactory threadFactory = new ThreadFactory(){
            private AtomicInteger we = new AtomicInteger();

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("Analyzer ReportRequestService-" + this.we.incrementAndGet());
                return thread;
            }
        };
        this.xv = new ThreadPoolExecutor(n2, n3, (long)n4, TimeUnit.SECONDS, arrayBlockingQueue, threadFactory);
    }

    public void setReportManager(gm gm2) {
        this.pl = gm2;
    }

    public boolean cancel(String string) {
        yb yb2 = this.bt.get(string);
        if (yb2 == null) {
            String string2 = "Unable to find report with request key: " + string;
            log.debug((Object)string2);
            throw new IllegalStateException(string2);
        }
        if (yb2 != null) {
            this.bt.remove(string);
            return yb2.cancel();
        }
        return false;
    }

    public vu get(String string) {
        return this.get(string, -1);
    }

    public vu get(String string, int n) {
        return this.get(string, n, true);
    }

    public vu get(String string, int n, boolean bl) {
        vu vu2;
        yb yb2 = this.bt.get(string);
        if (yb2 == null) {
            String string2 = "Unable to find report with request key: " + string;
            log.debug((Object)string2);
            throw new IllegalStateException(string2);
        }
        lw lw2 = yb2.uz();
        try {
            vu2 = n == -1 ? (vu)yb2.get() : (vu)yb2.get(n, TimeUnit.SECONDS);
        }
        catch (TimeoutException timeoutException) {
            log.debug((Object)("TimeoutException: " + lw2.toString()));
            return null;
        }
        catch (InterruptedException interruptedException) {
            this.bt.remove(string);
            log.debug((Object)("InterruptedException: " + lw2.toString()));
            throw new fx(yb2.uz());
        }
        catch (CancellationException cancellationException) {
            this.bt.remove(string);
            log.debug((Object)("CancellationException: " + lw2.toString()));
            throw new fx(yb2.uz());
        }
        catch (ExecutionException executionException) {
            this.bt.remove(string);
            if (yb2.isCancelled()) {
                log.debug((Object)("ExecutionException: " + lw2.toString()));
                throw new fx(yb2.uz());
            }
            log.debug((Object)("ExecutionException: " + lw2.toString()), (Throwable)executionException);
            if (executionException.getCause() instanceof eu) {
                throw (eu)executionException.getCause();
            }
            if (executionException.getCause() instanceof ep) {
                throw (ep)executionException.getCause();
            }
            if (executionException.getCause() instanceof fx) {
                throw (fx)executionException.getCause();
            }
            if (executionException.getCause() instanceof y) {
                throw (y)executionException.getCause();
            }
            throw new RuntimeException(executionException);
        }
        assert (vu2 != null);
        if (bl) {
            this.bt.remove(string);
        }
        return vu2;
    }

    public vu runReportSync(yf yf2, rk rk2) {
        lw lw2 = this.pl.createReportRequest(yf2, rk2);
        vu vu2 = this.pl.runReport(lw2);
        return vu2;
    }

    public String validateCalculatedMeasure(yf yf2, rk rk2, String string) {
        String string2 = this.pl.validateCalculatedMeasure(yf2, rk2, string);
        return string2;
    }

    public String runReport(yf yf2, rk rk2) {
        final lw lw2 = this.pl.createReportRequest(yf2, rk2);
        Callable<vu> callable = new Callable<vu>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public vu ex() throws Exception {
                vu vu2;
                ReportRequestService.this.appContext.setSession(lw2.getSession());
                try {
                    vu2 = ReportRequestService.this.pl.runReport(lw2);
                }
                finally {
                    if (Thread.interrupted()) {
                        log.info((Object)("Cancel Complete: " + lw2.toString()));
                    }
                }
                return vu2;
            }
        };
        return this.createAndExecuteFuture(callable, lw2);
    }

    private String createAndExecuteFuture(Callable<vu> callable, lw lw2) {
        yb yb2 = new yb(callable, lw2);
        String string = lw2.getID();
        this.bt.put(string, yb2);
        this.cleanupFutureMap();
        this.xv.execute(yb2);
        return string;
    }

    public String getMembers(yf yf2, rk rk2, String string, boolean bl) {
        final lw lw2 = this.pl.createReportRequest(yf2, rk2);
        final String string2 = string;
        final boolean bl2 = bl;
        final int n = this.appContext.getIntProperty("filter.members.max.count", 200);
        Callable<vu> callable = new Callable<vu>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public vu ex() throws Exception {
                vu vu2;
                ReportRequestService.this.appContext.setSession(lw2.getSession());
                try {
                    vu2 = ReportRequestService.this.pl.getMembers(lw2, string2, bl2, false, n);
                }
                finally {
                    if (Thread.interrupted()) {
                        log.info((Object)("Cancel Complete: " + lw2.toString()));
                    }
                }
                return vu2;
            }
        };
        return this.createAndExecuteFuture(callable, lw2);
    }

    private void cleanupFutureMap() {
        long l = System.currentTimeMillis();
        if (l - this.oo > (long)(this.ix * 1000)) {
            Iterator<Map.Entry<String, yb>> iterator = this.bt.entrySet().iterator();
            while (iterator.hasNext()) {
                yb yb2 = iterator.next().getValue();
                if (!yb2.isDone() || l - yb2.az() <= (long)(this.m * 1000)) continue;
                log.debug((Object)("Remove expired result:" + yb2.uz().toString()));
                iterator.remove();
            }
            this.oo = l;
        }
    }

    public void cancel(yf yf2) {
        Iterator<Map.Entry<String, yb>> iterator = this.bt.entrySet().iterator();
        while (iterator.hasNext()) {
            yb yb2 = iterator.next().getValue();
            yf yf3 = yb2.uz().oz();
            if (yf3 == null || !yf2.getCatalog().equals(yf3.getCatalog())) continue;
            yb2.cancel();
        }
    }

    public void shutdown(int n) {
        Iterator<Map.Entry<String, yb>> iterator = this.bt.entrySet().iterator();
        while (iterator.hasNext()) {
            yb yb2 = iterator.next().getValue();
            yb2.cancel();
        }
        this.xv.shutdown();
    }

    public void setCVAppContext(mc mc2) {
        this.appContext = mc2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        ThreadPoolExecutor threadPoolExecutor = this.xv;
        stringBuilder.append(ReportRequestService.class.getName() + " | ");
        stringBuilder.append("total task:" + threadPoolExecutor.getTaskCount() + " | ");
        stringBuilder.append("active task:" + threadPoolExecutor.getActiveCount() + " | ");
        stringBuilder.append("completed task:" + threadPoolExecutor.getCompletedTaskCount());
        return stringBuilder.toString();
    }

    @ManagedAttribute(description="When a new request is submitted, if clean up interval has elapsed, then perform clean up of prior abandoned requests.")
    public int getResultCleanupSec() {
        return this.ix;
    }

    public void setResultCleanupSec(int n) {
        this.ix = n;
    }

    @ManagedAttribute(description="A request is considered abandoned when it is completed/done and no one has retrieved it's results.")
    public int getResultExpireSec() {
        return this.m;
    }

    public void setResultExpireSec(int n) {
        this.m = n;
    }

    @ManagedAttribute
    public int getActiveCount() {
        return this.xv.getActiveCount();
    }

    @ManagedAttribute
    public int getCorePoolSize() {
        return this.xv.getCorePoolSize();
    }

    @ManagedAttribute
    public int getLargestPoolSize() {
        return this.xv.getLargestPoolSize();
    }

    @ManagedAttribute
    public int getMaximumPoolSize() {
        return this.xv.getMaximumPoolSize();
    }

    @ManagedAttribute
    public long getKeepAliveTimeSec() {
        return this.xv.getKeepAliveTime(TimeUnit.SECONDS);
    }

    @ManagedAttribute
    public int getPoolSize() {
        return this.xv.getPoolSize();
    }

    @ManagedAttribute(description="Total number of requests that have been processed.")
    public long getTaskCount() {
        return this.xv.getTaskCount();
    }

    @ManagedAttribute
    public long getQueueSize() {
        return this.xv.getQueue().size();
    }

    @ManagedAttribute
    public long getQueueRemainingCapacity() {
        return this.xv.getQueue().remainingCapacity();
    }

    @ManagedAttribute(description="Size of request ID to future task map.  Should be equals to activeCount + queueSize")
    public long getFuturesMapSize() {
        return this.bt.size();
    }
}

