/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.analyzer.service;

import com.pentaho.analyzer.content.AnalyzerContentGenerator;
import com.pentaho.analyzer.report.rk;
import com.pentaho.analyzer.report.zl;
import com.pentaho.analyzer.schema.report.Attribute;
import com.pentaho.analyzer.schema.report.Filter;
import com.pentaho.analyzer.schema.report.Measure;
import com.pentaho.analyzer.schema.report.Path;
import com.pentaho.analyzer.service.impl.AnalysisAreaManager;
import java.io.Serializable;
import java.util.HashSet;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.audit.AuditHelper;

public class UsageTrackingService
implements Serializable {
    private static final long serialVersionUID = 2282682602780539952L;
    private AnalysisAreaManager kj;
    private static final String wv = "Analyzer";

    private String getMeasureLabel(Measure measure) {
        return measure.getFormula();
    }

    private String getAttributeLabel(Attribute attribute) {
        return attribute.getFormula();
    }

    private String createReportDefinitionSummary(rk rk2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Measure object : rk2.mu()) {
            hashSet.add(this.getMeasureLabel(object));
        }
        for (Attribute attribute : rk2.fk()) {
            hashSet.add(this.getAttributeLabel(attribute));
        }
        for (Attribute attribute : rk2.dt()) {
            hashSet.add(this.getAttributeLabel(attribute));
        }
        if (rk2.getFilters() != null) {
            for (Filter filter : rk2.getFilters()) {
                hashSet.add(filter.getFormula());
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(rk2.getCatalog()).append("~").append(rk2.getCube());
        for (String string : hashSet) {
            stringBuffer.append("~");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void logRunReport(IPentahoSession iPentahoSession, rk rk2) {
        zl zl2 = rk2.v();
        AuditHelper.audit((String)iPentahoSession.getId(), (String)iPentahoSession.getName(), (String)this.getPath(rk2), (String)AnalyzerContentGenerator.class.getName(), (String)wv, (String)"instance_start", (String)zl2.iy(), (String)this.truncateTo1024(this.createReportDefinitionSummary(rk2)), (float)0.0f, null);
        AuditHelper.audit((String)iPentahoSession.getId(), (String)iPentahoSession.getName(), (String)this.getPath(rk2), (String)AnalyzerContentGenerator.class.getName(), (String)wv, (String)"instance_end", (String)zl2.iy(), (String)rk2.qj().toString(), (float)zl2.nt(), null);
    }

    public void logReportException(IPentahoSession iPentahoSession, rk rk2, String string) {
        zl zl2 = rk2.v();
        AuditHelper.audit((String)iPentahoSession.getId(), (String)iPentahoSession.getName(), (String)this.getPath(rk2), (String)AnalyzerContentGenerator.class.getName(), (String)wv, (String)"instance_start", (String)zl2.iy(), (String)this.truncateTo1024(this.createReportDefinitionSummary(rk2)), (float)0.0f, null);
        AuditHelper.audit((String)iPentahoSession.getId(), (String)iPentahoSession.getName(), (String)this.getPath(rk2), (String)AnalyzerContentGenerator.class.getName(), (String)wv, (String)"instance_failed", (String)zl2.iy(), (String)this.truncateTo1024(string), (float)zl2.nt(), null);
    }

    public void setAnalysisAreaManager(AnalysisAreaManager analysisAreaManager) {
        this.kj = analysisAreaManager;
    }

    private String getPath(rk rk2) {
        Path path = rk2.getCommonStorageAttributes().getPath();
        if (path != null && path.getFolder() != null && path.getFolder().length() != 0) {
            return path.getFolder();
        }
        return "New Analyzer Report";
    }

    private String truncateTo1024(String string) {
        if (string == null) {
            return null;
        }
        return string.substring(0, Math.min(1024, string.length()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum yf {
        jr,
        gq,
        dr,
        hw,
        ss;

    }
}

