/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.analyzer.service.impl;

import com.pentaho.analyzer.a.er;
import com.pentaho.analyzer.a.gm;
import com.pentaho.analyzer.b.a.px;
import com.pentaho.analyzer.report.b.dw;
import com.pentaho.analyzer.report.b.ve;
import com.pentaho.analyzer.report.ep;
import com.pentaho.analyzer.report.eu;
import com.pentaho.analyzer.report.fx;
import com.pentaho.analyzer.report.lw;
import com.pentaho.analyzer.report.rk;
import com.pentaho.analyzer.report.y;
import com.pentaho.analyzer.report.yl;
import com.pentaho.analyzer.schema.AttributeHelp;
import com.pentaho.analyzer.schema.CubeHelp;
import com.pentaho.analyzer.schema.MeasureHelp;
import com.pentaho.analyzer.schema.report.Attribute;
import com.pentaho.analyzer.schema.report.Filter;
import com.pentaho.analyzer.schema.report.Measure;
import com.pentaho.analyzer.schema.report.MeasureTypeEnum;
import com.pentaho.analyzer.schema.report.SortOrderEnum;
import com.pentaho.analyzer.schema.report.SummaryAcrossEnum;
import com.pentaho.analyzer.schema.report.TrendFacet;
import com.pentaho.analyzer.service.impl.OlapMetaDataManager;
import com.pentaho.analyzer.service.impl.yf;
import com.pentaho.analyzer.service.ju;
import com.pentaho.analyzer.service.mc;
import com.pentaho.analyzer.service.rk;
import com.pentaho.analyzer.service.zj;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Query;
import mondrian.olap.QueryTimeoutException;
import mondrian.olap.ResourceLimitExceededException;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.olap.fun.CustomizedFunctionTable;
import mondrian.olap.fun.MondrianEvaluationException;
import mondrian.olap.fun.ParenthesesFunDef;
import mondrian.rolap.RolapUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisAreaManager
implements Serializable {
    private static final long serialVersionUID = 1721378943284448227L;
    private static Log log = LogFactory.getLog(AnalysisAreaManager.class);
    private static Logger rolapUtilLogger = Logger.getLogger(RolapUtil.class);
    private mc appContext;
    private CustomizedFunctionTable cftab = null;
    private OlapMetaDataManager olapMetadataManager;
    private rk ls;

    public void setLocalizationService(rk rk2) {
        this.ls = rk2;
    }

    public rk getLocalizationService() {
        return this.ls;
    }

    public com.pentaho.analyzer.content.yf createOlapConnection(String string) {
        Connection connection = this.olapMetadataManager.getConnection(string);
        com.pentaho.analyzer.content.yf yf2 = new com.pentaho.analyzer.content.yf(string, connection);
        return yf2;
    }

    public yf getHelpGenerator(com.pentaho.analyzer.content.yf yf2) {
        return this.olapMetadataManager.getHelpGenerator(yf2);
    }

    public Cube getCube(Connection connection, String string) {
        Cube[] cubeArray = connection.getSchemaReader().withLocus().getCubes();
        Cube cube = null;
        for (Cube cube2 : cubeArray) {
            if (!er.co(cube2.getUniqueName()).equals(string)) continue;
            cube = cube2;
        }
        if (cube == null) {
            throw new zj(string);
        }
        return cube;
    }

    public List<Member> getLevelMembers(com.pentaho.analyzer.content.yf yf2, Level level) {
        log.debug((Object)("SchemaReader.getLevelMembers: " + level.getUniqueName()));
        return yf2.getConnection().getSchemaReader().withLocus().getLevelMembers(level, true);
    }

    public Member getMeasureMember(Cube cube, String string) {
        return cube.getSchemaReader(null).withLocus().getMemberByUniqueName(Util.parseIdentifier((String)string), true);
    }

    public AttributeHelp getAttributeHelp(com.pentaho.analyzer.content.yf yf2, String string, String string2) {
        return this.getHelpGenerator(yf2).ve(string, string2);
    }

    public CubeHelp getCubeHelp(com.pentaho.analyzer.content.yf yf2, String string) {
        return this.getHelpGenerator(yf2).qj(string);
    }

    public MeasureHelp getMeasureHelp(com.pentaho.analyzer.content.yf yf2, String string, String string2) {
        return this.getHelpGenerator(yf2).zl(string, string2);
    }

    public Level getHierarchyLevel(Cube cube, String string) {
        List list = Util.parseIdentifier((String)string);
        Hierarchy hierarchy = this.getHierarchy(cube, ((Id.Segment)list.get(0)).toString());
        Level[] levelArray = hierarchy.getLevels();
        String string2 = ve.yf(string, 1);
        string2 = ve.aw(string2);
        for (Level level : levelArray) {
            if (!level.getName().equals(string2)) continue;
            return level;
        }
        throw new ju(string);
    }

    public Hierarchy getHierarchy(Cube cube, String string) {
        Hierarchy hierarchy = null;
        block0: for (Dimension dimension : cube.getDimensions()) {
            Hierarchy[] hierarchyArray;
            for (Hierarchy hierarchy2 : hierarchyArray = dimension.getHierarchies()) {
                String string2 = hierarchy2.getUniqueName();
                if (!string2.equals(string)) continue;
                hierarchy = hierarchy2;
                continue block0;
            }
        }
        if (hierarchy == null) {
            throw new ju(string);
        }
        return hierarchy;
    }

    private Throwable processMondrianExceptions(lw lw2, Throwable throwable) {
        if (Thread.currentThread().isInterrupted()) {
            throw new fx(lw2);
        }
        while (true) {
            if (throwable instanceof ResourceLimitExceededException) {
                throw new eu(lw2, throwable);
            }
            if (throwable instanceof QueryTimeoutException) {
                throw new ep(lw2, throwable);
            }
            if (throwable instanceof MondrianEvaluationException) {
                throw new y(this.ls.getString("ReportErrorMissingAggregator", new Object[0]), throwable);
            }
            if (throwable.getCause() == null || throwable.equals(throwable.getCause())) break;
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public com.pentaho.analyzer.b.px executeQuery(lw lw2, com.pentaho.analyzer.report.rk rk2, yl yl2, String string) {
        Connection connection = lw2.getConnection();
        com.pentaho.analyzer.b.a.mc mc2 = null;
        try {
            StringWriter stringWriter;
            if (rolapUtilLogger.isDebugEnabled()) {
                rolapUtilLogger.debug((Object)string);
            }
            Query query = connection.parseQuery(string);
            if (rolapUtilLogger.isDebugEnabled()) {
                stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
                query.explain(printWriter);
                rolapUtilLogger.debug((Object)("Query Plan: " + stringWriter.toString()));
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new fx(lw2);
            }
            lw2.setQuery(query);
            rk2.v().xd();
            if (rk2.f() == rk.mc.M) {
                mc2 = new com.pentaho.analyzer.b.a.yf();
            } else {
                stringWriter = connection.execute(query);
                mc2 = new px((Result)stringWriter);
            }
            rk2.v().at();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = this.processMondrianExceptions(lw2, throwable);
            throw new RuntimeException(throwable2);
        }
        return mc2;
    }

    public String validateQuery(lw lw2, com.pentaho.analyzer.report.rk rk2, String string) {
        if (rolapUtilLogger.isDebugEnabled()) {
            rolapUtilLogger.debug((Object)string);
        }
        try {
            lw2.getConnection().parseQuery(string);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = this.processMondrianExceptions(lw2, throwable);
            return throwable2.getMessage();
        }
        return null;
    }

    private CustomizedFunctionTable getValidationFunctionTable() {
        if (this.cftab == null) {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("+");
            hashSet.add("-");
            hashSet.add("*");
            hashSet.add("/");
            HashSet<ParenthesesFunDef> hashSet2 = new HashSet<ParenthesesFunDef>();
            ParenthesesFunDef parenthesesFunDef = new ParenthesesFunDef(7);
            hashSet2.add(parenthesesFunDef);
            this.cftab = new CustomizedFunctionTable(hashSet, hashSet2);
            this.cftab.init();
        }
        return this.cftab;
    }

    public void setCVAppContext(mc mc2) {
        this.appContext = mc2;
    }

    public mc getCVAppContext() {
        return this.appContext;
    }

    public static String getAllMemberName(Level level) {
        if (!level.getHierarchy().hasAll()) {
            return null;
        }
        Member member = level.getHierarchy().getDefaultMember();
        return member.getUniqueName();
    }

    private String validateTrendMeasure(lw lw2) {
        Object object4;
        Object object2;
        com.pentaho.analyzer.report.rk rk2 = lw2.hd();
        com.pentaho.analyzer.content.yf yf2 = lw2.oz();
        String string = null;
        List<Measure> list = rk2.cj();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.addAll(rk2.fk());
        arrayList.addAll(rk2.dt());
        String string2 = rk2.getCube();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<Measure> arrayList3 = new ArrayList<Measure>();
        for (Measure object52 : list) {
            object2 = object52.getTrendFacet();
            if (object2 == null) continue;
            arrayList2.add(((TrendFacet)object2).getTrendAttributeFormula());
            arrayList3.add(object52);
        }
        if (arrayList3.size() == 0) {
            return null;
        }
        Cube cube = this.getCube(lw2.getConnection(), string2);
        List<Level> list2 = this.getLevelsForAttributes(arrayList, cube);
        object2 = rk2.getFilters();
        List<Filter> list3 = rk2.getFilters("[Measures]");
        ArrayList<Level> arrayList4 = new ArrayList<Level>();
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            Filter filter = (Filter)object3.next();
            if (list3.contains(filter) || list2.contains(object4 = this.getHierarchyLevel(cube, filter.getFormula()))) continue;
            arrayList4.add((Level)object4);
        }
        for (Level level : arrayList4) {
            for (String string3 : arrayList2) {
                Hierarchy hierarchy = this.getHierarchy(cube, ((Id.Segment)Util.parseIdentifier((String)string3).get(0)).toString());
                List<Level> list4 = Arrays.asList(hierarchy.getLevels());
                Level level2 = this.getHierarchyLevel(cube, string3);
                if (list4.indexOf(level) <= list4.indexOf(level2)) continue;
                string = this.ls.getString("ReportErrorTrendAboveNonVisualFilter", level.getName(), level2.getName());
                return string;
            }
        }
        object3 = new com.pentaho.analyzer.report.b.ju(rk2);
        for (Object object4 : arrayList3) {
            if (!((com.pentaho.analyzer.report.b.ju)object3).lb(((Measure)object4).getFormula())) continue;
            string = this.ls.getString("ReportErrorTrendOnSummary", new Object[0]);
            return string;
        }
        List<AttributeHelp> list5 = this.getCubeHelp(yf2, rk2.getCube()).getFieldHelp().getAttributeHelp();
        object4 = new HashSet();
        for (AttributeHelp attributeHelp : list5) {
            object4.add(ve.hd(attributeHelp.getFormula()));
        }
        for (Attribute attribute : arrayList) {
            object4.remove(ve.hd(attribute.getFormula()));
        }
        for (Filter filter : rk2.getFilters()) {
            object4.remove(ve.hd(filter.getFormula()));
        }
        if (object4.size() == 0) {
            string = this.ls.getString("ReportErrorTrendFreeDimension", new Object[0]);
        } else {
            lw2.eu((String)object4.iterator().next());
        }
        return string;
    }

    private String validateSummaryMeasure(com.pentaho.analyzer.report.rk rk2, Measure measure) {
        String string = null;
        Measure measure2 = null;
        MeasureTypeEnum measureTypeEnum = measure.getMeasureTypeEnum();
        if (ve.bb(measure.getFormula())) {
            measure2 = rk2.rc(measure.getFormula());
        }
        if (measure2 != null && (MeasureTypeEnum.PCTOF == measureTypeEnum || MeasureTypeEnum.PCTRSUM == measureTypeEnum)) {
            Object object;
            boolean bl = false;
            boolean bl2 = false;
            SummaryAcrossEnum summaryAcrossEnum = measure.getSummaryFacet().getSummaryAcrossEnum();
            if (summaryAcrossEnum == SummaryAcrossEnum.GRAND) {
                bl = true;
                bl2 = true;
            } else if (summaryAcrossEnum == SummaryAcrossEnum.COLS) {
                bl = true;
            } else if (summaryAcrossEnum == SummaryAcrossEnum.ROWS) {
                bl2 = true;
            } else {
                assert (summaryAcrossEnum == SummaryAcrossEnum.LABEL);
                object = measure.getSummaryFacet().getBreakAttributeFormula();
                if (rk2.tl((String)object)) {
                    bl = true;
                } else {
                    assert (rk2.ve((String)object));
                    bl2 = true;
                }
            }
            object = gm.mc(rk2, measure2, bl2, bl);
            if (object != null) {
                string = this.ls.getString("ReportErrorPCTSummaryRestriction", dw.yf(measureTypeEnum), dw.yf(((Measure)object).getMeasureTypeEnum()));
            }
        }
        return string;
    }

    public void validateReport(lw lw2) {
        Object object;
        com.pentaho.analyzer.report.rk rk2 = lw2.hd();
        com.pentaho.analyzer.content.yf yf2 = lw2.oz();
        if (rk2.getReportTypeEnum() == null) {
            throw new com.pentaho.analyzer.report.px("Report type should be specified");
        }
        CubeHelp cubeHelp = this.getCubeHelp(yf2, rk2.getCube());
        if (cubeHelp == null) {
            throw new zj(this.ls.getString("MissingCubeHelp", rk2.getCube(), rk2.getCatalog()));
        }
        if (cubeHelp.isHidden()) {
            throw new zj("Unable to access cube " + cubeHelp.getDisplayLabel() + " because it is hidden.");
        }
        List<Attribute> list = rk2.dt();
        List<Attribute> list2 = rk2.fk();
        List<Measure> list3 = rk2.mu();
        String string = rk2.getCube();
        for (Attribute serializable : list) {
            object = this.getAttributeHelp(yf2, string, serializable.getFormula());
            if (object == null) {
                throw new ju("Unable to find field help for " + serializable.getFormula());
            }
            if (!((AttributeHelp)object).getPresentationFieldHelp().isHidden()) continue;
            throw new ju("Unable to access field " + ((AttributeHelp)object).getPresentationFieldHelp().getDisplayLabel() + " because it is hidden.");
        }
        for (Attribute attribute : list2) {
            object = this.getAttributeHelp(yf2, string, attribute.getFormula());
            if (object == null) {
                throw new ju("Unable to find field help for " + attribute.getFormula());
            }
            if (!((AttributeHelp)object).getPresentationFieldHelp().isHidden()) continue;
            throw new ju("Unable to access field " + ((AttributeHelp)object).getPresentationFieldHelp().getDisplayLabel() + " because it is hidden.");
        }
        for (Measure measure : list3) {
            object = measure.getMeasureTypeEnum();
            if (measure.getSortOrderEnum() != SortOrderEnum.NONE) {
                gm.yf(rk2, measure, this.ls.getString("ReportErrorSortOnRSUM", new Object[0]));
            }
            if (object == MeasureTypeEnum.EXPRESSION) {
                for (String string2 : ve.ly(measure.getExpression())) {
                    MeasureHelp measureHelp = this.getMeasureHelp(yf2, string, string2);
                    if (measureHelp == null) {
                        throw new ju("Unable to find field help for " + string2);
                    }
                    if (!measureHelp.getPresentationFieldHelp().isHidden()) continue;
                    throw new ju("Formula '" + measure.getExpression() + "' contains invalid measure references '" + string2 + "'");
                }
                continue;
            }
            String string3 = this.validateSummaryMeasure(rk2, measure);
            if (string3 != null) {
                throw new y(string3);
            }
            if (ve.bb(measure.getFormula())) continue;
            MeasureHelp measureHelp = this.getMeasureHelp(yf2, string, measure.getFormula());
            if (measureHelp == null) {
                throw new ju("Unable to find field help for " + measure.getFormula());
            }
            if (!measureHelp.getPresentationFieldHelp().isHidden()) continue;
            throw new ju("Unable to access field " + measureHelp.getPresentationFieldHelp().getDisplayLabel() + " because it is hidden.");
        }
        String string3 = this.validateTrendMeasure(lw2);
        if (string3 != null) {
            throw new y(string3);
        }
    }

    private List<Level> getLevelsForAttributes(List<Attribute> list, Cube cube) {
        ArrayList<Level> arrayList = new ArrayList<Level>();
        for (Attribute attribute : list) {
            arrayList.add(this.getHierarchyLevel(cube, attribute.getFormula()));
        }
        return arrayList;
    }

    public void setOlapMetadataManager(OlapMetaDataManager olapMetaDataManager) {
        this.olapMetadataManager = olapMetaDataManager;
    }

    public boolean isParentChild(com.pentaho.analyzer.content.yf yf2, String string, String string2) {
        return this.getHelpGenerator(yf2).vu(string, string2);
    }

    public boolean isDrillLinkDisabled(com.pentaho.analyzer.content.yf yf2, String string) {
        boolean bl = this.getHelpGenerator(yf2).dc(string);
        if (bl) {
            return true;
        }
        return this.appContext.getBooleanProperty("report.drill.links.disabled", false);
    }
}

