/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.analyzer.service.impl;

import com.pentaho.analyzer.content.AnalyzerContentGenerator;
import com.pentaho.analyzer.service.mc;
import com.pentaho.analyzer.service.rk;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPluginResourceLoader;

public class LocalizationServiceImpl
implements rk,
Serializable {
    private static final long serialVersionUID = 375526348881699576L;
    private Pattern T = Pattern.compile("@\\{([\\w\\.]+)\\}");
    private mc appContext;

    public String translateTemplate(String string) {
        ResourceBundle resourceBundle = this.getBundle();
        Matcher matcher = this.T.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group();
            string2 = string2.substring(2, string2.length() - 1);
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(resourceBundle.getString(string2)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public ResourceBundle getBundle() {
        IPluginResourceLoader iPluginResourceLoader = this.appContext.getResLoader();
        ResourceBundle resourceBundle = iPluginResourceLoader.getResourceBundle(LocalizationServiceImpl.class, "resources/messages");
        String string = this.appContext.getProperty("localizationService.cache.resource.bundle");
        if (string != null && string.equals("false")) {
            ResourceBundle.clearCache();
        }
        return resourceBundle;
    }

    public String getString(String string, Object ... objectArray) {
        return MessageFormat.format(this.getBundle().getString(string), objectArray);
    }

    public String getTemplate(String string, boolean bl) {
        IPluginResourceLoader iPluginResourceLoader = this.appContext.getResLoader();
        String string2 = null;
        try {
            string2 = iPluginResourceLoader.getResourceAsString(AnalyzerContentGenerator.class, "templates/" + string);
            if (bl) {
                string2 = this.translateTemplate(string2);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.toString(), unsupportedEncodingException);
        }
        return string2;
    }

    public void setCVAppContext(mc mc2) {
        this.appContext = mc2;
    }

    public String getJSONBundle() {
        JSONObject jSONObject = new JSONObject();
        try {
            ResourceBundle resourceBundle = this.getBundle();
            for (String string : resourceBundle.keySet()) {
                jSONObject.put(string, (Object)resourceBundle.getString(string));
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString(), exception);
        }
        return jSONObject.toString();
    }
}

