/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.channel.socket.nio;

import java.util.concurrent.Executor;
import org.elasticsearch.common.netty.channel.ChannelPipeline;
import org.elasticsearch.common.netty.channel.socket.ClientSocketChannelFactory;
import org.elasticsearch.common.netty.channel.socket.SocketChannel;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketChannel;
import org.elasticsearch.common.netty.channel.socket.nio.NioClientSocketPipelineSink;
import org.elasticsearch.common.netty.channel.socket.nio.SelectorUtil;
import org.elasticsearch.common.netty.util.internal.ExecutorUtil;

public class NioClientSocketChannelFactory
implements ClientSocketChannelFactory {
    private final Executor bossExecutor;
    private final Executor workerExecutor;
    private final NioClientSocketPipelineSink sink;

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor) {
        this(bossExecutor, workerExecutor, SelectorUtil.DEFAULT_IO_THREADS);
    }

    public NioClientSocketChannelFactory(Executor bossExecutor, Executor workerExecutor, int workerCount) {
        if (bossExecutor == null) {
            throw new NullPointerException("bossExecutor");
        }
        if (workerExecutor == null) {
            throw new NullPointerException("workerExecutor");
        }
        if (workerCount <= 0) {
            throw new IllegalArgumentException("workerCount (" + workerCount + ") " + "must be a positive integer.");
        }
        this.bossExecutor = bossExecutor;
        this.workerExecutor = workerExecutor;
        this.sink = new NioClientSocketPipelineSink(bossExecutor, workerExecutor, workerCount);
    }

    public SocketChannel newChannel(ChannelPipeline pipeline) {
        return new NioClientSocketChannel(this, pipeline, this.sink, this.sink.nextWorker());
    }

    public void releaseExternalResources() {
        ExecutorUtil.terminate(this.bossExecutor, this.workerExecutor);
    }
}

