/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.regex;

import java.util.regex.Pattern;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;

public class Regex {
    public static boolean isSimpleMatchPattern(String str) {
        return str.indexOf(42) != -1;
    }

    public static boolean simpleMatch(String pattern, String str) {
        if (pattern == null || str == null) {
            return false;
        }
        int firstIndex = pattern.indexOf(42);
        if (firstIndex == -1) {
            return pattern.equals(str);
        }
        if (firstIndex == 0) {
            if (pattern.length() == 1) {
                return true;
            }
            int nextIndex = pattern.indexOf(42, firstIndex + 1);
            if (nextIndex == -1) {
                return str.endsWith(pattern.substring(1));
            }
            String part = pattern.substring(1, nextIndex);
            int partIndex = str.indexOf(part);
            while (partIndex != -1) {
                if (Regex.simpleMatch(pattern.substring(nextIndex), str.substring(partIndex + part.length()))) {
                    return true;
                }
                partIndex = str.indexOf(part, partIndex + 1);
            }
            return false;
        }
        return str.length() >= firstIndex && pattern.substring(0, firstIndex).equals(str.substring(0, firstIndex)) && Regex.simpleMatch(pattern.substring(firstIndex), str.substring(firstIndex));
    }

    public static boolean simpleMatch(String[] patterns, String str) {
        if (patterns != null) {
            for (String pattern : patterns) {
                if (!Regex.simpleMatch(pattern, str)) continue;
                return true;
            }
        }
        return false;
    }

    public static Pattern compile(String regex, String flags) {
        int pFlags = flags == null ? 0 : Regex.flagsFromString(flags);
        return Pattern.compile(regex, pFlags);
    }

    public static int flagsFromString(String flags) {
        int pFlags = 0;
        for (String s : Strings.delimitedListToStringArray(flags, "|")) {
            if (s.isEmpty()) continue;
            if ("CASE_INSENSITIVE".equalsIgnoreCase(s)) {
                pFlags |= 2;
                continue;
            }
            if ("MULTILINE".equalsIgnoreCase(s)) {
                pFlags |= 8;
                continue;
            }
            if ("DOTALL".equalsIgnoreCase(s)) {
                pFlags |= 0x20;
                continue;
            }
            if ("UNICODE_CASE".equalsIgnoreCase(s)) {
                pFlags |= 0x40;
                continue;
            }
            if ("CANON_EQ".equalsIgnoreCase(s)) {
                pFlags |= 0x80;
                continue;
            }
            if ("UNIX_LINES".equalsIgnoreCase(s)) {
                pFlags |= 1;
                continue;
            }
            if ("LITERAL".equalsIgnoreCase(s)) {
                pFlags |= 0x10;
                continue;
            }
            if ("COMMENTS".equalsIgnoreCase(s)) {
                pFlags |= 4;
                continue;
            }
            throw new ElasticSearchIllegalArgumentException("Unknown regex flag [" + s + "]");
        }
        return pFlags;
    }

    public static String flagsToString(int flags) {
        StringBuilder sb = new StringBuilder();
        if ((flags & 2) != 0) {
            sb.append("CASE_INSENSITIVE|");
        }
        if ((flags & 8) != 0) {
            sb.append("MULTILINE|");
        }
        if ((flags & 0x20) != 0) {
            sb.append("DOTALL|");
        }
        if ((flags & 0x40) != 0) {
            sb.append("UNICODE_CASE|");
        }
        if ((flags & 0x80) != 0) {
            sb.append("CANON_EQ|");
        }
        if ((flags & 1) != 0) {
            sb.append("UNIX_LINES|");
        }
        if ((flags & 0x10) != 0) {
            sb.append("LITERAL|");
        }
        if ((flags & 4) != 0) {
            sb.append("COMMENTS|");
        }
        return sb.toString();
    }
}

