/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.ParseContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;

public class RoutingFieldMapper
extends AbstractFieldMapper<String>
implements org.elasticsearch.index.mapper.RoutingFieldMapper {
    public static final String CONTENT_TYPE = "_routing";
    private boolean required;
    private final String path;

    protected RoutingFieldMapper() {
        this(Defaults.STORE, Defaults.INDEX, false, Defaults.PATH);
    }

    protected RoutingFieldMapper(Field.Store store, Field.Index index, boolean required, String path) {
        super(new FieldMapper.Names(CONTENT_TYPE, CONTENT_TYPE, CONTENT_TYPE, CONTENT_TYPE), index, store, Defaults.TERM_VECTOR, 1.0f, true, true, Lucene.KEYWORD_ANALYZER, Lucene.KEYWORD_ANALYZER);
        this.required = required;
        this.path = path;
    }

    public void markAsRequired() {
        this.required = true;
    }

    @Override
    public boolean required() {
        return this.required;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String value(Document document) {
        Fieldable field = document.getFieldable(this.names.indexName());
        return field == null ? null : this.value(field);
    }

    @Override
    public String value(Fieldable field) {
        return field.stringValue();
    }

    @Override
    public String valueFromString(String value) {
        return value;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String indexedValue(String value) {
        return value;
    }

    public void validate(ParseContext context, String routing) throws MapperParsingException {
        if (this.path != null && routing != null) {
            String value = context.doc().get(this.path);
            if (value == null) {
                value = context.ignoredValue(this.path);
            }
            if (!routing.equals(value)) {
                throw new MapperParsingException("External routing [" + routing + "] and document path routing [" + value + "] mismatch");
            }
        }
    }

    protected Field parseCreateField(ParseContext context) throws IOException {
        String routing;
        if (context.externalValueSet() && (routing = (String)context.externalValue()) != null) {
            if (!this.indexed() && !this.stored()) {
                context.ignoredValue(this.names.indexName(), routing);
                return null;
            }
            return new Field(this.names.indexName(), routing, this.store, this.index);
        }
        return null;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.index == Defaults.INDEX && this.store == Defaults.STORE && !this.required && this.path == Defaults.PATH) {
            return builder;
        }
        builder.startObject(CONTENT_TYPE);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.required) {
            builder.field("required", this.required);
        }
        if (this.path != Defaults.PATH) {
            builder.field("path", this.path);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, RoutingFieldMapper> {
        private boolean required = false;
        private String path = Defaults.PATH;

        public Builder() {
            super(RoutingFieldMapper.CONTENT_TYPE);
            this.store = Defaults.STORE;
            this.index = Defaults.INDEX;
        }

        public Builder required(boolean required) {
            this.required = required;
            return (Builder)this.builder;
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        @Override
        public RoutingFieldMapper build(XContentMapper.BuilderContext context) {
            return new RoutingFieldMapper(this.store, this.index, this.required, this.path);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_routing";
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final Field.Store STORE = Field.Store.YES;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
        public static final boolean REQUIRED = false;
        public static final String PATH = null;
    }
}

