/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.QueryBuilderException;
import org.elasticsearch.index.query.xcontent.BaseQueryBuilder;
import org.elasticsearch.index.query.xcontent.XContentQueryBuilder;

public class BoostingQueryBuilder
extends BaseQueryBuilder {
    private XContentQueryBuilder positiveQuery;
    private XContentQueryBuilder negativeQuery;
    private float negativeBoost = -1.0f;
    private float boost = -1.0f;

    public BoostingQueryBuilder positive(XContentQueryBuilder positiveQuery) {
        this.positiveQuery = positiveQuery;
        return this;
    }

    public BoostingQueryBuilder negative(XContentQueryBuilder negativeQuery) {
        this.negativeQuery = negativeQuery;
        return this;
    }

    public BoostingQueryBuilder negativeBoost(float negativeBoost) {
        this.negativeBoost = negativeBoost;
        return this;
    }

    public BoostingQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.positiveQuery == null) {
            throw new QueryBuilderException("boosting query requires positive query to be set");
        }
        if (this.negativeQuery == null) {
            throw new QueryBuilderException("boosting query requires negative query to be set");
        }
        if (this.negativeBoost == -1.0f) {
            throw new QueryBuilderException("boosting query requires negativeBoost to be set");
        }
        builder.startObject("boosting");
        builder.field("positive");
        this.positiveQuery.toXContent(builder, params);
        builder.field("negative");
        this.negativeQuery.toXContent(builder, params);
        builder.field("negative_boost", this.negativeBoost);
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
    }
}

