/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query.xcontent;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParsingException;
import org.elasticsearch.index.query.support.QueryParsers;
import org.elasticsearch.index.query.xcontent.QueryParseContext;
import org.elasticsearch.index.query.xcontent.XContentQueryParser;
import org.elasticsearch.index.settings.IndexSettings;

public class PrefixQueryParser
extends AbstractIndexComponent
implements XContentQueryParser {
    public static final String NAME = "prefix";

    @Inject
    public PrefixQueryParser(Index index, @IndexSettings Settings settings) {
        super(index, settings);
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser parser = parseContext.parser();
        XContentParser.Token token = parser.nextToken();
        assert (token == XContentParser.Token.FIELD_NAME);
        String fieldName = parser.currentName();
        String value = null;
        float boost = 1.0f;
        token = parser.nextToken();
        if (token == XContentParser.Token.START_OBJECT) {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (!token.isValue()) continue;
                if (NAME.equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if ("value".equals(currentFieldName)) {
                    value = parser.text();
                    continue;
                }
                if (!"boost".equals(currentFieldName)) continue;
                boost = parser.floatValue();
            }
            parser.nextToken();
        } else {
            value = parser.text();
            parser.nextToken();
        }
        if (value == null) {
            throw new QueryParsingException(this.index, "No value specified for prefix query");
        }
        MapperService.SmartNameFieldMappers smartNameFieldMappers = parseContext.smartFieldMappers(fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            fieldName = smartNameFieldMappers.mapper().names().indexName();
            value = smartNameFieldMappers.mapper().indexedValue(value);
        }
        PrefixQuery query = new PrefixQuery(new Term(fieldName, value));
        query.setRewriteMethod(MultiTermQuery.CONSTANT_SCORE_AUTO_REWRITE_DEFAULT);
        query.setBoost(boost);
        return QueryParsers.wrapSmartNameQuery((Query)query, smartNameFieldMappers, parseContext);
    }
}

