/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.store.fs;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.apache.lucene.store.bytebuffer.ByteBufferDirectory;
import org.elasticsearch.cache.memory.ByteBufferCache;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.lucene.store.SwitchDirectory;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.settings.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.IndexStore;
import org.elasticsearch.index.store.support.AbstractStore;

public abstract class FsStore
extends AbstractStore {
    public static final boolean DEFAULT_SUGGEST_USE_COMPOUND_FILE = false;

    public FsStore(ShardId shardId, @IndexSettings Settings indexSettings, IndexStore indexStore) {
        super(shardId, indexSettings, indexStore);
    }

    @Override
    public void fullDelete() throws IOException {
        FileSystemUtils.deleteRecursively(this.fsDirectory().getFile());
        String[] list = this.fsDirectory().getFile().getParentFile().list();
        if (list == null || list.length == 0) {
            FileSystemUtils.deleteRecursively(this.fsDirectory().getFile().getParentFile());
        }
    }

    public abstract FSDirectory fsDirectory();

    protected LockFactory buildLockFactory() throws IOException {
        String fsLock = this.componentSettings.get("fs_lock", "native");
        Object lockFactory = new NoLockFactory();
        if (fsLock.equals("native")) {
            lockFactory = new NativeFSLockFactory(){

                public void clearLock(String lockName) throws IOException {
                    if (this.lockDir.exists()) {
                        this.makeLock(lockName).release();
                        if (this.lockPrefix != null) {
                            lockName = this.lockPrefix + "-" + lockName;
                        }
                        new File(this.lockDir, lockName).delete();
                    }
                }
            };
        } else if (fsLock.equals("simple")) {
            lockFactory = new SimpleFSLockFactory();
        }
        return lockFactory;
    }

    protected Tuple<SwitchDirectory, Boolean> buildSwitchDirectoryIfNeeded(Directory fsDirectory, ByteBufferCache byteBufferCache) {
        boolean cache = this.componentSettings.getAsBoolean("memory.enabled", false);
        if (!cache) {
            return null;
        }
        ByteBufferDirectory memDir = new ByteBufferDirectory(byteBufferCache);
        String[] primaryExtensions = this.componentSettings.getAsArray("memory.extensions", new String[]{"", "del", "gen"});
        if (primaryExtensions == null || primaryExtensions.length == 0) {
            return null;
        }
        Boolean forceUseCompound = null;
        for (String extension : primaryExtensions) {
            if ("".equals(extension) || "del".equals(extension) || "gen".equals(extension)) continue;
            forceUseCompound = false;
        }
        return new Tuple<SwitchDirectory, Object>(new SwitchDirectory(ImmutableSet.copyOf(primaryExtensions), memDir, fsDirectory, true), forceUseCompound);
    }
}

