/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.net.URL;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.libraries.base.boot.AbstractModule;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DrillDownModule
extends AbstractModule {
    public static final String DRILLDOWN_PROFILE_NAMESPACE = "http://reporting.pentaho.org/namespaces/engine/classic/drilldown-profile/1.0";

    public DrillDownModule() throws ModuleInitializeException {
        this.loadModuleInfo();
    }

    public void initialize(SubSystem subSystem) throws ModuleInitializeException {
        URL expressionMetaSource = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/extensions/drilldown/drilldown-profile.xml", DrillDownModule.class);
        if (expressionMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the drilldown meta-data description file");
        }
        this.register(expressionMetaSource);
        URL customizedMetaSource = ObjectUtilities.getResource((String)"drilldown-profile.xml", DrillDownModule.class);
        if (customizedMetaSource != null) {
            this.register(customizedMetaSource);
        }
    }

    private void register(URL expressionMetaSource) throws ModuleInitializeException {
        if (expressionMetaSource == null) {
            return;
        }
        try {
            DrillDownProfileMetaData.getInstance().registerFromXml(expressionMetaSource);
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Error: Could not parse the drilldown meta-data description file", e);
        }
    }
}

