/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.parser.DrillDownProfileCollection;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DrillDownProfileMetaData {
    private static final Log logger = LogFactory.getLog(DrillDownProfileMetaData.class);
    private static DrillDownProfileMetaData instance;
    private HashMap<String, DrillDownProfile> drillDownProfiles = new HashMap();

    public static synchronized DrillDownProfileMetaData getInstance() {
        if (instance == null) {
            instance = new DrillDownProfileMetaData();
        }
        return instance;
    }

    private DrillDownProfileMetaData() {
    }

    public void registerProfile(DrillDownProfile profile) {
        this.drillDownProfiles.put(profile.getName(), profile);
    }

    public void registerFromXml(URL expressionMetaSource) throws IOException {
        if (expressionMetaSource == null) {
            throw new NullPointerException("Error: Could not find the expression meta-data description file");
        }
        try {
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            Resource resource = resourceManager.createDirectly((Object)expressionMetaSource, DrillDownProfileCollection.class);
            DrillDownProfileCollection typeCollection = (DrillDownProfileCollection)resource.getResource();
            DrillDownProfile[] types = typeCollection.getData();
            for (int i = 0; i < types.length; ++i) {
                DrillDownProfile metaData = types[i];
                if (metaData == null) continue;
                this.registerProfile(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed:", (Throwable)e);
            throw new IOException("Error: Could not parse the element meta-data description file");
        }
    }

    public DrillDownProfile getDrillDownProfile(String configIndicator) {
        return this.drillDownProfiles.get(configIndicator);
    }

    public DrillDownProfile[] getDrillDownProfiles() {
        return this.drillDownProfiles.values().toArray(new DrillDownProfile[this.drillDownProfiles.size()]);
    }

    public String[] getDrillDownProfileNames() {
        return this.drillDownProfiles.keySet().toArray(new String[this.drillDownProfiles.size()]);
    }

    public DrillDownProfile[] getDrillDownProfileByGroup(String group) {
        ArrayList<DrillDownProfile> profiles = new ArrayList<DrillDownProfile>();
        for (DrillDownProfile profile : this.drillDownProfiles.values()) {
            if (!ObjectUtilities.equal((Object)profile.getAttribute("group"), (Object)group)) continue;
            profiles.add(profile);
        }
        return profiles.toArray(new DrillDownProfile[profiles.size()]);
    }
}

