/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.drilldown;

import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanException;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfile;
import org.pentaho.reporting.engine.classic.extensions.drilldown.DrillDownProfileMetaData;
import org.pentaho.reporting.engine.classic.extensions.drilldown.LinkCustomizer;
import org.pentaho.reporting.engine.classic.extensions.drilldown.ParameterEntry;
import org.pentaho.reporting.libraries.formula.ErrorValue;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

public class PatternLinkCustomizer
implements LinkCustomizer {
    public String format(FormulaContext formulaContext, String configIndicator, String reportPath, ParameterEntry[] entries) throws EvaluationException {
        try {
            String parameter = PatternLinkCustomizer.computeParameter(formulaContext, entries);
            String pattern = this.computePattern(configIndicator);
            MessageFormat messageFormat = new MessageFormat(pattern, formulaContext.getLocalizationContext().getLocale());
            return messageFormat.format(new Object[]{reportPath, parameter});
        }
        catch (UnsupportedEncodingException e) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        catch (BeanException e) {
            throw EvaluationException.getInstance((ErrorValue)LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
    }

    public static String computeParameter(FormulaContext formulaContext, ParameterEntry[] entries) throws UnsupportedEncodingException, BeanException {
        String encoding = formulaContext.getConfiguration().getConfigProperty("org.pentaho.reporting.libraries.formula.URLEncoding", "ISO-8859-1");
        StringBuilder parameter = new StringBuilder(1000);
        for (int i = 0; i < entries.length; ++i) {
            Object value;
            ParameterEntry entry = entries[i];
            if (i != 0) {
                parameter.append('&');
            }
            if ((value = entry.getParameterValue()) instanceof Object[]) {
                Object[] array = (Object[])value;
                for (int j = 0; j < array.length; ++j) {
                    if (j != 0) {
                        parameter.append('&');
                    }
                    Object o = array[j];
                    parameter.append(URLEncoder.encode((String)entry.getParameterName(), (String)encoding));
                    parameter.append('=');
                    parameter.append(URLEncoder.encode((String)ConverterRegistry.toAttributeValue((Object)o), (String)encoding));
                }
                continue;
            }
            if (value != null) {
                parameter.append(URLEncoder.encode((String)entry.getParameterName(), (String)encoding));
                parameter.append('=');
                parameter.append(URLEncoder.encode((String)ConverterRegistry.toAttributeValue((Object)value), (String)encoding));
                continue;
            }
            parameter.append(URLEncoder.encode((String)entry.getParameterName(), (String)encoding));
            parameter.append('=');
        }
        return parameter.toString();
    }

    private String computePattern(String configIndicator) throws EvaluationException {
        DrillDownProfile downProfile = DrillDownProfileMetaData.getInstance().getDrillDownProfile(configIndicator);
        return downProfile.getAttribute("pattern");
    }
}

