/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.ObjectManagerFactoryImpl;
import org.datanucleus.PersistenceConfiguration;
import org.datanucleus.StateManager;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.InheritanceStrategy;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.store.AbstractPersistenceHandler;
import org.datanucleus.store.StoreManager;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.rdbms.RDBMSStoreManager;
import org.datanucleus.store.rdbms.fieldmanager.DynamicSchemaFieldManager;
import org.datanucleus.store.rdbms.request.Request;
import org.datanucleus.store.rdbms.request.RequestIdentifier;
import org.datanucleus.store.rdbms.request.RequestType;
import org.datanucleus.store.rdbms.table.ClassView;
import org.datanucleus.store.rdbms.table.SecondaryTable;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.SoftValueMap;

public class RDBMSPersistenceHandler
extends AbstractPersistenceHandler {
    protected static final Localiser LOCALISER = Localiser.getInstance((String)"org.datanucleus.Localisation", (ClassLoader)ObjectManagerFactoryImpl.class.getClassLoader());
    protected final MappedStoreManager storeMgr;
    private Map<RequestIdentifier, Request> requestsByID = Collections.synchronizedMap(new SoftValueMap());

    public RDBMSPersistenceHandler(StoreManager storeMgr) {
        this.storeMgr = (MappedStoreManager)storeMgr;
    }

    public void close() {
        this.requestsByID.clear();
        this.requestsByID = null;
    }

    public void insertObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.checkForSchemaUpdatesForFieldsOfObject(sm, sm.getLoadedFieldNumbers());
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        String className = sm.getObject().getClass().getName();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(className, clr);
        if (dc == null) {
            if (sm.getClassMetaData().getInheritanceMetaData().getStrategy() == InheritanceStrategy.SUBCLASS_TABLE) {
                throw new NucleusUserException(LOCALISER.msg("032013", (Object)className));
            }
            throw new NucleusException(LOCALISER.msg("032014", (Object)className, (Object)sm.getClassMetaData().getInheritanceMetaData().getStrategy())).setFatal();
        }
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementInsertCount();
        }
        this.insertTable(dc, sm, clr);
    }

    private void insertTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform InsertRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.insertTable(supertable, sm, clr);
        }
        Request req = this.getInsertRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.insertTable((DatastoreClass)secTable, sm, clr);
            }
        }
    }

    private Request getInsertRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.INSERT, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.insert");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.INSERT.toString(), key}, "class", new Class[]{DatastoreClass.class, Class.class, ClassLoaderResolver.class}, new Object[]{table, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void fetchObject(StateManager sm, int[] fieldNumbers) {
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (sm.getPcObjectType() != 0) {
                StringBuffer str = new StringBuffer();
                for (int i = 0; i < fmds.length; ++i) {
                    if (i > 0) {
                        str.append(',');
                    }
                    str.append(fmds[i].getName());
                }
                NucleusLogger.PERSISTENCE.info((Object)("Request to load fields \"" + str.toString() + "\" of class " + sm.getClassMetaData().getFullClassName() + " but object is embedded, so ignored"));
            } else {
                if (this.storeMgr.getRuntimeManager() != null) {
                    this.storeMgr.getRuntimeManager().incrementFetchCount();
                }
                ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
                DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
                Request req = this.getFetchRequest(table, fmds, sm.getObject().getClass(), clr);
                req.execute(sm);
            }
        }
    }

    private Request getFetchRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.FETCH, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.fetch");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.FETCH.toString(), key}, "class", new Class[]{DatastoreClass.class, AbstractMemberMetaData[].class, Class.class, ClassLoaderResolver.class}, new Object[]{table, mmds, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void updateObject(StateManager sm, int[] fieldNumbers) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        this.checkForSchemaUpdatesForFieldsOfObject(sm, fieldNumbers);
        AbstractMemberMetaData[] fmds = null;
        if (fieldNumbers != null && fieldNumbers.length > 0) {
            fmds = new AbstractMemberMetaData[fieldNumbers.length];
            for (int i = 0; i < fmds.length; ++i) {
                fmds[i] = sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(fieldNumbers[i]);
            }
            if (this.storeMgr.getRuntimeManager() != null) {
                this.storeMgr.getRuntimeManager().incrementUpdateCount();
            }
            ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
            DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
            this.updateTable(dc, sm, clr, fmds);
        }
    }

    private void updateTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr, AbstractMemberMetaData[] fieldMetaData) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform UpdateRequest on RDBMS view " + table);
        }
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.updateTable(supertable, sm, clr, fieldMetaData);
        }
        Request req = this.getUpdateRequest(table, fieldMetaData, sm.getObject().getClass(), clr);
        req.execute(sm);
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.updateTable((DatastoreClass)secTable, sm, clr, fieldMetaData);
            }
        }
    }

    private Request getUpdateRequest(DatastoreClass table, AbstractMemberMetaData[] mmds, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, mmds, RequestType.UPDATE, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.update");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.UPDATE.toString(), key}, "class", new Class[]{DatastoreClass.class, AbstractMemberMetaData[].class, Class.class, ClassLoaderResolver.class}, new Object[]{table, mmds, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void deleteObject(StateManager sm) {
        this.storeMgr.assertReadOnlyForUpdateOfObject(sm);
        if (this.storeMgr.getRuntimeManager() != null) {
            this.storeMgr.getRuntimeManager().incrementDeleteCount();
        }
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass dc = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        this.deleteTable(dc, sm, clr);
    }

    private void deleteTable(DatastoreClass table, StateManager sm, ClassLoaderResolver clr) {
        if (table instanceof ClassView) {
            throw new NucleusUserException("Cannot perform DeleteRequest on RDBMS view " + table);
        }
        Collection secondaryTables = table.getSecondaryDatastoreClasses();
        if (secondaryTables != null) {
            for (SecondaryTable secTable : secondaryTables) {
                this.deleteTable((DatastoreClass)secTable, sm, clr);
            }
        }
        Request req = this.getDeleteRequest(table, sm.getObject().getClass(), clr);
        req.execute(sm);
        DatastoreClass supertable = table.getSuperDatastoreClass();
        if (supertable != null) {
            this.deleteTable(supertable, sm, clr);
        }
    }

    private Request getDeleteRequest(DatastoreClass table, Class cls, ClassLoaderResolver clr) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.DELETE, cls.getName());
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.delete");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.DELETE.toString(), key}, "class", new Class[]{DatastoreClass.class, Class.class, ClassLoaderResolver.class}, new Object[]{table, cls, clr});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public void locateObject(StateManager sm) {
        ClassLoaderResolver clr = sm.getObjectManager().getClassLoaderResolver();
        DatastoreClass table = this.storeMgr.getDatastoreClass(sm.getObject().getClass().getName(), clr);
        Request req = this.getLocateRequest(table, sm.getObject().getClass().getName());
        req.execute(sm);
    }

    private Request getLocateRequest(DatastoreClass table, String className) {
        RequestIdentifier reqID = new RequestIdentifier(table, null, RequestType.LOCATE, className);
        Request req = this.requestsByID.get(reqID);
        if (req == null) {
            PluginManager pluginMgr = this.storeMgr.getOMFContext().getPluginManager();
            PersistenceConfiguration conf = this.storeMgr.getOMFContext().getPersistenceConfiguration();
            String key = conf.getStringProperty("datanucleus.rdbms.request.locate");
            try {
                req = (Request)pluginMgr.createExecutableExtension("org.datanucleus.store.rdbms.rdbms_request", new String[]{"type", "name"}, new String[]{RequestType.LOCATE.toString(), key}, "class", new Class[]{DatastoreClass.class}, new Object[]{table});
            }
            catch (Exception e) {
                throw new NucleusException("Attempt to instantiate insert request gave an error", (Throwable)e);
            }
            this.requestsByID.put(reqID, req);
        }
        return req;
    }

    public Object findObject(ObjectManager om, Object id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRequests() {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            this.requestsByID.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestsForTable(DatastoreClass table) {
        Map<RequestIdentifier, Request> map = this.requestsByID;
        synchronized (map) {
            HashSet<RequestIdentifier> keySet = new HashSet<RequestIdentifier>(this.requestsByID.keySet());
            for (RequestIdentifier reqId : keySet) {
                if (reqId.getTable() != table) continue;
                this.requestsByID.remove(reqId);
            }
        }
    }

    private void checkForSchemaUpdatesForFieldsOfObject(StateManager sm, int[] fieldNumbers) {
        if (this.storeMgr.getOMFContext().getPersistenceConfiguration().getBooleanObjectProperty("datanucleus.rdbms.dynamicSchemaUpdates").booleanValue()) {
            DynamicSchemaFieldManager dynamicSchemaFM = new DynamicSchemaFieldManager((RDBMSStoreManager)this.storeMgr, sm);
            sm.provideFields(fieldNumbers, (FieldManager)dynamicSchemaFM);
            if (dynamicSchemaFM.hasPerformedSchemaUpdates()) {
                this.requestsByID.clear();
            }
        }
    }
}

