/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.controllers;

import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulExpandPanel;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.gwt.tags.GwtRadioGroup;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SummaryDialogController
extends AbstractXulEventHandler {
    private XulDialog wizardDialog;
    private GwtRadioGroup modelerDecision;
    private XulExpandPanel errorLogExpander;
    private XulDialog summaryDialog;
    private XulLabel summaryDialogRowsLoaded;
    private XulVbox showModelerCheckboxHider;
    private XulLabel summaryDialogDetails;
    private IDatasourceSummary summary;
    private XulServiceCallback<IDatasourceSummary> callback;
    private BindingFactory bf;

    public String getName() {
        return "summaryDialog";
    }

    public void init() {
        this.wizardDialog = (XulDialog)this.document.getElementById("main_wizard_window");
        this.modelerDecision = (GwtRadioGroup)this.document.getElementById("modelerDecision");
        this.errorLogExpander = (XulExpandPanel)this.document.getElementById("errorLogExpander");
        this.showModelerCheckboxHider = (XulVbox)this.document.getElementById("showModelerCheckboxHider");
        this.summaryDialog = (XulDialog)this.document.getElementById("summaryDialog");
        this.summaryDialogRowsLoaded = (XulLabel)this.document.getElementById("summaryDialogRowsLoaded");
        this.summaryDialogDetails = (XulLabel)this.document.getElementById("summaryDialogDetails");
    }

    public void showSummaryDialog(IDatasourceSummary stats, XulServiceCallback<IDatasourceSummary> callback) {
        this.showSummaryDialog(stats, true, callback);
    }

    public void showSummaryDialog(IDatasourceSummary stats, boolean showModelerDecision, XulServiceCallback<IDatasourceSummary> callback) {
        this.summary = stats;
        this.callback = callback;
        this.wizardDialog.hide();
        this.errorLogExpander.setExpanded(false);
        this.modelerDecision.setValue("DEFAULT");
        if (stats != null && stats.getErrorCount() > 0L) {
            long errors = stats.getErrorCount();
            long total = stats.getTotalRecords() > 0L ? stats.getTotalRecords() : errors;
            long successRows = total > errors ? total - errors : 0L;
            this.summaryDialogRowsLoaded.setValue(MessageHandler.getString("summaryDialog.rowsLoaded", String.valueOf(successRows), String.valueOf(total)));
            String lf = "\n";
            if (errors > 0L) {
                StringBuilder detailMsg = new StringBuilder();
                for (String error : stats.getErrors()) {
                    detailMsg.append(error);
                    detailMsg.append(lf);
                }
                this.summaryDialogDetails.setValue(detailMsg.toString());
                this.errorLogExpander.setVisible(true);
            } else {
                this.summaryDialogDetails.setValue("");
                this.errorLogExpander.setVisible(false);
            }
        } else {
            this.summaryDialogRowsLoaded.setValue(MessageHandler.getString("summaryDialog.generalSuccess"));
            this.errorLogExpander.setVisible(false);
        }
        this.showModelerCheckboxHider.setVisible(showModelerDecision);
        this.summaryDialog.show();
    }

    @Bindable
    public void closeSummaryDialog() {
        boolean editModeler;
        this.summaryDialog.hide();
        boolean bl = editModeler = this.modelerDecision.getValue() != null && this.modelerDecision.getValue().equals("EDIT");
        if (editModeler) {
            MessageHandler.getInstance().showWaitingDialog(MessageHandler.getString("waiting.openingModeler"));
            this.summary.setShowModeler(true);
        } else {
            MessageHandler.getInstance().showWaitingDialog(MessageHandler.getString("waiting.generalWaiting"));
            this.summary.setShowModeler(false);
        }
        this.errorLogExpander.setExpanded(false);
        this.callback.success((Object)this.summary);
    }

    public void setBindingFactory(BindingFactory bindingFactory) {
        this.bf = bindingFactory;
    }
}

