/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.models;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.models.FileInfo;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IRelationalModelValidationListener;
import org.pentaho.platform.dataaccess.datasource.wizard.models.RelationalModelValidationListenerCollection;
import org.pentaho.ui.xul.XulEventSourceAdapter;
import org.pentaho.ui.xul.stereotype.Bindable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiStateModel
extends XulEventSourceAdapter {
    private boolean relationalValidated;
    private boolean relationalPreviewValidated;
    private boolean relationalApplyValidated;
    private List<IConnection> connections = new ArrayList<IConnection>();
    private String previewLimit = "10";
    private List<LogicalModel> logicalModels;
    private String localeCode;
    private boolean dataStagingComplete;
    private FileInfo selectedCsvFile;
    private boolean dirty = true;
    private RelationalModelValidationListenerCollection relationalModelValidationListeners;

    @Bindable
    public List<IConnection> getConnections() {
        return this.connections;
    }

    public void addConnection(IConnection connection) {
        List<IConnection> previousValue = this.getPreviousValue();
        this.connections.add(connection);
        this.firePropertyChange("connections", previousValue, this.connections);
    }

    public void updateConnection(IConnection connection) {
        List<IConnection> previousValue = this.getPreviousValue();
        IConnection conn = this.getConnectionByName(connection.getName());
        conn.setDriverClass(connection.getDriverClass());
        conn.setPassword(connection.getPassword());
        conn.setUrl(connection.getUrl());
        conn.setUsername(connection.getUsername());
        this.firePropertyChange("connections", previousValue, this.connections);
    }

    @Bindable
    private List<IConnection> getPreviousValue() {
        ArrayList<IConnection> previousValue = new ArrayList<IConnection>();
        for (IConnection conn : this.connections) {
            previousValue.add(conn);
        }
        return previousValue;
    }

    public void deleteConnection(IConnection connection) {
        List<IConnection> previousValue = this.getPreviousValue();
        this.connections.remove(this.connections.indexOf(connection));
        this.firePropertyChange("connections", previousValue, this.connections);
    }

    public void deleteConnection(String name) {
        for (IConnection connection : this.connections) {
            if (!connection.getName().equals(name)) continue;
            this.deleteConnection(connection);
            break;
        }
    }

    @Bindable
    public void setConnections(List<IConnection> value) {
        List<IConnection> previousValue = this.getPreviousValue();
        this.connections = value;
        this.firePropertyChange("connections", previousValue, value);
    }

    @Bindable
    public String getPreviewLimit() {
        return this.previewLimit;
    }

    @Bindable
    public void setPreviewLimit(String value) {
        String previousVal = this.previewLimit;
        this.previewLimit = value;
        this.firePropertyChange("previewLimit", previousVal, value);
    }

    public IConnection getConnectionByName(String name) {
        for (IConnection connection : this.connections) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        return null;
    }

    public Integer getConnectionIndex(IConnection conn) {
        IConnection connection = this.getConnectionByName(conn.getName());
        return this.connections.indexOf(connection);
    }

    @Bindable
    public boolean isRelationalValidated() {
        return this.relationalValidated;
    }

    @Bindable
    private void setRelationalValidated(boolean value) {
        if (value != this.relationalValidated) {
            this.relationalValidated = value;
            this.firePropertyChange("relationalValidated", !value, value);
        }
    }

    public void validateRelational() {
        this.setRelationalPreviewValidated(true);
        this.setRelationalApplyValidated(true);
        this.setRelationalValidated(true);
        this.fireRelationalModelValid();
    }

    public void invalidateRelational() {
        this.setRelationalPreviewValidated(false);
        this.setRelationalApplyValidated(false);
        this.setRelationalValidated(false);
        this.fireRelationalModelInValid();
    }

    @Bindable
    public void clearModel() {
        this.setPreviewLimit("10");
        this.setSelectedCsvFile(null);
    }

    public void addRelationalModelValidationListener(IRelationalModelValidationListener listener) {
        if (this.relationalModelValidationListeners == null) {
            this.relationalModelValidationListeners = new RelationalModelValidationListenerCollection();
        }
        this.relationalModelValidationListeners.add(listener);
    }

    public void removeRelationalListener(IRelationalModelValidationListener listener) {
        if (this.relationalModelValidationListeners != null) {
            this.relationalModelValidationListeners.remove(listener);
        }
    }

    void fireRelationalModelValid() {
        if (this.relationalModelValidationListeners != null) {
            this.relationalModelValidationListeners.fireRelationalModelValid();
        }
    }

    void fireRelationalModelInValid() {
        if (this.relationalModelValidationListeners != null) {
            this.relationalModelValidationListeners.fireRelationalModelInValid();
        }
    }

    public void setRelationalPreviewValidated(boolean value) {
        if (value != this.relationalPreviewValidated) {
            this.relationalPreviewValidated = value;
            this.firePropertyChange("relationalPreviewValidated", !value, this.relationalPreviewValidated);
        }
    }

    public boolean isRelationalPreviewValidated() {
        return this.relationalPreviewValidated;
    }

    public boolean isRelationalApplyValidated() {
        return this.relationalApplyValidated;
    }

    public void setRelationalApplyValidated(boolean value) {
        if (value != this.relationalApplyValidated) {
            this.relationalApplyValidated = value;
            this.firePropertyChange("relationalApplyValidated", !value, this.relationalApplyValidated);
        }
    }

    public List<LogicalModel> getLogicalModels() {
        return this.logicalModels;
    }

    public void setLogicalModels(List<LogicalModel> logicalModels) {
        this.logicalModels = logicalModels;
    }

    public String getLocaleCode() {
        return this.localeCode;
    }

    public void setLocaleCode(String localeCode) {
        this.localeCode = localeCode;
    }

    public void setDataStagingComplete(boolean status) {
        this.dataStagingComplete = status;
    }

    public boolean isDataStagingComplete() {
        return this.dataStagingComplete;
    }

    public FileInfo getSelectedCsvFile() {
        return this.selectedCsvFile;
    }

    public void setSelectedCsvFile(FileInfo selectedCsvFile) {
        this.selectedCsvFile = selectedCsvFile;
    }

    @Bindable
    public boolean isDirty() {
        return this.dirty;
    }

    @Bindable
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.firePropertyChange("dirty", null, dirty);
    }
}

