/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.database.DatabaseDialectException;
import org.pentaho.database.IDatabaseDialect;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.service.DatabaseConnectionService;
import org.pentaho.database.service.DatabaseDialectService;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IConnectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryConnectionServiceImpl
implements IConnectionService {
    private String locale = Locale.getDefault().toString();
    private DatabaseConnectionService databaseConnectionService = new DatabaseConnectionService();
    private DatabaseDialectService databaseDialectService = new DatabaseDialectService();
    private List<IConnection> connectionList = new ArrayList<IConnection>();
    private static final Log logger = LogFactory.getLog(InMemoryConnectionServiceImpl.class);

    @Override
    public List<IConnection> getConnections() throws ConnectionServiceException {
        return this.connectionList;
    }

    @Override
    public IConnection getConnectionByName(String name) throws ConnectionServiceException {
        for (IConnection connection : this.connectionList) {
            if (!connection.getName().equals(name)) continue;
            return connection;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0003_UNABLE_TO_GET_CONNECTION", name, null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0003_UNABLE_TO_GET_CONNECTION", name, null));
    }

    @Override
    public boolean addConnection(IConnection connection) throws ConnectionServiceException {
        if (!this.isConnectionExist(connection.getName())) {
            this.connectionList.add(connection);
            return true;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0004_UNABLE_TO_ADD_CONNECTION", connection.getName(), null));
    }

    @Override
    public boolean updateConnection(IConnection connection) throws ConnectionServiceException {
        IConnection conn = this.getConnectionByName(connection.getName());
        if (conn != null) {
            conn.setDriverClass(connection.getDriverClass());
            conn.setPassword(connection.getPassword());
            conn.setUrl(connection.getUrl());
            conn.setUsername(connection.getUsername());
            return true;
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0005_UNABLE_TO_UPDATE_CONNECTION", connection.getName(), null));
    }

    @Override
    public boolean deleteConnection(IConnection connection) throws ConnectionServiceException {
        this.connectionList.remove(this.connectionList.indexOf(connection));
        return true;
    }

    @Override
    public boolean deleteConnection(String name) throws ConnectionServiceException {
        for (IConnection connection : this.connectionList) {
            if (!connection.getName().equals(name)) continue;
            return this.deleteConnection(connection);
        }
        logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, null));
        throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0006_UNABLE_TO_DELETE_CONNECTION", name, null));
    }

    @Override
    public boolean testConnection(IConnection connection) throws ConnectionServiceException {
        Connection conn = null;
        try {
            conn = InMemoryConnectionServiceImpl.getConnection(connection);
        }
        catch (ConnectionServiceException dme) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), dme.getLocalizedMessage()), (Throwable)dme);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), dme.getLocalizedMessage()), dme);
        }
        finally {
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), null));
                throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0026_UNABLE_TO_TEST_CONNECTION", connection.getName(), null));
            }
        }
        return true;
    }

    private static Connection getConnection(IConnection connection) throws ConnectionServiceException {
        Connection conn = null;
        String driverClass = connection.getDriverClass();
        if (StringUtils.isEmpty((String)driverClass)) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0020_CONNECTION_ATTEMPT_FAILED"));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0020_CONNECTION_ATTEMPT_FAILED"));
        }
        Class<?> driverC = null;
        try {
            driverC = Class.forName(driverClass);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH", driverClass), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH"), e);
        }
        if (!Driver.class.isAssignableFrom(driverC)) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH", driverClass));
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0021_DRIVER_NOT_FOUND_IN_CLASSPATH"));
        }
        Driver driver = null;
        try {
            driver = driverC.asSubclass(Driver.class).newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER", driverClass), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER"), e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER", driverClass), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0022_UNABLE_TO_INSTANCE_DRIVER"), e);
        }
        try {
            DriverManager.registerDriver(driver);
            conn = DriverManager.getConnection(connection.getUrl(), connection.getUsername(), connection.getPassword());
            return conn;
        }
        catch (SQLException e) {
            logger.error((Object)Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0023_UNABLE_TO_CONNECT"), (Throwable)e);
            throw new ConnectionServiceException(Messages.getErrorString("ConnectionServiceInMemoryDelegate.ERROR_0023_UNABLE_TO_CONNECT"), e);
        }
    }

    private boolean isConnectionExist(String connectionName) {
        for (IConnection connection : this.connectionList) {
            if (!connection.getName().equals(connectionName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IDatabaseConnection convertFromConnection(IConnection connection) throws ConnectionServiceException {
        IDatabaseConnection conn = this.databaseConnectionService.createDatabaseConnection(connection.getDriverClass(), connection.getUrl());
        conn.setName(connection.getName());
        conn.setUsername(connection.getUsername());
        conn.setPassword(connection.getPassword());
        return conn;
    }

    @Override
    public IConnection convertToConnection(IDatabaseConnection connection) throws ConnectionServiceException {
        try {
            IDatabaseDialect dialect = this.databaseDialectService.getDialect(connection);
            org.pentaho.platform.dataaccess.datasource.beans.Connection conn = new org.pentaho.platform.dataaccess.datasource.beans.Connection();
            conn.setName(connection.getName());
            conn.setUsername(connection.getUsername());
            conn.setPassword(connection.getPassword());
            String url = dialect.getURL(connection);
            conn.setUrl(url);
            if (connection.getDatabaseType().getShortName().equals("GENERIC")) {
                conn.setDriverClass((String)connection.getAttributes().get("CUSTOM_DRIVER_CLASS"));
            } else {
                conn.setDriverClass(dialect.getNativeDriver());
            }
            return conn;
        }
        catch (DatabaseDialectException e) {
            throw new ConnectionServiceException(e);
        }
    }
}

