/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.pentaho.agilebi.modeler.IModelerMessages;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.agilebi.modeler.gwt.GwtModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.services.IModelerService;
import org.pentaho.agilebi.modeler.util.SpoonModelerMessages;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.dataaccess.datasource.wizard.service.agile.AgileHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.InlineSqlModelerSource;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.metadata.MetadataPublisher;
import org.pentaho.platform.plugin.action.kettle.KettleSystemListener;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianDataSource;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;

public class ModelerService
extends PentahoBase
implements IModelerService {
    private static final Log logger = LogFactory.getLog(ModelerService.class);
    public static final String TMP_FILE_PATH = File.separatorChar + "system" + File.separatorChar + File.separatorChar + "tmp" + File.separatorChar;

    public Log getLogger() {
        return logger;
    }

    protected void initKettle() {
        try {
            KettleSystemListener.environmentInit((IPentahoSession)PentahoSessionHolder.getSession());
            if (!Props.isInitialized()) {
                Props.init((int)0);
            }
        }
        catch (KettleException e) {
            logger.error((Object)e);
            throw new IllegalStateException("Failed to initialize Kettle system");
        }
    }

    @Deprecated
    public Domain generateDomain(String connectionName, String tableName, String dbType, String query, String datasourceName) throws Exception {
        this.initKettle();
        try {
            DatabaseMeta database = AgileHelper.getDatabaseMeta();
            Object source = tableName != null ? new TableModelerSource(database, tableName, null, datasourceName) : new InlineSqlModelerSource(connectionName, dbType, query, datasourceName);
            return source.generateDomain();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception(e.getLocalizedMessage());
        }
    }

    public Domain generateCSVDomain(String tableName, String datasourceName) throws Exception {
        this.initKettle();
        try {
            DatabaseMeta database = AgileHelper.getDatabaseMeta();
            TableModelerSource source = new TableModelerSource(database, tableName, null, datasourceName);
            return source.generateDomain();
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new Exception(e.getLocalizedMessage());
        }
    }

    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return new BogoPojo();
    }

    public String serializeModels(Domain domain, String name) throws Exception {
        return this.serializeModels(domain, name, true);
    }

    public String serializeModels(Domain domain, String name, boolean doOlap) throws Exception {
        String domainId = null;
        this.initKettle();
        try {
            File pathDir;
            DatasourceServiceImpl datasourceService = new DatasourceServiceImpl();
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new GwtModelerWorkspaceHelper(), datasourceService.getGeoContext());
            model.setModelName(name);
            model.setDomain(domain);
            String solutionStorage = AgileHelper.getDatasourceSolutionStorage();
            String metadataLocation = "resources/metadata";
            String path = solutionStorage + '/' + metadataLocation + '/';
            domainId = path + name + ".xmi";
            domain.setId(domainId);
            IApplicationContext appContext = PentahoSystem.getApplicationContext();
            if (appContext != null) {
                path = PentahoSystem.getApplicationContext().getSolutionPath(path);
            }
            if (!(pathDir = new File(path)).exists()) {
                pathDir.mkdirs();
            }
            IPentahoObjectFactory pentahoObjectFactory = PentahoSystem.getObjectFactory();
            IPentahoSession session = (IPentahoSession)pentahoObjectFactory.get(IPentahoSession.class, "systemStartupSession", null);
            ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)session);
            LogicalModel lModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
            String catName = lModel.getName(Locale.getDefault().toString());
            catName = catName.replace("_OLAP", "");
            this.cleanseExistingCatalog(catName, session);
            if (doOlap) {
                lModel.setProperty("MondrianCatalogRef", (Object)catName);
            }
            XmiParser parser = new XmiParser();
            String reportXML = parser.generateXmi(model.getDomain());
            String base = PentahoSystem.getApplicationContext().getSolutionRootPath();
            String parentPath = ActionInfo.buildSolutionPath((String)solutionStorage, (String)metadataLocation, (String)"");
            int status = repository.publish(base, '/' + parentPath, name + ".xmi", reportXML.getBytes("UTF-8"), true);
            if (status != 3) {
                throw new RuntimeException("Unable to save to repository. Status: " + status);
            }
            if (doOlap) {
                MondrianModelExporter exporter = new MondrianModelExporter(lModel, Locale.getDefault().toString());
                String mondrianSchema = exporter.createMondrianModelXML();
                Document schemaDoc = DocumentHelper.parseText((String)mondrianSchema);
                byte[] schemaBytes = schemaDoc.asXML().getBytes("UTF-8");
                status = repository.publish(base, '/' + parentPath, name + ".mondrian.xml", schemaBytes, true);
                if (status != 3) {
                    throw new RuntimeException("Unable to save to repository. Status: " + status);
                }
                PentahoSystem.publish((IPentahoSession)session, (String)MetadataPublisher.class.getName());
                File file = new File(path + name + ".mondrian.xml");
                String catConnectStr = "Provider=mondrian;DataSource=" + ((SqlPhysicalModel)domain.getPhysicalModels().get(0)).getId();
                String catDef = "solution:" + solutionStorage + '/' + "resources" + '/' + "metadata" + '/' + file.getName();
                this.addCatalog(catName, catConnectStr, catDef, session);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw e;
        }
        return domainId;
    }

    private void cleanseExistingCatalog(String catName, IPentahoSession session) {
        IMondrianCatalogService service;
        MondrianCatalog catalog;
        if (session != null && (catalog = (service = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, null)).getCatalog(catName, session)) != null) {
            service.removeCatalog(catName, session);
        }
    }

    private void addCatalog(String catName, String catConnectStr, String catDef, IPentahoSession session) {
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)session);
        String dsUrl = PentahoSystem.getApplicationContext().getBaseUrl();
        if (!dsUrl.endsWith("/")) {
            dsUrl = dsUrl + "/";
        }
        dsUrl = dsUrl + "Xmla";
        MondrianDataSource ds = new MondrianDataSource("Provider=Mondrian;DataSource=Pentaho", "Pentaho BI Platform Datasources", dsUrl, "Provider=Mondrian", "PentahoXMLA", "MDP", "Unauthenticated", null);
        MondrianCatalog cat = new MondrianCatalog(catName, catConnectStr, catDef, ds, new MondrianSchema(catName, new ArrayList()));
        mondrianCatalogService.addCatalog(cat, true, session);
    }

    public Domain loadDomain(String id) throws Exception {
        IMetadataDomainRepository repo = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class);
        return repo.getDomain(id);
    }

    static {
        try {
            ModelerMessagesHolder.setMessages((IModelerMessages)new SpoonModelerMessages());
        }
        catch (IllegalStateException e) {
            logger.debug((Object)e.getMessage(), (Throwable)e);
        }
    }
}

