/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import com.thoughtworks.xstream.XStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.agilebi.modeler.geo.GeoContext;
import org.pentaho.agilebi.modeler.gwt.BogoPojo;
import org.pentaho.agilebi.modeler.util.MultiTableModelerSource;
import org.pentaho.database.model.IDatabaseConnection;
import org.pentaho.database.util.DatabaseUtil;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.security.Security;
import org.pentaho.metadata.model.concept.security.SecurityOwner;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.IDatasourceSummary;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.DatasourceServiceException;
import org.pentaho.platform.dataaccess.datasource.wizard.service.gwt.IGwtJoinSelectionService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ConnectionServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.DatasourceServiceImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessViewPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.ModelerService;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.MultiTableDatasourceDTO;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessViewPermissionHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.utils.ConnectionServiceHelper;
import org.pentaho.platform.dataaccess.datasource.wizard.service.messages.Messages;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.query.QueryDatasourceSummary;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultitableDatasourceService
extends PentahoBase
implements IGwtJoinSelectionService {
    private DatabaseMeta databaseMeta;
    private ConnectionServiceImpl connectionServiceImpl;
    private Log logger = LogFactory.getLog(MultitableDatasourceService.class);
    private IDataAccessViewPermissionHandler dataAccessViewPermHandler;

    public MultitableDatasourceService() {
        this.connectionServiceImpl = new ConnectionServiceImpl();
        this.init();
    }

    public MultitableDatasourceService(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
        this.init();
    }

    protected void init() {
        String dataAccessViewClassName = null;
        try {
            IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
            dataAccessViewClassName = resLoader.getPluginSetting(this.getClass(), "settings/data-access-view-permission-handler", "org.pentaho.platform.dataaccess.datasource.wizard.service.impl.SimpleDataAccessViewPermissionHandler");
            Class<?> clazz = Class.forName(dataAccessViewClassName);
            Constructor<?> defaultConstructor = clazz.getConstructor(new Class[0]);
            this.dataAccessViewPermHandler = (IDataAccessViewPermissionHandler)defaultConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)Messages.getErrorString("DatasourceServiceImpl.ERROR_0030_DATAACCESS_VIEW_PERMISSIONS_INIT_ERROR"), (Throwable)e);
            this.dataAccessViewPermHandler = new SimpleDataAccessViewPermissionHandler();
        }
    }

    private DatabaseMeta getDatabaseMeta(IConnection connection) throws ConnectionServiceException {
        if (this.connectionServiceImpl == null) {
            return this.databaseMeta;
        }
        IDatabaseConnection iDatabaseConnection = this.connectionServiceImpl.convertFromConnection(connection);
        iDatabaseConnection.setPassword(ConnectionServiceHelper.getConnectionPassword(connection.getName(), connection.getPassword()));
        DatabaseMeta dbmeta = DatabaseUtil.convertToDatabaseMeta((IDatabaseConnection)iDatabaseConnection);
        dbmeta.getDatabaseInterface().setQuoteAllFields(true);
        return dbmeta;
    }

    @Override
    public List<String> retrieveSchemas(IConnection connection) throws DatasourceServiceException {
        ArrayList<String> schemas = new ArrayList<String>();
        try {
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            Database database = new Database(null, databaseMeta);
            database.connect();
            Map tableMap = database.getTableMap(null);
            Set schemaNames = tableMap.keySet();
            schemas.addAll(schemaNames);
            database.disconnect();
        }
        catch (KettleDatabaseException e) {
            this.logger.error((Object)"Error creating database object", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
        catch (ConnectionServiceException e) {
            this.logger.error((Object)"Error getting database meta", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
        return schemas;
    }

    @Override
    public List<String> getDatabaseTables(IConnection connection, String schema) throws DatasourceServiceException {
        try {
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            Database database = new Database(null, databaseMeta);
            database.connect();
            String[] tableNames = database.getTablenames(schema, true);
            ArrayList<String> tables = new ArrayList<String>();
            tables.addAll(Arrays.asList(tableNames));
            tables.addAll(Arrays.asList(database.getViews(schema, true)));
            database.disconnect();
            return tables;
        }
        catch (KettleDatabaseException e) {
            this.logger.error((Object)"Error creating database object", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
        catch (ConnectionServiceException e) {
            this.logger.error((Object)"Error getting database meta", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
    }

    @Override
    public IDatasourceSummary serializeJoins(MultiTableDatasourceDTO dto, IConnection connection) throws DatasourceServiceException {
        try {
            ModelerService modelerService = new ModelerService();
            modelerService.initKettle();
            DatasourceServiceImpl datasourceService = new DatasourceServiceImpl();
            GeoContext geoContext = datasourceService.getGeoContext();
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            MultiTableModelerSource multiTable = new MultiTableModelerSource(databaseMeta, dto.getSchemaModel(), dto.getDatasourceName(), dto.getSelectedTables(), geoContext);
            Domain domain = multiTable.generateDomain(dto.isDoOlap());
            String modelState = this.serializeModelState(dto);
            for (LogicalModel lm : domain.getLogicalModels()) {
                lm.setProperty("datasourceModel", (Object)modelState);
                lm.setProperty("DatasourceType", (Object)"MULTI-TABLE-DS");
                this.applySecurity(lm);
            }
            modelerService.serializeModels(domain, dto.getDatasourceName(), dto.isDoOlap());
            QueryDatasourceSummary summary = new QueryDatasourceSummary();
            summary.setDomain(domain);
            return summary;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error serializing joins", (Throwable)e);
            throw new DatasourceServiceException(e);
        }
    }

    private String serializeModelState(MultiTableDatasourceDTO dto) throws DatasourceServiceException {
        XStream xs = new XStream();
        return xs.toXML((Object)dto);
    }

    @Override
    public MultiTableDatasourceDTO deSerializeModelState(String dtoStr) throws DatasourceServiceException {
        try {
            XStream xs = new XStream();
            return (MultiTableDatasourceDTO)xs.fromXML(dtoStr);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            throw new DatasourceServiceException(e);
        }
    }

    @Override
    public List<String> getTableFields(String table, IConnection connection) throws DatasourceServiceException {
        try {
            DatabaseMeta databaseMeta = this.getDatabaseMeta(connection);
            Database database = new Database(null, databaseMeta);
            database.connect();
            String query = databaseMeta.getSQLQueryFields(table);
            database.setQueryLimit(1);
            database.getRows(query, 1);
            String[] tableFields = database.getReturnRowMeta().getFieldNames();
            List<String> fields = Arrays.asList(tableFields);
            database.disconnect();
            return fields;
        }
        catch (KettleDatabaseException e) {
            this.logger.error((Object)e);
            throw new DatasourceServiceException(e);
        }
        catch (ConnectionServiceException e) {
            this.logger.error((Object)e);
            throw new DatasourceServiceException(e);
        }
    }

    @Override
    public BogoPojo gwtWorkaround(BogoPojo pojo) {
        return pojo;
    }

    public Log getLogger() {
        return null;
    }

    protected boolean hasDataAccessViewPermission() {
        return this.dataAccessViewPermHandler != null && this.dataAccessViewPermHandler.hasDataAccessViewPermission(PentahoSessionHolder.getSession());
    }

    protected List<String> getPermittedRoleList() {
        if (this.dataAccessViewPermHandler == null) {
            return null;
        }
        return this.dataAccessViewPermHandler.getPermittedRoleList(PentahoSessionHolder.getSession());
    }

    protected List<String> getPermittedUserList() {
        if (this.dataAccessViewPermHandler == null) {
            return null;
        }
        return this.dataAccessViewPermHandler.getPermittedUserList(PentahoSessionHolder.getSession());
    }

    protected int getDefaultAcls() {
        if (this.dataAccessViewPermHandler == null) {
            return -1;
        }
        return this.dataAccessViewPermHandler.getDefaultAcls(PentahoSessionHolder.getSession());
    }

    protected boolean isSecurityEnabled() {
        Boolean securityEnabled = this.getPermittedRoleList() != null && this.getPermittedRoleList().size() > 0 || this.getPermittedUserList() != null && this.getPermittedUserList().size() > 0;
        return securityEnabled;
    }

    protected void applySecurity(LogicalModel logicalModel) {
        if (this.isSecurityEnabled()) {
            SecurityOwner owner;
            Security security = new Security();
            for (String user : this.getPermittedUserList()) {
                owner = new SecurityOwner(SecurityOwner.OwnerType.USER, user);
                security.putOwnerRights(owner, this.getDefaultAcls());
            }
            for (String role : this.getPermittedRoleList()) {
                owner = new SecurityOwner(SecurityOwner.OwnerType.ROLE, role);
                security.putOwnerRights(owner, this.getDefaultAcls());
            }
            logicalModel.setProperty(Concept.SECURITY_PROPERTY, (Object)security);
        }
    }
}

