/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.service.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.IDataAccessPermissionHandler;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;

public class SimpleDataAccessPermissionHandler
implements IDataAccessPermissionHandler {
    private Log logger = LogFactory.getLog(SimpleDataAccessPermissionHandler.class);

    public boolean hasDataAccessPermission(IPentahoSession session) {
        String[] roleArr;
        Authentication auth = SecurityHelper.getAuthentication((IPentahoSession)session, (boolean)true);
        IPluginResourceLoader resLoader = (IPluginResourceLoader)PentahoSystem.get(IPluginResourceLoader.class, null);
        String roles = null;
        String users = null;
        try {
            roles = resLoader.getPluginSetting(this.getClass(), "settings/data-access-roles");
            users = resLoader.getPluginSetting(this.getClass(), "settings/data-access-users");
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error getting data access plugin settings", (Throwable)e);
        }
        if (roles == null) {
            roles = "Admin";
        }
        for (String role : roleArr = roles.split(",")) {
            for (GrantedAuthority userRole : auth.getAuthorities()) {
                if (role == null || !role.trim().equals(userRole.getAuthority())) continue;
                return true;
            }
        }
        if (users != null) {
            String[] userArr;
            for (String user : userArr = users.split(",")) {
                if (user == null || !user.trim().equals(auth.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

