/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.pentaho.agilebi.modeler.models.JoinFieldModel;
import org.pentaho.agilebi.modeler.models.JoinRelationshipModel;
import org.pentaho.agilebi.modeler.models.JoinTableModel;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.AbstractWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.JoinSelectionServiceGwtImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.JoinValidator;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultiTableDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultitableGuiModel;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelList;

public class JoinDefinitionsStep
extends AbstractWizardStep {
    protected static final String JOIN_DEFINITION_PANEL_ID = "joinDefinitionWindow";
    private XulVbox joinDefinitionDialog;
    private MultitableGuiModel joinGuiModel;
    private XulMenuList<JoinTableModel> leftTables;
    private XulMenuList<JoinTableModel> rightTables;
    private XulListbox joins;
    private XulListbox leftKeyFieldList;
    private XulListbox rightKeyFieldList;
    private JoinSelectionServiceGwtImpl joinSelectionServiceGwtImpl;
    private IConnection selectedConnection;
    private JoinValidator validator;
    private Binding rightKeyFieldBinding;
    private Binding leftKeyFieldBinding;

    public JoinDefinitionsStep(MultitableGuiModel joinGuiModel, JoinSelectionServiceGwtImpl joinSelectionServiceGwtImpl, MultiTableDatasource parentDatasource) {
        super(parentDatasource);
        this.joinGuiModel = joinGuiModel;
        this.joinSelectionServiceGwtImpl = joinSelectionServiceGwtImpl;
    }

    public String getName() {
        return "joinDefinitionStepController";
    }

    @Bindable
    public void createJoin() {
        JoinRelationshipModel join = new JoinRelationshipModel();
        join.setLeftKeyFieldModel(this.joinGuiModel.getLeftKeyField());
        join.setRightKeyFieldModel(this.joinGuiModel.getRightKeyField());
        if (this.validator.isValid(join)) {
            this.joinGuiModel.addJoin(join);
            this.parentDatasource.setFinishable(this.validator.allTablesJoined());
        } else {
            ((MultiTableDatasource)this.parentDatasource).displayErrors(this.validator.getError());
        }
    }

    @Bindable
    public void deleteJoin() {
        this.joinGuiModel.removeSelectedJoin();
        this.parentDatasource.setFinishable(this.validator.allTablesJoined());
    }

    public void init(IWizardModel wizardModel) throws XulException {
        this.validator = new JoinValidator(this.joinGuiModel, wizardModel);
        this.joinDefinitionDialog = (XulVbox)this.document.getElementById(JOIN_DEFINITION_PANEL_ID);
        this.joins = (XulListbox)this.document.getElementById("joins");
        this.leftKeyFieldList = (XulListbox)this.document.getElementById("leftKeyField");
        this.rightKeyFieldList = (XulListbox)this.document.getElementById("rightKeyField");
        this.leftTables = (XulMenuList)this.document.getElementById("leftTables");
        this.rightTables = (XulMenuList)this.document.getElementById("rightTables");
        super.init(wizardModel);
    }

    public void setBindings() {
        GwtBindingFactory bf = new GwtBindingFactory(this.document);
        bf.createBinding(this.joinGuiModel.getLeftTables(), "children", this.leftTables, "elements", new BindingConvertor[0]);
        bf.createBinding(this.joinGuiModel.getRightTables(), "children", this.rightTables, "elements", new BindingConvertor[0]);
        bf.createBinding(this.leftTables, "selectedItem", (Object)this.joinGuiModel, "leftJoinTable", new BindingConvertor[0]);
        bf.createBinding(this.rightTables, "selectedItem", (Object)this.joinGuiModel, "rightJoinTable", new BindingConvertor[0]);
        bf.createBinding(this.joinGuiModel.getJoins(), "children", (Object)this.joins, "elements", new BindingConvertor[0]);
        bf.createBinding((Object)this.joins, "selectedItem", (Object)this.joinGuiModel, "selectedJoin", new BindingConvertor[0]);
        bf.createBinding(this.leftTables, "selectedItem", (Object)this.leftKeyFieldList, "elements", new BindingConvertor[]{new TableSelectionConvertor(this.leftTables)});
        bf.createBinding(this.rightTables, "selectedItem", (Object)this.rightKeyFieldList, "elements", new BindingConvertor[]{new TableSelectionConvertor(this.rightTables)});
        this.leftKeyFieldBinding = bf.createBinding((Object)this.leftKeyFieldList, "selectedIndex", (Object)this.joinGuiModel, "leftKeyField", new BindingConvertor[]{new BindingConvertor<Integer, JoinFieldModel>(){

            public JoinFieldModel sourceToTarget(Integer index) {
                JoinTableModel joinTable = JoinDefinitionsStep.this.joinGuiModel.getLeftJoinTable();
                if (joinTable != null) {
                    AbstractModelList fields = joinTable.getFields();
                    if (index == -1 || fields.isEmpty()) {
                        return null;
                    }
                    return (JoinFieldModel)fields.get(index);
                }
                return null;
            }

            public Integer targetToSource(JoinFieldModel value) {
                return null;
            }
        }});
        this.rightKeyFieldBinding = bf.createBinding((Object)this.rightKeyFieldList, "selectedIndex", (Object)this.joinGuiModel, "rightKeyField", new BindingConvertor[]{new BindingConvertor<Integer, JoinFieldModel>(){

            public JoinFieldModel sourceToTarget(Integer index) {
                JoinTableModel joinTable = JoinDefinitionsStep.this.joinGuiModel.getRightJoinTable();
                if (joinTable != null) {
                    AbstractModelList fields = joinTable.getFields();
                    if (index == -1 || fields.isEmpty()) {
                        return null;
                    }
                    return (JoinFieldModel)fields.get(index);
                }
                return null;
            }

            public Integer targetToSource(JoinFieldModel value) {
                return null;
            }
        }});
    }

    public void stepActivatingForward() {
        super.stepActivatingForward();
        this.selectedConnection = ((MultiTableDatasource)this.parentDatasource).getConnection();
        this.joinGuiModel.computeJoinDefinitionStepTables();
        this.leftTables.setSelectedIndex(0);
        this.rightTables.setSelectedIndex(0);
        this.parentDatasource.setFinishable(this.validator.allTablesJoined());
    }

    public String getStepName() {
        return MessageHandler.getString("multitable.DEFINE_JOINS");
    }

    public XulComponent getUIComponent() {
        return this.joinDefinitionDialog;
    }

    public void resetComponents() {
        this.leftKeyFieldList.setElements((Collection)new AbstractModelList());
        this.rightKeyFieldList.setElements((Collection)new AbstractModelList());
    }

    public void refresh() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TableSelectionConvertor
    extends BindingConvertor<JoinTableModel, List> {
        private XulMenuList<JoinTableModel> source;

        public TableSelectionConvertor(XulMenuList<JoinTableModel> source) {
            this.source = source;
        }

        public List sourceToTarget(final JoinTableModel table) {
            if (table != null) {
                if (table.getFields() == null || table.getFields().isEmpty()) {
                    MessageHandler.getInstance().showWaitingDialog(MessageHandler.getString("multitable.FETCHING_TABLE_INFO"));
                    JoinDefinitionsStep.this.joinSelectionServiceGwtImpl.getTableFields(table.getName(), JoinDefinitionsStep.this.selectedConnection, new XulServiceCallback<List>(){

                        public void error(String message, Throwable error) {
                            MessageHandler.getInstance().closeWaitingDialog();
                        }

                        public void success(List fields) {
                            try {
                                List fieldModels = table.processTableFields(fields);
                                table.setFields(new AbstractModelList(fieldModels));
                                if (TableSelectionConvertor.this.source.equals(JoinDefinitionsStep.this.leftTables)) {
                                    JoinDefinitionsStep.this.leftKeyFieldList.setElements((Collection)table.getFields());
                                    JoinDefinitionsStep.this.leftKeyFieldBinding.fireSourceChanged();
                                } else if (TableSelectionConvertor.this.source.equals(JoinDefinitionsStep.this.rightTables)) {
                                    JoinDefinitionsStep.this.rightKeyFieldList.setElements((Collection)table.getFields());
                                    JoinDefinitionsStep.this.rightKeyFieldBinding.fireSourceChanged();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            MessageHandler.getInstance().closeWaitingDialog();
                        }
                    });
                }
                return table.getFields();
            }
            return Collections.emptyList();
        }

        public JoinTableModel targetToSource(List value) {
            return null;
        }
    }
}

