/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.pentaho.agilebi.modeler.models.JoinRelationshipModel;
import org.pentaho.agilebi.modeler.models.JoinTableModel;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.wizard.AbstractWizardStep;
import org.pentaho.platform.dataaccess.datasource.wizard.controllers.MessageHandler;
import org.pentaho.platform.dataaccess.datasource.wizard.models.IWizardModel;
import org.pentaho.platform.dataaccess.datasource.wizard.service.impl.JoinSelectionServiceGwtImpl;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultiTableDatasource;
import org.pentaho.platform.dataaccess.datasource.wizard.sources.multitable.MultitableGuiModel;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulVbox;
import org.pentaho.ui.xul.gwt.binding.GwtBindingFactory;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.util.AbstractModelList;

public class TablesSelectionStep
extends AbstractWizardStep {
    protected static final String JOIN_STEP_PANEL_ID = "joinSelectionWindow";
    private XulVbox tablesSelectionDialog;
    private XulListbox availableTables;
    private XulListbox selectedTables;
    private XulMenuList<JoinTableModel> factTables;
    private XulMenuList<String> schemas;
    private MultitableGuiModel joinGuiModel;
    private JoinSelectionServiceGwtImpl joinSelectionServiceGwtImpl;
    private SchemaSelection schemaSelection;
    private XulDialog waitingDialog;
    private XulLabel waitingLabel;

    public TablesSelectionStep(MultitableGuiModel joinGuiModel, JoinSelectionServiceGwtImpl joinSelectionServiceGwtImpl, MultiTableDatasource parentDatasource) {
        super(parentDatasource);
        this.joinGuiModel = joinGuiModel;
        this.joinSelectionServiceGwtImpl = joinSelectionServiceGwtImpl;
        this.schemaSelection = new SchemaSelection();
    }

    public String getName() {
        return "joinSelectionStepController";
    }

    public void retrieveSchemas(IConnection connection) {
        this.joinSelectionServiceGwtImpl.retrieveSchemas(connection, new XulServiceCallback<List>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List schemaValues) {
                TablesSelectionStep.this.schemas.removePropertyChangeListener((PropertyChangeListener)TablesSelectionStep.this.schemaSelection);
                TablesSelectionStep.this.joinGuiModel.setSchemas(schemaValues);
                TablesSelectionStep.this.schemas.addPropertyChangeListener((PropertyChangeListener)TablesSelectionStep.this.schemaSelection);
            }
        });
    }

    private void processAvailableTables(IConnection connection, String schema) {
        this.joinSelectionServiceGwtImpl.getDatabaseTables(connection, schema, new XulServiceCallback<List>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List tables) {
                TablesSelectionStep.this.joinGuiModel.processAvailableTables(tables);
                TablesSelectionStep.this.closeWaitingDialog();
            }
        });
    }

    @Bindable
    public void addSelectedTable() {
        if (this.availableTables.getSelectedItem() != null) {
            ArrayList<JoinTableModel> selected = new ArrayList<JoinTableModel>();
            for (Object obj : this.availableTables.getSelectedItems()) {
                selected.add((JoinTableModel)obj);
            }
            this.joinGuiModel.addSelectedTables(selected);
        }
        this.checkValidState();
    }

    @Bindable
    public void removeSelectedTable() {
        if (this.selectedTables.getSelectedItem() != null) {
            ArrayList<JoinTableModel> selected = new ArrayList<JoinTableModel>();
            for (Object obj : this.selectedTables.getSelectedItems()) {
                selected.add((JoinTableModel)obj);
            }
            this.joinGuiModel.removeSelectedTables(selected);
        }
        this.checkValidState();
        this.checkExistingJoinsStillValid();
    }

    private void checkExistingJoinsStillValid() {
        HashSet<String> allTables = new HashSet<String>();
        for (JoinTableModel tbl : this.joinGuiModel.getSelectedTables()) {
            allTables.add(tbl.getName());
        }
        ArrayList<JoinRelationshipModel> toRemove = new ArrayList<JoinRelationshipModel>();
        for (JoinRelationshipModel join : this.joinGuiModel.getJoins()) {
            if (allTables.contains(join.getLeftKeyFieldModel().getParentTable().getName()) && allTables.contains(join.getRightKeyFieldModel().getParentTable().getName())) continue;
            toRemove.add(join);
        }
        for (JoinRelationshipModel join : toRemove) {
            this.joinGuiModel.getJoins().remove((Object)join);
        }
    }

    public void init(IWizardModel wizardModel) throws XulException {
        this.tablesSelectionDialog = (XulVbox)this.document.getElementById(JOIN_STEP_PANEL_ID);
        this.availableTables = (XulListbox)this.document.getElementById("availableTables");
        this.selectedTables = (XulListbox)this.document.getElementById("selectedTables");
        this.factTables = (XulMenuList)this.document.getElementById("factTables");
        this.schemas = (XulMenuList)this.document.getElementById("schemas");
        this.waitingDialog = (XulDialog)this.document.getElementById("waitingDialog");
        this.waitingLabel = (XulLabel)this.document.getElementById("waitingDialogLabel");
        super.init(wizardModel);
    }

    public void setBindings() {
        GwtBindingFactory bf = new GwtBindingFactory(this.document);
        bf.createBinding(this.joinGuiModel.getAvailableTables(), "children", (Object)this.availableTables, "elements", new BindingConvertor[0]);
        bf.createBinding(this.joinGuiModel.getSelectedTables(), "children", (Object)this.selectedTables, "elements", new BindingConvertor[0]);
        bf.createBinding(this.joinGuiModel.getSelectedTables(), "children", this.factTables, "elements", new BindingConvertor[]{new BindingConvertor<AbstractModelList<JoinTableModel>, Collection<JoinTableModel>>(){

            public Collection<JoinTableModel> sourceToTarget(AbstractModelList<JoinTableModel> list) {
                ArrayList<JoinTableModel> tables = new ArrayList<JoinTableModel>();
                tables.addAll(list.asList());
                JoinTableModel emptyOption = new JoinTableModel();
                emptyOption.setName(MessageHandler.getString("multitable.SELECT_TABLE"));
                tables.add(0, emptyOption);
                return tables;
            }

            public AbstractModelList<JoinTableModel> targetToSource(Collection<JoinTableModel> list) {
                return null;
            }
        }});
        bf.createBinding((Object)this.joinGuiModel, "schemas", this.schemas, "elements", new BindingConvertor[]{new BindingConvertor<List<String>, Collection<String>>(){

            public Collection<String> sourceToTarget(List<String> list) {
                ArrayList<String> tables = new ArrayList<String>();
                tables.addAll(list);
                return tables;
            }

            public List<String> targetToSource(Collection<String> list) {
                return null;
            }
        }});
        bf.createBinding(this.factTables, "selectedIndex", (Object)this.joinGuiModel, "factTable", new BindingConvertor[]{new BindingConvertor<Integer, JoinTableModel>(){

            public JoinTableModel sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                TablesSelectionStep.this.checkValidState();
                int i = index;
                return --i < 0 ? null : (JoinTableModel)TablesSelectionStep.this.joinGuiModel.getSelectedTables().get(i);
            }

            public Integer targetToSource(JoinTableModel value) {
                return TablesSelectionStep.this.joinGuiModel.getSelectedTables().indexOf((Object)value);
            }
        }});
        try {
            bf.createBinding((Object)this.joinGuiModel, "doOlap", "factTableVbox", "visible", new BindingConvertor[0]).fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getStepName() {
        return MessageHandler.getString("multitable.SELECT_TABLES");
    }

    public XulComponent getUIComponent() {
        return this.tablesSelectionDialog;
    }

    public void setFactTable(JoinTableModel factTable) {
        ArrayList tables = new ArrayList();
        tables.addAll(this.factTables.getElements());
        this.factTables.setSelectedIndex(tables.indexOf(factTable.getName()));
    }

    public void stepActivatingReverse() {
        super.stepActivatingReverse();
        this.parentDatasource.setFinishable(false);
        this.checkValidState();
    }

    private void checkValidState() {
        boolean valid = true;
        boolean finishable = true;
        if (this.joinGuiModel.isDoOlap()) {
            valid &= this.factTables.getSelectedIndex() > 0;
            finishable &= this.factTables.getSelectedIndex() > 0;
        }
        boolean bl = this.selectedTables.getElements().size() == 1;
        super.setValid(valid &= this.selectedTables.getElements().size() > 1);
        this.parentDatasource.setFinishable(finishable &= bl);
    }

    public void stepActivatingForward() {
        super.stepActivatingForward();
        if (this.joinGuiModel.getAvailableTables() == null || this.joinGuiModel.getAvailableTables().size() == 0) {
            this.fetchTables();
        }
        this.checkValidState();
    }

    public void closeWaitingDialog() {
        this.waitingDialog.hide();
    }

    public void showWaitingDialog() {
        this.waitingLabel.setValue(MessageHandler.getString("multitable.FETCHING_TABLE_INFO"));
        this.waitingDialog.show();
    }

    protected void fetchTables() {
        this.showWaitingDialog();
        IConnection connection = ((MultiTableDatasource)this.parentDatasource).getConnection();
        this.processAvailableTables(connection, this.schemas.getValue());
    }

    public void refresh() {
        IConnection connection = ((MultiTableDatasource)this.parentDatasource).getConnection();
        this.joinSelectionServiceGwtImpl.retrieveSchemas(connection, new XulServiceCallback<List>(){

            public void error(String message, Throwable error) {
                error.printStackTrace();
            }

            public void success(List schemaValues) {
                TablesSelectionStep.this.schemas.removePropertyChangeListener((PropertyChangeListener)TablesSelectionStep.this.schemaSelection);
                TablesSelectionStep.this.joinGuiModel.setSchemas(schemaValues);
                TablesSelectionStep.this.schemas.addPropertyChangeListener((PropertyChangeListener)TablesSelectionStep.this.schemaSelection);
                TablesSelectionStep.this.fetchTables();
            }
        });
    }

    class SchemaSelection
    implements PropertyChangeListener {
        SchemaSelection() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getNewValue() instanceof String && TablesSelectionStep.this.activated) {
                TablesSelectionStep.this.fetchTables();
            }
        }
    }
}

