/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.metadata.model.impl;

import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.CombinationType;
import org.pentaho.platform.dataaccess.metadata.model.ICondition;
import org.pentaho.platform.dataaccess.metadata.model.Operator;

public class Condition
implements ICondition {
    private static final long serialVersionUID = 6382700024558898605L;
    private String column;
    private String category;
    private String operator = Operator.EQUAL.name();
    private String[] value;
    private String comboType = CombinationType.AND.name();

    public String getColumn() {
        return this.column;
    }

    public String getCombinationType() {
        return this.comboType;
    }

    public String getOperator() {
        return this.operator;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public void setCombinationType(String combinationType) {
        this.comboType = combinationType;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    public boolean validate() {
        return true;
    }

    public String getCondition(String type) {
        return this.getCondition(type, this.column);
    }

    public String getCondition(String type, String paramName) {
        String[] val = this.value;
        Operator theOperator = Operator.parse(this.operator);
        if (type.equalsIgnoreCase(DataType.STRING.getName()) && theOperator == Operator.EQUAL) {
            theOperator = Operator.EXACTLY_MATCHES;
        }
        if (type.equalsIgnoreCase(DataType.STRING.getName())) {
            for (int idx = 0; idx < val.length; ++idx) {
                val[idx] = "\"" + val[idx] + "\"";
            }
        }
        boolean enforceParameters = paramName != null;
        String columnName = "[" + this.category + "." + this.column + "]";
        if (type.equals(DataType.DATE.getName())) {
            if (enforceParameters) {
                for (int idx = 0; idx < val.length; ++idx) {
                    val[idx] = "DATEVALUE([param:" + this.value[idx].replaceAll("[\\{\\}]", "") + "]" + ")";
                }
                return theOperator.formatCondition(columnName, paramName, val, false);
            }
            for (int idx = 0; idx < val.length; ++idx) {
                val[idx] = "DATEVALUE(\"" + val[idx] + "\")";
            }
        }
        return theOperator.formatCondition(columnName, paramName, val, enforceParameters);
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

