/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.dataaccess.metadata.service;

import flexjson.JSONDeserializer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.Concept;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.Alignment;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.model.concept.types.FieldType;
import org.pentaho.metadata.model.concept.types.LocalizedString;
import org.pentaho.metadata.query.model.CombinationType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.dataaccess.metadata.messages.Messages;
import org.pentaho.platform.dataaccess.metadata.model.impl.Column;
import org.pentaho.platform.dataaccess.metadata.model.impl.Condition;
import org.pentaho.platform.dataaccess.metadata.model.impl.Model;
import org.pentaho.platform.dataaccess.metadata.model.impl.Order;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.pms.core.exception.PentahoMetadataException;

public class MetadataServiceUtil
extends PentahoBase {
    private static final long serialVersionUID = -123835493828427853L;
    private Log logger = LogFactory.getLog(MetadataServiceUtil.class);
    private Domain domain;

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    protected String getLocale() {
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])this.domain.getLocaleCodes());
        return locale;
    }

    public Model createThinModel(LogicalModel m, String domainId) {
        Model model = new Model();
        model.setName(m.getName(this.getLocale()));
        model.setId(m.getId());
        model.setDomainId(domainId);
        model.setDescription(m.getDescription(this.getLocale()));
        ArrayList<org.pentaho.platform.dataaccess.metadata.model.impl.Category> categories = new ArrayList<org.pentaho.platform.dataaccess.metadata.model.impl.Category>();
        for (Category cat : m.getCategories()) {
            categories.add(this.createCategory(m, cat));
        }
        model.setCategories(categories.toArray(new org.pentaho.platform.dataaccess.metadata.model.impl.Category[categories.size()]));
        return model;
    }

    private org.pentaho.platform.dataaccess.metadata.model.impl.Category createCategory(LogicalModel m, Category c) {
        org.pentaho.platform.dataaccess.metadata.model.impl.Category cat = new org.pentaho.platform.dataaccess.metadata.model.impl.Category();
        cat.setName(c.getName(this.getLocale()));
        cat.setId(c.getId());
        ArrayList<Column> columns = new ArrayList<Column>();
        for (LogicalColumn col : c.getLogicalColumns()) {
            columns.add(this.createColumn(m, col, c));
        }
        cat.setColumns(columns.toArray(new Column[columns.size()]));
        return cat;
    }

    private Column createColumn(LogicalModel m, LogicalColumn c, Category category) {
        Column col = new Column();
        col.setName(c.getName(this.getLocale()));
        col.setId(c.getId());
        if (c.getFieldType() != null) {
            col.setFieldType(c.getFieldType().name());
        } else {
            col.setFieldType("UNKNOWN");
        }
        col.setType(c.getDataType().getName().toUpperCase());
        col.setCategory(category.getId());
        List possibleAggs = c.getAggregationList();
        ArrayList<String> aggTypes = new ArrayList<String>();
        if (possibleAggs != null) {
            for (AggregationType agg : possibleAggs) {
                aggTypes.add(agg.name());
            }
        }
        AggregationType defaultAggType = AggregationType.NONE;
        if (c.getAggregationType() != null) {
            defaultAggType = c.getAggregationType();
        }
        if (!aggTypes.contains(defaultAggType)) {
            aggTypes.add(defaultAggType.name());
        }
        col.setAggTypes(aggTypes);
        col.setDefaultAggType(defaultAggType.name());
        col.setSelectedAggType(defaultAggType.name());
        DataType dataType = c.getDataType();
        FieldType fieldType = c.getFieldType();
        Object obj = c.getProperty("alignment");
        if (obj instanceof Alignment) {
            if (obj == Alignment.LEFT) {
                col.setHorizontalAlignment(Alignment.LEFT.toString());
            } else if (obj == Alignment.RIGHT) {
                col.setHorizontalAlignment(Alignment.RIGHT.toString());
            } else if (obj == Alignment.CENTERED) {
                col.setHorizontalAlignment(Alignment.CENTERED.toString());
            }
        } else if (fieldType == FieldType.FACT) {
            col.setHorizontalAlignment(Alignment.RIGHT.toString());
        } else if (fieldType == FieldType.OTHER && dataType == DataType.NUMERIC) {
            col.setHorizontalAlignment(Alignment.RIGHT.toString());
        } else {
            col.setHorizontalAlignment(Alignment.LEFT.toString());
        }
        obj = c.getProperty("mask");
        if (obj != null) {
            col.setFormatMask((String)obj);
        }
        return col;
    }

    public String createCdaJson(IPentahoResultSet resultSet, String locale) throws JSONException {
        if (resultSet == null) {
            return null;
        }
        JSONObject json = new JSONObject();
        JSONArray metadataArray = new JSONArray();
        int columnCount = resultSet.getColumnCount();
        int rowCount = resultSet.getRowCount();
        for (int i = 0; i < columnCount; ++i) {
            JSONObject info = new JSONObject();
            info.put("colIndex", i);
            info.put("colName", resultSet.getMetaData().getColumnHeaders()[0][i]);
            DataType type = (DataType)resultSet.getMetaData().getAttribute(0, i, "datatype");
            info.put("colType", (Object)type.getName().toUpperCase());
            LocalizedString name = (LocalizedString)resultSet.getMetaData().getAttribute(0, i, Concept.NAME_PROPERTY);
            if (name != null && locale != null) {
                info.put("colLabel", (Object)name.getString(locale));
            }
            metadataArray.put((Object)info);
        }
        json.put("metadata", (Object)metadataArray);
        JSONArray valuesArray = new JSONArray();
        for (int rowIdx = 0; rowIdx < rowCount; ++rowIdx) {
            JSONArray rowArray = new JSONArray();
            valuesArray.put((Object)rowArray);
            for (int colIdx = 0; colIdx < columnCount; ++colIdx) {
                rowArray.put(resultSet.getValueAt(rowIdx, colIdx));
            }
        }
        json.put("resultset", (Object)valuesArray);
        return json.toString();
    }

    public Domain getDomainObject(String query) throws PentahoMetadataException {
        QueryXmlHelper helper = new QueryXmlHelper();
        IMetadataDomainRepository domainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        Query fatQuery = helper.fromXML(domainRepository, query);
        return fatQuery.getDomain();
    }

    public Query convertQuery(org.pentaho.platform.dataaccess.metadata.model.impl.Query src) {
        Order.Type type;
        IMetadataDomainRepository domainRepository = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        Domain fullDomain = domainRepository.getDomain(src.getDomainName());
        LogicalModel logicalModel = fullDomain.findLogicalModel(src.getModelId());
        Query dest = new Query(fullDomain, logicalModel);
        List selections = dest.getSelections();
        for (Column column : src.getColumns()) {
            LogicalColumn logicalColumn = logicalModel.findLogicalColumn(column.getId());
            Category category = this.getCategory(column.getId(), logicalModel);
            AggregationType aggregationType = AggregationType.valueOf((String)column.getSelectedAggType());
            Selection selection = new Selection(category, logicalColumn, aggregationType);
            selections.add(selection);
        }
        List constraints = dest.getConstraints();
        for (Condition condition : src.getConditions()) {
            CombinationType combinationType = CombinationType.valueOf((String)condition.getCombinationType());
            LogicalColumn logicalColumn = logicalModel.findLogicalColumn(condition.getColumn());
            String paramName = null;
            for (org.pentaho.platform.dataaccess.metadata.model.impl.Parameter parameter : src.getParameters()) {
                if (!parameter.getColumn().equals(condition.getColumn())) continue;
                paramName = parameter.getName() == null ? parameter.getColumn() : parameter.getName();
            }
            String formula = condition.getCondition(logicalColumn.getDataType().name(), paramName);
            Constraint constraint = new Constraint(combinationType, formula);
            constraints.add(constraint);
        }
        if (src.getDisableDistinct() != null) {
            dest.setDisableDistinct(src.getDisableDistinct().booleanValue());
        }
        List orders = dest.getOrders();
        for (Order order : src.getOrders()) {
            for (Selection selection : selections) {
                if (!selection.getLogicalColumn().getId().equals(order.getColumn())) continue;
                type = Order.Type.valueOf((String)order.getOrderType());
                org.pentaho.metadata.query.model.Order fullOrder = new org.pentaho.metadata.query.model.Order(selection, type);
                orders.add(fullOrder);
            }
        }
        List parameters = dest.getParameters();
        for (org.pentaho.platform.dataaccess.metadata.model.impl.Parameter parameter : src.getParameters()) {
            LogicalColumn logicalColumn = logicalModel.findLogicalColumn(parameter.getColumn());
            type = logicalColumn.getDataType();
            String[] value = parameter.getValue();
            Parameter fullParam = new Parameter(parameter.getColumn(), (DataType)type, (Object)value[0]);
            parameters.add(fullParam);
        }
        return dest;
    }

    protected Category getCategory(String columnId, LogicalModel logicalModel) {
        for (Category category : logicalModel.getCategories()) {
            if (category.findLogicalColumn(columnId) == null) continue;
            return category;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.pentaho.platform.dataaccess.metadata.model.impl.Query deserializeJsonQuery(String json) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            org.pentaho.platform.dataaccess.metadata.model.impl.Query query = (org.pentaho.platform.dataaccess.metadata.model.impl.Query)new JSONDeserializer().deserialize(json);
            Thread.currentThread().setContextClassLoader(oldLoader);
            return query;
        }
        catch (Throwable throwable) {
            try {
                Thread.currentThread().setContextClassLoader(oldLoader);
                throw throwable;
            }
            catch (Exception e) {
                this.error(Messages.getErrorString("MetadataService.ERROR_0007_BAD_JSON", json), e);
                return null;
            }
        }
    }

    public Log getLogger() {
        return this.logger;
    }
}

