/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.io.ISerializer;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageProducer;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.IndexClause;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.TBinaryProtocol;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TProtocolFactory;

public class IndexScanCommand
implements MessageProducer {
    private static final IndexScanCommandSerializer serializer = new IndexScanCommandSerializer();
    public final String keyspace;
    public final String column_family;
    public final IndexClause index_clause;
    public final SlicePredicate predicate;
    public final AbstractBounds range;

    public IndexScanCommand(String keyspace, String column_family, IndexClause index_clause, SlicePredicate predicate, AbstractBounds range) {
        this.keyspace = keyspace;
        this.column_family = column_family;
        this.index_clause = index_clause;
        this.predicate = predicate;
        this.range = range;
    }

    @Override
    public Message getMessage(Integer version) {
        DataOutputBuffer dob = new DataOutputBuffer();
        try {
            serializer.serialize(this, (DataOutput)dob);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.INDEX_SCAN, Arrays.copyOf(dob.getData(), dob.getLength()), version);
    }

    public static IndexScanCommand read(Message message) throws IOException {
        byte[] bytes = message.getMessageBody();
        FastByteArrayInputStream bis = new FastByteArrayInputStream(bytes);
        return serializer.deserialize(new DataInputStream(bis));
    }

    private static class IndexScanCommandSerializer
    implements ISerializer<IndexScanCommand> {
        private IndexScanCommandSerializer() {
        }

        @Override
        public void serialize(IndexScanCommand o, DataOutput out) throws IOException {
            out.writeUTF(o.keyspace);
            out.writeUTF(o.column_family);
            TSerializer ser = new TSerializer((TProtocolFactory)new TBinaryProtocol.Factory());
            FBUtilities.serialize(ser, (TBase)o.index_clause, out);
            FBUtilities.serialize(ser, (TBase)o.predicate, out);
            AbstractBounds.serializer().serialize(o.range, out);
        }

        @Override
        public IndexScanCommand deserialize(DataInput in) throws IOException {
            String keyspace = in.readUTF();
            String columnFamily = in.readUTF();
            TDeserializer dser = new TDeserializer((TProtocolFactory)new TBinaryProtocol.Factory());
            IndexClause indexClause = new IndexClause();
            FBUtilities.deserialize(dser, (TBase)indexClause, in);
            SlicePredicate predicate = new SlicePredicate();
            FBUtilities.deserialize(dser, (TBase)predicate, in);
            AbstractBounds range = AbstractBounds.serializer().deserialize(in);
            return new IndexScanCommand(keyspace, columnFamily, indexClause, predicate, range);
        }

        @Override
        public long serializedSize(IndexScanCommand object) {
            throw new UnsupportedOperationException();
        }
    }
}

