/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

public class BytesReadTracker
implements DataInput {
    private long bytesRead;
    private DataInput source;

    public BytesReadTracker(DataInput source) {
        this.source = source;
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    public void reset(long count) {
        this.bytesRead = count;
    }

    @Override
    public boolean readBoolean() throws IOException {
        boolean bool = this.source.readBoolean();
        ++this.bytesRead;
        return bool;
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.source.readByte();
        ++this.bytesRead;
        return b;
    }

    @Override
    public char readChar() throws IOException {
        char c = this.source.readChar();
        this.bytesRead += 2L;
        return c;
    }

    @Override
    public double readDouble() throws IOException {
        double d = this.source.readDouble();
        this.bytesRead += 8L;
        return d;
    }

    @Override
    public float readFloat() throws IOException {
        float f = this.source.readFloat();
        this.bytesRead += 4L;
        return f;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.source.readFully(b, off, len);
        this.bytesRead += (long)len;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.source.readFully(b);
        this.bytesRead += (long)b.length;
    }

    @Override
    public int readInt() throws IOException {
        int i = this.source.readInt();
        this.bytesRead += 4L;
        return i;
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long readLong() throws IOException {
        long l = this.source.readLong();
        this.bytesRead += 8L;
        return l;
    }

    @Override
    public short readShort() throws IOException {
        short s = this.source.readShort();
        this.bytesRead += 2L;
        return s;
    }

    @Override
    public String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        int i = this.source.readUnsignedByte();
        ++this.bytesRead;
        return i;
    }

    @Override
    public int readUnsignedShort() throws IOException {
        int i = this.source.readUnsignedShort();
        this.bytesRead += 2L;
        return i;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skipped = this.source.skipBytes(n);
        this.bytesRead += (long)skipped;
        return skipped;
    }
}

