/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.metadata.service;

import flexjson.JSONSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.common.ui.metadata.service.MetadataServiceUtil2;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.marshal.MarshallableResultSet;
import org.pentaho.metadata.datatable.DataTable;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.thin.Model;
import org.pentaho.metadata.model.thin.ModelInfo;
import org.pentaho.metadata.model.thin.ModelInfoComparator;
import org.pentaho.metadata.model.thin.ModelProvider;
import org.pentaho.metadata.model.thin.Provider;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.pentahometadata.MetadataQueryComponent;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.pms.core.exception.PentahoMetadataException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataService2
extends PentahoBase
implements ModelProvider {
    public static final String PROVIDER_ID = "MetadataImpl";
    private static final long serialVersionUID = 8481450224870463494L;
    private Log logger = LogFactory.getLog(MetadataService2.class);
    private Provider provider;

    public MetadataService2() {
        this.setLoggingLevel(5);
        this.provider = new Provider();
        this.provider.setId(PROVIDER_ID);
        this.provider.setName("Relational Metadata");
    }

    public ModelInfo[] getModelList(String providerId, String domain, String match) {
        if (providerId != null && !providerId.equals(PROVIDER_ID)) {
            return new ModelInfo[0];
        }
        ArrayList<ModelInfo> models = new ArrayList<ModelInfo>();
        IMetadataDomainRepository repo = this.getMetadataRepository();
        if (repo == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0001_BAD_REPO"));
            return null;
        }
        try {
            if (StringUtils.isEmpty((String)domain)) {
                for (String aDomain : this.getMetadataRepository().getDomainIds()) {
                    this.getModelInfos(match, aDomain, models);
                }
            } else {
                this.getModelInfos(match, domain, models);
            }
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0002_BAD_MODEL_LIST"), t);
        }
        Collections.sort(models, new ModelInfoComparator());
        return models.toArray(new ModelInfo[models.size()]);
    }

    private void getModelInfos(String match, String domain, List<ModelInfo> models) {
        IMetadataDomainRepository repo = this.getMetadataRepository();
        Object context = null;
        Domain domainObject = repo.getDomain(domain);
        if (domainObject == null) {
            return;
        }
        String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domainObject.getLocaleCodes());
        for (LogicalModel model : domainObject.getLogicalModels()) {
            String vis = (String)model.getProperty("visible");
            if (vis != null) {
                String[] visibleContexts = vis.split(",");
                boolean visibleToContext = false;
                for (String c : visibleContexts) {
                    if (!c.equals(context)) continue;
                    visibleToContext = true;
                    break;
                }
                if (!visibleToContext) continue;
            }
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.setGroupId(domain);
            modelInfo.setModelId(model.getId());
            modelInfo.setName(model.getName(locale));
            modelInfo.setProvider(this.provider);
            if (model.getDescription() != null) {
                String modelDescription = model.getDescription(locale);
                modelInfo.setDescription(modelDescription);
            }
            models.add(modelInfo);
        }
    }

    public Model getModel(String id) {
        StringTokenizer tokenizer = new StringTokenizer(id, "~");
        String providerId = null;
        String domainId = null;
        String modelId = null;
        while (tokenizer.hasMoreElements()) {
            String str = tokenizer.nextToken();
            if (providerId == null) {
                providerId = str;
                continue;
            }
            if (domainId == null) {
                domainId = str;
                continue;
            }
            modelId = str;
        }
        if (domainId == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0003_NULL_DOMAIN"));
            return null;
        }
        if (modelId == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0004_NULL_Model"));
            return null;
        }
        Domain domain = this.getMetadataRepository().getDomain(domainId);
        if (domain == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0005_DOMAIN_NOT_FOUND", domainId));
            return null;
        }
        LogicalModel model = domain.findLogicalModel(modelId);
        if (model == null) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0006_MODEL_NOT_FOUND", modelId));
            return null;
        }
        MetadataServiceUtil2 util = new MetadataServiceUtil2();
        util.setDomain(domain);
        Model thinModel = util.createThinModel(model, domainId);
        thinModel.setProvider(this.provider);
        return thinModel;
    }

    public DataTable executeQuery(org.pentaho.metadata.model.thin.Query query, int rowLimit) {
        return null;
    }

    public MarshallableResultSet doQuery(org.pentaho.metadata.model.thin.Query query, Integer rowLimit) {
        MetadataServiceUtil2 util = new MetadataServiceUtil2();
        Model model = this.getModel(query.getSourceId());
        Query fullQuery = util.convertQuery(query, (ModelInfo)model);
        QueryXmlHelper helper = new QueryXmlHelper();
        String xml = helper.toXML(fullQuery);
        return this.doXmlQuery(xml, rowLimit);
    }

    public MarshallableResultSet doXmlQuery(String xml, Integer rowLimit) {
        IPentahoResultSet resultSet = this.executeQuery(xml, rowLimit);
        if (resultSet == null) {
            return null;
        }
        MarshallableResultSet result = new MarshallableResultSet();
        result.setResultSet(resultSet);
        return result;
    }

    public String doXmlQueryToJson(String xml, int rowLimit) {
        MarshallableResultSet resultSet = this.doXmlQuery(xml, rowLimit);
        if (resultSet == null) {
            return null;
        }
        JSONSerializer serializer = new JSONSerializer();
        String json = serializer.deepSerialize((Object)resultSet);
        return json;
    }

    public String doXmlQueryToCdaJson(String xml, int rowLimit) {
        IPentahoResultSet resultSet = this.executeQuery(xml, (Integer)rowLimit);
        if (resultSet == null) {
            return null;
        }
        String json = null;
        try {
            MetadataServiceUtil2 util = new MetadataServiceUtil2();
            Domain domain = util.getDomainObject(xml);
            util.setDomain(domain);
            String locale = LocaleHelper.getClosestLocale((String)LocaleHelper.getLocale().toString(), (String[])domain.getLocaleCodes());
            json = util.createCdaJson(resultSet, locale);
        }
        catch (JSONException e) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0007_JSON_ERROR"), e);
        }
        catch (PentahoMetadataException e) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0007_BAD_QUERY_DOMAIN"), e);
        }
        return json;
    }

    public MarshallableResultSet doJsonQuery(String json, Integer rowLimit) {
        return this.doXmlQuery(this.getQueryXmlFromJson(json), rowLimit);
    }

    public String doJsonQueryToJson(String json, int rowLimit) {
        return this.doXmlQueryToJson(this.getQueryXmlFromJson(json), rowLimit);
    }

    public String doJsonQueryToCdaJson(String json, int rowLimit) {
        return this.doXmlQueryToCdaJson(this.getQueryXmlFromJson(json), rowLimit);
    }

    protected IPentahoResultSet executeQuery(String query, Integer rowLimit) {
        MetadataQueryComponent dataComponent = new MetadataQueryComponent();
        dataComponent.setQuery(query);
        dataComponent.setLive(false);
        dataComponent.setUseForwardOnlyResultSet(true);
        if (rowLimit != null && rowLimit > -1) {
            dataComponent.setMaxRows(rowLimit);
        }
        if (dataComponent.execute()) {
            return dataComponent.getResultSet();
        }
        return null;
    }

    protected String getQueryXmlFromJson(String json) {
        MetadataServiceUtil2 util = new MetadataServiceUtil2();
        org.pentaho.metadata.model.thin.Query query = util.deserializeJsonQuery(json);
        try {
            Model model = this.getModel(query.getSourceId());
            Query fullQuery = util.convertQuery(query, (ModelInfo)model);
            QueryXmlHelper helper = new QueryXmlHelper();
            String xml = helper.toXML(fullQuery);
            return xml;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("MetadataService.ERROR_0008_BAD_QUERY"), e);
            return null;
        }
    }

    protected IMetadataDomainRepository getMetadataRepository() {
        IMetadataDomainRepository mdr = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, (IPentahoSession)PentahoSessionHolder.getSession());
        if (mdr instanceof ILogger) {
            ((ILogger)mdr).setLoggingLevel(this.getLoggingLevel());
        }
        return mdr;
    }

    public Log getLogger() {
        return this.logger;
    }

    public String getId() {
        return PROVIDER_ID;
    }
}

