/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;

public class SolutionRepoLoadContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 8445693289282403228L;

    public void createContent(OutputStream out) throws Exception {
        Element stateNode;
        IParameterProvider request = (IParameterProvider)this.parameterProviders.get("request");
        String fullPath = request.getStringParameter("filepath", null);
        if (fullPath == null) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_NO_FILEPATH"), out);
            return;
        }
        ActionInfo info = ActionInfo.parseActionString((String)fullPath);
        if (info == null) {
            this.errorMessage(Messages.getErrorString("SolutionRepo.ERROR_0003_BAD_PATH", fullPath), out);
            return;
        }
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        Document doc = repo.getResourceAsDocument(fullPath, 1);
        if (doc != null && (stateNode = (Element)doc.selectSingleNode("state-file/state")) != null) {
            out.write(stateNode.getText().getBytes());
            return;
        }
        out.write(Messages.getErrorString("SolutionRepo.ERROR_0001_LOAD_FAILED", fullPath).getBytes());
    }

    protected void errorMessage(String message, OutputStream out) throws IOException {
        out.write(message.getBytes());
        this.error(message);
    }

    public Log getLogger() {
        return LogFactory.getLog(SolutionRepoLoadContentGenerator.class);
    }

    public String getMimeType() {
        return "text/text";
    }
}

