/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.common.ui.services.StateMessage;
import org.pentaho.platform.api.engine.IContentInfo;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class SolutionRepoService
extends PentahoBase {
    private static final long serialVersionUID = 8445693289282403228L;

    public StateMessage saveStateString(String filepath, String state, String type, Boolean replace, String title, String description) throws Exception {
        return this.saveState(filepath, state, false, type, replace, title, description);
    }

    public StateMessage saveStateXml(String filepath, String state, String type, Boolean replace, String title, String description) throws Exception {
        return this.saveState(filepath, state, true, type, replace, title, description);
    }

    protected StateMessage saveState(String filepath, String state, boolean stateIsXml, String type, Boolean replace, String title, String description) throws Exception {
        int ret;
        String basePath;
        IContentInfo contentInfo;
        IPluginManager pluginManager;
        Element stateElement;
        ActionInfo info;
        StateMessage result = new StateMessage();
        result.setStatus("FAILED");
        if (StringUtils.isEmpty((String)filepath)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_NO_FILEPATH"));
            return result;
        }
        if (StringUtils.isEmpty((String)state)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0002_NO_STATE"));
            return result;
        }
        if (StringUtils.isEmpty((String)type)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0007_NO_TYPE"));
            return result;
        }
        if (replace == null) {
            replace = Boolean.FALSE;
        }
        if ((info = ActionInfo.parseActionString((String)filepath)) == null) {
            result.setMessage(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0005_BAD_FILEPATH", filepath));
            return result;
        }
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("state-file");
        Element documentation = root.addElement("documentation");
        documentation.addElement("author").addCDATA(userSession.getName());
        if (stateIsXml) {
            stateElement = root.addElement("state-xml");
            Document stateDoc = null;
            try {
                stateDoc = DocumentHelper.parseText((String)state);
            }
            catch (Exception e) {
                result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0009_BAD_STATE", state));
                return result;
            }
            Element stateRoot = stateDoc.getRootElement();
            stateRoot = stateRoot.detach();
            stateElement.add((Node)stateRoot);
        } else {
            stateElement = root.addElement("state-text");
            stateElement.addCDATA(state);
        }
        documentation.addElement("title").addCDATA(title);
        documentation.addElement("description").addCDATA(description);
        String fileName = info.getActionName();
        if (!fileName.endsWith('.' + type)) {
            fileName = fileName + '.' + type;
        }
        if ((pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)userSession)) != null && (contentInfo = pluginManager.getContentInfoFromExtension(type, userSession)) != null) {
            String icon = contentInfo.getIconUrl();
            documentation.addElement("icon").addCDATA(icon);
        }
        if (!(basePath = PentahoSystem.getApplicationContext().getSolutionRootPath()).endsWith("/")) {
            basePath = basePath + '/';
        }
        if ((ret = repo.addSolutionFile(basePath, info.getSolutionName() + '/' + info.getPath(), fileName, doc.asXML().getBytes(), replace.booleanValue())) == 1) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0004_CANNOT_REPLACE"));
            return result;
        }
        if (ret == 5) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0005_CREDENTIALS"));
            return result;
        }
        if (ret != 3) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0006_SAVE_FAILED"));
            return result;
        }
        result.setStatus("SUCCESS");
        result.setMessage(Messages.getString("SolutionRepo.USER_FILE_SAVE"));
        return result;
    }

    public StateMessage loadState(String filepath) throws Exception {
        StateMessage result = new StateMessage();
        filepath = URLDecoder.decode(filepath);
        result.setStatus("FAILED");
        if (StringUtils.isEmpty((String)filepath)) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_NO_FILEPATH"));
            return result;
        }
        ActionInfo info = ActionInfo.parseActionString((String)filepath);
        if (info == null) {
            result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0003_BAD_PATH", filepath));
            return result;
        }
        IPentahoSession userSession = PentahoSessionHolder.getSession();
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        Document doc = repo.getResourceAsDocument(filepath, 1);
        if (doc != null) {
            Element stateNode = (Element)doc.selectSingleNode("state-file/state-xml");
            if (stateNode != null) {
                result.setStatus("SUCCESS");
                result.setState(stateNode.asXML());
                return result;
            }
            stateNode = (Element)doc.selectSingleNode("state-file/state-text");
            if (stateNode != null) {
                result.setStatus("SUCCESS");
                result.setState(stateNode.getText());
                return result;
            }
        }
        result.setMessage(Messages.getErrorString("SolutionRepo.ERROR_0001_LOAD_FAILED", filepath));
        return result;
    }

    public Log getLogger() {
        return LogFactory.getLog(SolutionRepoService.class);
    }
}

