/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.common.ui.services;

import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.common.ui.messages.Messages;
import org.pentaho.platform.api.engine.IContentGenerator;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.BaseContentGenerator;
import org.pentaho.platform.util.web.MimeHelper;

public class SolutionUrlContentGenerator
extends BaseContentGenerator {
    private static final long serialVersionUID = 8445693289282403228L;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_STATIC = 1;
    public static final int TYPE_PLUGIN = 2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createContent() throws Exception {
        IContentGenerator contentGenerator;
        IPluginManager pluginManager;
        OutputStream out = null;
        if (this.outputHandler == null) {
            this.error(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0004_NO_OUTPUT_HANDLER"));
            throw new InvalidParameterException(Messages.getString("SolutionUrlContentGenerator.ERROR_0004_NO_OUTPUT_HANDLER"));
        }
        IParameterProvider params = (IParameterProvider)this.parameterProviders.get("path");
        String urlPath = params.getStringParameter("path", null);
        ActionInfo pathInfo = ActionInfo.parseActionString((String)urlPath);
        if (pathInfo == null) {
            this.error(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0001_NO_FILEPATH"));
            return;
        }
        if (urlPath.startsWith("system/")) {
            this.error(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0005_BAD_FILEPATH"));
            return;
        }
        this.debug("SolutionResourceContentGenerator urlPath=" + urlPath);
        boolean type = false;
        String filename = pathInfo.getActionName();
        String extension = "";
        int index = filename.lastIndexOf(46);
        if (index != -1) {
            extension = filename.substring(index + 1);
        }
        if (!type && (pluginManager = (IPluginManager)PentahoSystem.get(IPluginManager.class, (IPentahoSession)this.userSession)) != null && (contentGenerator = pluginManager.getContentGeneratorForType(extension, this.userSession)) != null) {
            IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
            if (requestParams instanceof SimpleParameterProvider) {
                ((SimpleParameterProvider)requestParams).setParameter("solution", pathInfo.getSolutionName());
                ((SimpleParameterProvider)requestParams).setParameter("path", pathInfo.getPath());
                ((SimpleParameterProvider)requestParams).setParameter("name", pathInfo.getActionName());
                ((SimpleParameterProvider)requestParams).setParameter("action", pathInfo.getActionName());
            }
            contentGenerator.setCallbacks(this.callbacks);
            contentGenerator.setInstanceId(this.instanceId);
            contentGenerator.setItemName(this.itemName);
            contentGenerator.setLoggingLevel(this.loggingLevel);
            contentGenerator.setMessagesList(this.messages);
            contentGenerator.setOutputHandler(this.outputHandler);
            contentGenerator.setParameterProviders(this.parameterProviders);
            contentGenerator.setSession(this.userSession);
            contentGenerator.setUrlFactory(this.urlFactory);
            contentGenerator.createContent();
            return;
        }
        String mimeType = MimeHelper.getMimeTypeFromFileName((String)filename);
        if (mimeType != null && mimeType.equals(MimeHelper.MIMETYPE_XACTION)) {
            mimeType = null;
        }
        if ((pathInfo.getPath().startsWith("resources/web/") || pathInfo.getPath().equals("resources/web")) && mimeType != null) {
            type = true;
        }
        if (!type) {
            this.warn(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0002_CANNOT_HANDLE_TYPE", urlPath));
            return;
        }
        IContentItem contentItem = this.outputHandler.getOutputContentItem("response", "content", "", this.instanceId, mimeType);
        if (contentItem == null) {
            this.error(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0006_NO_OUTPUT_ITEM"));
            throw new InvalidParameterException(Messages.getString("SolutionUrlContentGenerator.ERROR_0006_NO_OUTPUT_ITEM"));
        }
        contentItem.setMimeType(mimeType);
        out = contentItem.getOutputStream(this.itemName);
        if (out == null) {
            this.error(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0007_NO_OUTPUT_STREAM"));
            throw new InvalidParameterException(Messages.getString("SolutionUrlContentGenerator.ERROR_0007_NO_OUTPUT_STREAM"));
        }
        ISolutionRepository repo = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)this.userSession);
        InputStream in = repo.getResourceInputStream(urlPath, false, 1);
        if (in == null) {
            this.error(Messages.getErrorString("SolutionUrlContentGenerator.ERROR_0003_RESOURCE_NOT_FOUND", urlPath));
            return;
        }
        try {
            byte[] buffer = new byte[4096];
            int n = in.read(buffer);
            while (n != -1) {
                out.write(buffer, 0, n);
                n = in.read(buffer);
            }
        }
        finally {
            out.close();
        }
    }

    public Log getLogger() {
        return LogFactory.getLog(SolutionUrlContentGenerator.class);
    }
}

