/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.content;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.TransientObjectException;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.repository.ContentException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.ISearchable;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.content.ContentItemFile;
import org.pentaho.platform.repository.content.ContentLocation;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.UUIDUtil;
import org.pentaho.platform.util.messages.MessageUtil;
import org.pentaho.platform.util.web.MimeHelper;

public class ContentItem
extends PentahoBase
implements IContentItem,
ISearchable {
    private static final long serialVersionUID = 823604019645900631L;
    private static final Log logger = LogFactory.getLog(ContentItem.class);
    private String id;
    private ContentLocation parent;
    private String path;
    private String name;
    private String title;
    private String mimeType;
    private String url;
    private String extension;
    private ContentItemFile latestFile;
    private OutputStream outputStream = null;
    private int revision = -1;
    private int writeMode;
    private int latestVersionNum;
    private static final String PATH_BUILDER = "{0}/{1}";
    private static final String[] SearchableColumns = new String[]{"name", "title", "path"};
    private static final String SearchableTable = "org.pentaho.platform.repository.content.ContentItem";
    private static final String SearchablePhraseNamedQuery = "org.pentaho.platform.repository.content.ContentItem.itemSearcher";

    protected ContentItem() {
    }

    protected ContentItem(String cntId, ContentLocation theParent, String theName, String title, String mType, String extension, String url, int writeMode) {
        this.name = theName;
        this.mimeType = mType;
        this.parent = theParent;
        this.id = cntId;
        String extnSep = ".";
        this.extension = !extension.startsWith(extnSep) ? extnSep + extension : extension;
        this.title = title;
        this.url = url;
        this.path = MessageUtil.formatMessage((String)PATH_BUILDER, (String[])new String[]{this.parent.getDirPath(), this.getName()});
        this.writeMode = writeMode;
    }

    public List getMessages() {
        return null;
    }

    protected ContentItemFile newContentFile(String actionName) {
        ContentItemFile theFile;
        String fileGuid = UUIDUtil.getUUIDAsString();
        String fileName = fileGuid + this.getExtension();
        this.latestFile = theFile = new ContentItemFile(this, fileGuid, this.parent.getDirPath(), fileName, actionName);
        HibernateUtil.makePersistent((Object)theFile);
        return theFile;
    }

    public InputStream getInputStream() throws ContentException {
        ContentItemFile cif = this.getLatestFile();
        if (this.latestFile == null) {
            throw new ContentException(Messages.getErrorString("CONTITEM.ERROR_0001_NO_EXISTING_FILES", this.getName()));
        }
        return cif.getInputStream();
    }

    public IPentahoStreamSource getDataSource() {
        ContentItemFile cif = this.getLatestFile();
        if (this.latestFile == null) {
            throw new ContentException(Messages.getErrorString("CONTITEM.ERROR_0001_NO_EXISTING_FILES", this.getName()));
        }
        String fullPath = PentahoSystem.getApplicationContext().getFileOutputPath("system/content/" + cif.getOsPath() + "/" + cif.getId() + this.extension);
        return new FilePentahoStreamSource(fullPath);
    }

    public Reader getReader() throws ContentException {
        ContentItemFile cif = this.getLatestFile();
        if (this.latestFile == null) {
            throw new ContentException(Messages.getErrorString("CONTITEM.ERROR_0002_NO_EXISTING_FILES", this.getName()));
        }
        return cif.getReader();
    }

    public OutputStream getOutputStream(String actionName) throws IOException {
        this.outputStream = null;
        if (actionName == null) {
            throw new IllegalArgumentException(Messages.getErrorString("CONTITEM.ERROR_0006_ACTION_NAME_CANNOT_BE_NULL"));
        }
        switch (this.getWriteMode()) {
            case 0: {
                ContentItemFile cif = this.newContentFile(actionName);
                this.outputStream = cif.getOutputStream(false);
                return this.outputStream;
            }
            case 1: {
                ContentItemFile cif = this.getLatestFile();
                if (cif == null) {
                    cif = this.newContentFile(actionName);
                }
                if (cif != null) {
                    cif.setFileDateTime(new Date());
                    this.outputStream = cif.getOutputStream(true);
                    return this.outputStream;
                }
                throw new IOException(Messages.getErrorString("CONTITEM.ERROR_0004_OUTPUT_STREAM_NOT_AVAILABLE"));
            }
            case 2: {
                ContentItemFile cif = this.getLatestFile();
                if (cif == null) {
                    cif = this.newContentFile(actionName);
                }
                if (cif != null) {
                    cif.setFileDateTime(new Date());
                    this.outputStream = cif.getOutputStream(true, true);
                    return this.outputStream;
                }
                throw new IOException(Messages.getErrorString("CONTITEM.ERROR_0004_OUTPUT_STREAM_NOT_AVAILABLE"));
            }
        }
        throw new ContentException(Messages.getErrorString("CONTITEM.ERROR_0003_BAD_WRITE_MODE", Integer.toString(this.getWriteMode())));
    }

    public void closeOutputStream() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException e) {
                this.error(Messages.getErrorString("ContentItem.ERROR_0001_CLOSE_OUTPUT_STREAM"), e);
            }
        }
    }

    public String getActionName() {
        return this.getLatestFile() != null ? this.getLatestFile().getActionName() : null;
    }

    public String getFileId() {
        return this.getLatestFile() != null ? this.getLatestFile().getId() : null;
    }

    public long getFileSize() {
        return this.getLatestFile() != null ? this.getLatestFile().getFileSize() : -1L;
    }

    public Date getFileDateTime() {
        return this.getLatestFile() != null ? this.getLatestFile().getFileDateTime() : null;
    }

    public int getWriteMode() {
        return this.writeMode;
    }

    public void setWriteMode(int writeMode) {
        this.writeMode = writeMode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentItem)) {
            return false;
        }
        ContentItem that = (ContentItem)((Object)other);
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    protected ContentItemFile getLatestFile() {
        if (this.latestFile == null) {
            Session session = HibernateUtil.getSession();
            Query qry = session.createQuery("from ContentItemFile cif where cif.parent = :contentParent and cif.fileDateTime = (select max(fileDateTime) from ContentItemFile where parent = :contentParent2) ");
            qry.setParameter("contentParent", (Object)this);
            qry.setParameter("contentParent2", (Object)this);
            try {
                this.latestFile = (ContentItemFile)((Object)qry.uniqueResult());
            }
            catch (TransientObjectException ignored) {
                this.latestFile = null;
            }
        }
        return this.latestFile;
    }

    public void setLatestFile(ContentItemFile latestFile) {
        this.latestFile = latestFile;
    }

    @Deprecated
    public int getLatestVersionNum() {
        return this.latestVersionNum;
    }

    @Deprecated
    public void setLatestVersionNum(int latestVersionNum) {
        this.latestVersionNum = latestVersionNum;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void removeVersion(ContentItemFile cif) {
        try {
            cif.deleteOsFile();
        }
        catch (Exception ex) {
            logger.error((Object)Messages.getErrorString("CONTITEM.ERROR_0005_COULD_NOT_DELETE_OS_FILE", cif.getCompleteFileName()), (Throwable)ex);
        }
        HibernateUtil.makeTransient((Object)cif);
        if (this.latestFile == null || this.latestFile.getId().equals(cif.getId())) {
            this.latestFile = null;
            this.getLatestFile();
        }
    }

    public void removeVersion(String fileId) {
        for (ContentItemFile cif : this.getFileVersions()) {
            if (!fileId.equalsIgnoreCase(cif.getId())) continue;
            this.removeVersion(cif);
            break;
        }
    }

    public void removeAllVersions() {
        for (ContentItemFile cif : this.getFileVersions()) {
            cif.deleteOsFile();
            HibernateUtil.makeTransient((Object)cif);
        }
        this.latestFile = null;
    }

    public ContentLocation getParent() {
        return this.parent;
    }

    public void setParent(ContentLocation theParent) {
        this.parent = theParent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String fName) {
        this.name = fName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List getFileVersions() {
        Session session = HibernateUtil.getSession();
        Query qry = session.createQuery("from ContentItemFile cif where cif.parent = :contentParent order by cif.fileDateTime");
        qry.setParameter("contentParent", (Object)this);
        return qry.list();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Log getLogger() {
        return logger;
    }

    public String[] getSearchableColumns() {
        return SearchableColumns;
    }

    public String getSearchableTable() {
        return SearchableTable;
    }

    public String getPhraseSearchQueryName() {
        return SearchablePhraseNamedQuery;
    }

    public void makeTransient() {
        this.removeAllVersions();
        HibernateUtil.makeTransient((Object)this);
    }

    public String toString() {
        return MessageFormat.format("{0}, {1}, {2}", this.getTitle(), this.getPath(), this.getMimeType());
    }

    public static final class FilePentahoStreamSource
    implements IPentahoStreamSource {
        File file;
        String fullPath;
        String mimeType;

        public FilePentahoStreamSource(String fp) {
            assert (fp != null);
            this.fullPath = fp;
            this.file = new File(this.fullPath);
            this.mimeType = MimeHelper.getMimeTypeFromFileName((String)this.file.getName());
            if (this.mimeType == null) {
                this.mimeType = "application/octet-stream";
            }
        }

        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.file));
        }

        public String getName() {
            return this.file.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            return new FileOutputStream(this.file);
        }

        public String getContentType() {
            return this.mimeType;
        }
    }
}

