/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.content;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository.ContentException;
import org.pentaho.platform.api.repository.IContentItemFile;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.content.ContentItem;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.messages.MessageUtil;

public class ContentItemFile
extends PentahoBase
implements IContentItemFile {
    private static final long serialVersionUID = 946969559555268447L;
    private static final Log logger = LogFactory.getLog(ContentItemFile.class);
    private String osFileName;
    private String osPath;
    private String actionName;
    private Date storedFileDate;
    private String id;
    private int revision = -1;
    private ContentItem parent;
    private int initialized = -1;
    private File itemFile;
    private static final String PATH_BUILDER = "{0}/{1}";

    protected ContentItemFile() {
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContentItemFile)) {
            return false;
        }
        ContentItemFile that = (ContentItemFile)((Object)other);
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public List getMessages() {
        return null;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    protected ContentItemFile(ContentItem parent, String guid, String osPath, String osFileName, String actionName) {
        this.parent = parent;
        this.id = guid;
        this.osPath = osPath;
        this.osFileName = osFileName;
        this.actionName = actionName;
        this.itemFile = new File(this.getCompleteFileName());
        this.storedFileDate = new Date(System.currentTimeMillis());
    }

    public InputStream getInputStream() throws ContentException {
        String fName = this.getCompleteFileName();
        try {
            if (this.itemFile.exists()) {
                if (this.itemFile.canRead()) {
                    return new FileInputStream(this.itemFile);
                }
                throw new ContentException(Messages.getErrorString("CONTFILE.ERROR_0001_FILE_CANNOT_BE_READ", fName));
            }
            throw new ContentException(Messages.getErrorString("CONTFILE.ERROR_0002_FILE_DOES_NOT_EXIST", fName));
        }
        catch (IOException e) {
            throw new ContentException(e.getMessage(), (Throwable)e);
        }
    }

    public Reader getReader() throws ContentException {
        InputStream is = this.getInputStream();
        return new BufferedReader(new InputStreamReader(is));
    }

    public OutputStream getOutputStream(boolean overWriteOk) throws ContentException {
        return this.getOutputStream(overWriteOk, false);
    }

    public OutputStream getOutputStream(boolean overWriteOk, boolean append) throws ContentException {
        String fName = this.getCompleteFileName();
        if (this.itemFile.exists() && !overWriteOk) {
            throw new ContentException(Messages.getErrorString("CONTFILE.ERROR_0003_OVERWRITE_DISALLOWED", fName));
        }
        try {
            if (!append) {
                if (this.itemFile.exists() && !this.itemFile.delete()) {
                    throw new ContentException(Messages.getErrorString("CONTFILE.ERROR_0004_CANNOT_DELETE_FOR_CREATE", fName));
                }
                if (this.itemFile.createNewFile()) {
                    return new BufferedOutputStream(new FileOutputStream(this.itemFile));
                }
                throw new ContentException(Messages.getErrorString("CONTFILE.ERROR_0005_CANNOT_CREATE", fName));
            }
            return new BufferedOutputStream(new FileOutputStream(this.itemFile, append));
        }
        catch (IOException ex) {
            throw new ContentException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public long copyToFile(String newFileName) throws ContentException {
        try {
            InputStream is = this.getInputStream();
            try {
                long l;
                BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(newFileName));
                try {
                    int size;
                    long bytesCopied = 0L;
                    byte[] copyBuffer = new byte[4096];
                    while ((size = is.read(copyBuffer)) != -1) {
                        ((OutputStream)os).write(copyBuffer, 0, size);
                        bytesCopied += (long)size;
                    }
                    l = bytesCopied;
                }
                catch (Throwable throwable) {
                    ((OutputStream)os).flush();
                    ((OutputStream)os).close();
                    throw throwable;
                }
                ((OutputStream)os).flush();
                ((OutputStream)os).close();
                return l;
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            throw new ContentException(Messages.getErrorString("CONTFILE.ERROR_0006_DURING_COPY", this.getCompleteFileName(), newFileName), (Throwable)ex);
        }
    }

    public boolean deleteOsFile() {
        String fName = this.getCompleteFileName();
        File f = new File(fName);
        return f.delete();
    }

    protected String getCompleteFileName() {
        return MessageUtil.formatMessage((String)PATH_BUILDER, (String[])new String[]{PentahoSystem.getApplicationContext().getFileOutputPath("system/content") + "/" + this.getOsPath(), this.getOsFileName()});
    }

    public ContentItem getParent() {
        return this.parent;
    }

    public void setParent(ContentItem parent) {
        this.parent = parent;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public Date getFileDateTime() {
        return this.storedFileDate;
    }

    protected void setFileDateTime(Date fileDateTime) {
        this.storedFileDate = fileDateTime;
    }

    public long getFileSize() {
        return this.itemFile.length();
    }

    public void setFileSize(long fileSize) {
        ++fileSize;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOsFileName() {
        return this.osFileName;
    }

    public void setOsFileName(String osFileName) {
        this.osFileName = osFileName;
    }

    public String getOsPath() {
        return this.osPath;
    }

    public void setOsPath(String osPath) {
        this.osPath = osPath;
    }

    public int getInitialized() {
        return this.initialized;
    }

    public void setInitialized(int initialized) {
        this.itemFile = new File(this.getCompleteFileName());
        this.initialized = initialized;
    }

    public File getItemFile() {
        return this.itemFile;
    }

    public void setItemFile(File itemFile) {
        this.itemFile = itemFile;
    }

    public Log getLogger() {
        return logger;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("[").append(this.getId()).append(",").append(this.getOsPath()).append(",").append(this.getOsFileName()).append(",").append(this.getActionName()).append("]");
        return buf.toString();
    }
}

