/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.content;

import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;
import org.pentaho.platform.api.repository.ContentException;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentLocation;
import org.pentaho.platform.api.repository.ISearchable;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.content.ContentItem;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.UUIDUtil;

public class ContentLocation
extends PentahoBase
implements IContentLocation,
ISearchable {
    private static final long serialVersionUID = -86133203446335770L;
    private static final Log logger = LogFactory.getLog(ContentLocation.class);
    private String dirPath;
    private String name;
    private String description;
    private String solutionId;
    private String id;
    private int revision = -1;
    private static final String[] SearchableColumns = new String[]{"name", "description", "dirPath"};
    private static final String SearchableTable = "org.pentaho.platform.repository.content.ContentLocation";
    private static final String SearchablePhraseNamedQuery = "org.pentaho.platform.repository.content.ContentLocation.locationSearcher";

    protected ContentLocation() {
    }

    protected ContentLocation(String locId, String thePath, String theName, String theDescription, String solId, boolean createIfNotExist) throws ContentException {
        this.checkPath(thePath, createIfNotExist);
        this.dirPath = thePath;
        this.name = theName;
        this.solutionId = solId;
        this.description = theDescription;
        this.id = locId;
    }

    public IContentItem newContentItem(String itemName, String title, String extension, String mType, String url, int writeMode) throws ContentException {
        String cntId = UUIDUtil.getUUIDAsString();
        return this.newContentItem(cntId, itemName, title, extension, mType, url, writeMode);
    }

    public IContentItem newContentItem(String cntId, String itemName, String title, String extension, String mType, String url, int writeMode) throws ContentException {
        ContentItem rtn = new ContentItem(cntId, this, itemName, title, mType, extension, url, writeMode);
        HibernateUtil.makePersistent((Object)rtn);
        HibernateUtil.flushSession();
        return rtn;
    }

    public IContentItem getContentItemByPath(String path) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.content.ContentItem.findItemByPath");
        qry.setString("inPath", path);
        Object rtn = null;
        try {
            rtn = qry.uniqueResult();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return (ContentItem)((Object)rtn);
    }

    public List getMessages() {
        return null;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public Iterator getContentItemIterator() {
        Session session = HibernateUtil.getSession();
        Query qry = session.createQuery("from ContentItem where parent = :contentParent");
        qry.setParameter("contentParent", (Object)this);
        List list = qry.list();
        if (list != null) {
            return list.iterator();
        }
        return null;
    }

    public IContentItem getContentItemById(String itemId) {
        Session session = HibernateUtil.getSession();
        return (ContentItem)((Object)session.get(ContentItem.class, (Serializable)((Object)itemId)));
    }

    public IContentItem getContentItemByName(String itemName) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.content.ContentItem.findItemByName");
        qry.setEntity("parent", (Object)this);
        qry.setString("name", itemName);
        Object rtn = null;
        try {
            rtn = qry.uniqueResult();
        }
        catch (Exception ignored) {
            logger.debug((Object)ignored);
        }
        return (ContentItem)((Object)rtn);
    }

    public File makeSubdirectory(String subDirName) throws ContentException {
        File f = this.checkPath();
        File newDir = new File(f, subDirName);
        if (newDir.mkdirs()) {
            return newDir;
        }
        this.throwError(Messages.getErrorString("CONTLOC.ERROR_0003_MKDIR", newDir.getAbsolutePath()));
        return null;
    }

    protected File checkPath() throws ContentException {
        return this.checkPath(this.getDirPath());
    }

    protected File checkPath(String thePath) throws ContentException {
        return this.checkPath(thePath, false);
    }

    protected File checkPath(String thePath, boolean createIfNotExist) {
        File f = new File(PentahoSystem.getApplicationContext().getFileOutputPath("system/content") + "/" + thePath);
        if (!f.exists() || !f.isDirectory()) {
            if (!createIfNotExist) {
                this.throwError(Messages.getErrorString("CONTLOC.ERROR_0004_PATH_DOES_NOT_EXIST", thePath));
            } else if (!f.mkdirs()) {
                this.throwError(Messages.getErrorString("CONTLOC.ERROR_0003_MKDIR", thePath));
            }
        }
        return f;
    }

    protected void throwError(String msg) throws ContentException {
        logger.error((Object)msg);
        throw new ContentException(msg);
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
        this.checkPath(dirPath, true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSolutionId() {
        return this.solutionId;
    }

    public void setSolutionId(String solutionId) {
        this.solutionId = solutionId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Log getLogger() {
        return logger;
    }

    public String[] getSearchableColumns() {
        return SearchableColumns;
    }

    public String getSearchableTable() {
        return SearchableTable;
    }

    public String getPhraseSearchQueryName() {
        return SearchablePhraseNamedQuery;
    }

    public String toString() {
        return MessageFormat.format("{0}, {1}", this.getDescription(), this.getDirPath());
    }
}

