/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.ContentException;
import org.pentaho.platform.api.repository.IBackgroundExecutedContentId;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentLocation;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.repository.content.BackgroundExecutedContentId;
import org.pentaho.platform.repository.content.ContentItem;
import org.pentaho.platform.repository.content.ContentItemFile;
import org.pentaho.platform.repository.content.ContentLocation;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.UUIDUtil;

public class ContentRepository
extends PentahoBase
implements IContentRepository,
IPentahoInitializer {
    private static final long serialVersionUID = -1096153176439041908L;
    private static final Log logger = LogFactory.getLog(ContentRepository.class);
    private static final ThreadLocal threadSession = new ThreadLocal();

    public static IPentahoSession getUserSession() {
        IPentahoSession userSession = (IPentahoSession)threadSession.get();
        return userSession;
    }

    public List getMessages() {
        return null;
    }

    public void setSession(IPentahoSession session) {
        threadSession.set(session);
        if (session != null) {
            this.genLogIdFromSession(session);
            HibernateUtil.beginTransaction();
        }
    }

    public void init(IPentahoSession session) {
        this.setSession(session);
    }

    public static IContentRepository getInstance(IPentahoSession sess) {
        threadSession.set(sess);
        ContentRepository rtn = new ContentRepository();
        rtn.setSession(sess);
        return rtn;
    }

    public IContentLocation newContentLocation(String thePath, String theName, String description, String solId, boolean createIfNotExists) {
        this.debug(Messages.getString("CONTREP.DEBUG_NEW_LOCATION", thePath));
        Session session = HibernateUtil.getSession();
        String locId = UUIDUtil.getUUIDAsString();
        ContentLocation cl = new ContentLocation(locId, thePath, theName, description, solId, createIfNotExists);
        this.debug(Messages.getString("CONTREP.DEBUG_CREATE_LOCATION_ID", locId));
        try {
            session.save((Object)cl);
            session.flush();
        }
        catch (HibernateException ex) {
            this.error(Messages.getErrorString("CONTREP.ERROR_0004_SAVING_LOCATION"), ex);
            throw new RepositoryException(Messages.getErrorString("CONTREP.ERROR_0004_SAVING_LOCATION"), (Throwable)ex);
        }
        return cl;
    }

    public IContentLocation getContentLocationById(String theId) {
        Session session = HibernateUtil.getSession();
        try {
            return (ContentLocation)((Object)session.get(ContentLocation.class, (Serializable)((Object)theId)));
        }
        catch (HibernateException ex) {
            throw new ContentException(Messages.getErrorString("CONTREP.ERROR_0002_GETTING_LOCATION", theId), (Throwable)ex);
        }
    }

    public IContentLocation getContentLocationByPath(String thePath) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.content.ContentLocation.findContentLocationByPath");
        qry.setString("inPath", thePath);
        Object rtn = null;
        try {
            rtn = qry.uniqueResult();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return (ContentLocation)((Object)rtn);
    }

    public IContentItem getContentItemByPath(String thePath) {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.content.ContentItem.findItemByPath");
        qry.setString("inPath", thePath);
        Object rtn = null;
        try {
            rtn = qry.uniqueResult();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return (IContentItem)rtn;
    }

    public IContentItem getContentItemById(String theId) {
        Session session = HibernateUtil.getSession();
        try {
            return (IContentItem)session.get(ContentItem.class, (Serializable)((Object)theId));
        }
        catch (HibernateException ex) {
            throw new ContentException(Messages.getErrorString("CONTREP.ERROR_0003_GETTING_CONTENT_BY_ID", theId), (Throwable)ex);
        }
    }

    public List getAllContentLocations() {
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.content.ContentLocation.findAllContentLocations");
        return qry.list();
    }

    public List searchLocationsForTerms(String searchTerm, int searchType) {
        ContentLocation location = new ContentLocation();
        return HibernateUtil.searchForTerm(location, searchTerm, searchType);
    }

    public List searchContentItemsForTerms(String searchTerm, int searchType) {
        ContentItem anItem = new ContentItem();
        return HibernateUtil.searchForTerm(anItem, searchTerm, searchType);
    }

    public List searchLocationsAndItemsForTerms(String searchTerm, int searchType) {
        List rtn1 = this.searchLocationsForTerms(searchTerm, searchType);
        List rtn2 = this.searchContentItemsForTerms(searchTerm, searchType);
        ArrayList rtn = new ArrayList(rtn1);
        rtn.addAll(rtn2);
        return rtn;
    }

    public int deleteContentOlderThanDate(Date agingDate) {
        int removedCount = 0;
        Session session = HibernateUtil.getSession();
        Query qry = session.getNamedQuery("org.pentaho.platform.repository.content.ContentItemFile.agingContentSearcher").setDate("archiveDate", agingDate);
        List contentItemFilesForDeletion = qry.list();
        for (int i = 0; i < contentItemFilesForDeletion.size(); ++i) {
            ContentItemFile fileForDeletion = (ContentItemFile)((Object)contentItemFilesForDeletion.get(i));
            ContentItem parentContentItem = fileForDeletion.getParent();
            parentContentItem.removeVersion(fileForDeletion);
            ++removedCount;
        }
        return removedCount;
    }

    public Log getLogger() {
        return logger;
    }

    public IBackgroundExecutedContentId newBackgroundExecutedContentId(IPentahoSession session, String contentId) {
        Session hibSession = HibernateUtil.getSession();
        String userName = session.getName() != null ? session.getName() : "SYSTEM";
        BackgroundExecutedContentId beci = new BackgroundExecutedContentId(userName, contentId);
        try {
            hibSession.save((Object)beci);
        }
        catch (HibernateException ex) {
            this.error(Messages.getErrorString("CONTREP.ERROR_0005_SAVING_BACKGROUND_CONTENT_ID", contentId), ex);
            throw new RepositoryException(Messages.getErrorString("CONTREP.ERROR_0005_SAVING_BACKGROUND_CONTENT_ID", contentId), (Throwable)ex);
        }
        return beci;
    }

    public List getBackgroundExecutedContentItemsForUser(IPentahoSession session) {
        Session hibSession = HibernateUtil.getSession();
        String userName = session.getName() != null ? session.getName() : "SYSTEM";
        Query qry = hibSession.getNamedQuery("org.pentaho.platform.repository.content.BackgroundExecutedContentId.findBackgroundContentItemsForUsers");
        qry.setString("user", userName);
        return qry.list();
    }

    public List getAllBackgroundExecutedContentItems(IPentahoSession session) {
        Session hibSession = HibernateUtil.getSession();
        Query qry = hibSession.getNamedQuery("org.pentaho.platform.repository.content.BackgroundExecutedContentId.findAllBackgroundContent");
        return qry.list();
    }

    public void removeBackgroundExecutedContentId(IPentahoSession session, String contentId) {
        Session hibSession = HibernateUtil.getSession();
        try {
            BackgroundExecutedContentId beci = (BackgroundExecutedContentId)hibSession.get(BackgroundExecutedContentId.class, (Serializable)((Object)contentId));
            if (beci != null) {
                HibernateUtil.makeTransient(beci);
            }
        }
        catch (HibernateException ignored) {
            // empty catch block
        }
    }
}

