/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.content;

import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentLocation;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.outputhandler.BaseOutputHandler;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.util.logging.Logger;

public class ContentRepositoryOutputHandler
extends BaseOutputHandler {
    private static final byte[] lock = new byte[0];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IContentItem getFileOutputContentItem() {
        String contentRef = this.getContentRef();
        IContentRepository contentRepository = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)this.getSession());
        if (contentRepository == null) {
            Logger.error((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getErrorString("RuntimeContext.ERROR_0024_NO_CONTENT_REPOSITORY"));
            return null;
        }
        String extension = "";
        int idx1 = contentRef.lastIndexOf(".");
        if (idx1 != -1) {
            extension = contentRef.substring(idx1);
        } else {
            idx1 = contentRef.length();
        }
        String extensionFolder = extension;
        if (extensionFolder.startsWith(".")) {
            extensionFolder = extensionFolder.substring(1);
        }
        int idx2 = contentRef.lastIndexOf("/");
        String outputFolder = "";
        String itemName = contentRef;
        if (idx2 != -1) {
            outputFolder = contentRef.substring(0, idx2);
        }
        itemName = contentRef.substring(idx2 + 1, idx1);
        String contentPath = outputFolder + "/" + itemName + "/" + extensionFolder;
        IContentItem contentItem = null;
        byte[] byArray = lock;
        synchronized (lock) {
            IContentLocation contentLocation = null;
            try {
                contentLocation = contentRepository.getContentLocationByPath(contentPath);
            }
            catch (Exception ex) {
                Logger.debug((String)((Object)((Object)this)).getClass().getName(), (String)contentPath, (Throwable)ex);
            }
            if (contentLocation == null) {
                contentLocation = contentRepository.newContentLocation(contentPath, contentRef, contentRef, this.getSolutionName(), true);
            }
            if (contentLocation == null) {
                Logger.error((String)((Object)((Object)this)).getClass().getName(), (String)Messages.getErrorString("RuntimeContext.ERROR_0025_INVALID_CONTENT_LOCATION"));
                // ** MonitorExit[var11_11] (shouldn't be in output)
                return null;
            }
            try {
                contentItem = contentLocation.getContentItemByName(this.getInstanceId());
            }
            catch (Exception ex) {
                Logger.debug((String)((Object)((Object)this)).getClass().getName(), (String)this.getInstanceId(), (Throwable)ex);
            }
            if (contentItem == null) {
                contentItem = contentLocation.newContentItem(this.getInstanceId(), contentRef, extension, this.getMimeType(), null, 0);
            }
            // ** MonitorExit[var11_11] (shouldn't be in output)
            return contentItem;
        }
    }
}

