/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.content;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IContentOutputHandler;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputDef;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.repository.IContentLocation;
import org.pentaho.platform.api.repository.IContentRepository;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.content.ContentRepositoryOutputHandler;
import org.pentaho.platform.repository.messages.Messages;

public class CoreContentRepositoryOutputHandler
implements IOutputHandler {
    private boolean responseExpected;
    private static final byte[] lock = new byte[0];
    public static final String DefaultMimeType = "application/octet-stream";
    public static final String BackgroundFolder = "background";
    public static final String DefaultExtension = ".bin";
    public static final String FileObjectName = "file";
    public static final String ContentRepoObjectName = "contentrepo";
    private boolean contentGenerated;
    private IContentItem outputContentItem;
    private int outputType = 3;
    private String location;
    private String contentGUID;
    private String mimeType;
    private String extension;
    private int writeMode = 1;
    private IPentahoSession userSession;
    protected IRuntimeContext runtimeContext;

    public CoreContentRepositoryOutputHandler(String location, String contentGUID, String solution, IPentahoSession session) {
        this(location, contentGUID, solution, DefaultMimeType, DefaultExtension, session);
    }

    public CoreContentRepositoryOutputHandler(String location, String contentGUID, String solution, String mimeType, String extension, IPentahoSession session) {
        this.contentGUID = contentGUID;
        this.location = location;
        this.mimeType = mimeType;
        this.extension = extension;
        this.userSession = session;
    }

    public void setSession(IPentahoSession session) {
        this.userSession = session;
    }

    public IPentahoSession getSession() {
        return this.userSession;
    }

    public void setMimeType(String value) {
        this.mimeType = value;
    }

    public void setExtension(String value) {
        this.extension = value;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setWriteMode(int value) {
        this.writeMode = value;
    }

    public int getWriteMode() {
        return this.writeMode;
    }

    public Log getLogger() {
        return LogFactory.getLog(ContentRepositoryOutputHandler.class);
    }

    public boolean allowFeedback() {
        return false;
    }

    public boolean contentDone() {
        return this.contentGenerated;
    }

    public IContentItem getFeedbackContentItem() {
        return null;
    }

    public IContentItem getOutputContentItem(String objectName, String contentName, String solution, String instanceId, String inMimeType) {
        return this.getOutputContentItem(objectName, contentName, this.contentGUID, null, solution, instanceId, inMimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public IContentItem getOutputContentItem(String objectName, String contentName, String title, String url, String solution, String instanceId, String inMimeType) {
        this.contentGenerated = true;
        if (FileObjectName.equalsIgnoreCase(objectName) || ContentRepoObjectName.equalsIgnoreCase(objectName)) {
            IContentOutputHandler output = null;
            if (contentName != null && contentName.indexOf(":") == -1) {
                output = PentahoSystem.getOutputDestinationFromContentRef((String)(objectName + ":" + contentName), (IPentahoSession)this.userSession);
            } else {
                output = PentahoSystem.getOutputDestinationFromContentRef((String)contentName, (IPentahoSession)this.userSession);
                if (output == null) {
                    output = PentahoSystem.getOutputDestinationFromContentRef((String)(objectName + ":" + contentName), (IPentahoSession)this.userSession);
                }
            }
            if (output != null) {
                output.setInstanceId(instanceId);
                output.setMimeType(this.mimeType);
                output.setSolutionName(solution);
                return output.getFileOutputContentItem();
            }
        }
        if (this.outputContentItem == null) {
            IContentRepository contentRepository;
            if (inMimeType != null) {
                this.setMimeType(inMimeType);
            }
            if ((contentRepository = (IContentRepository)PentahoSystem.get(IContentRepository.class, (IPentahoSession)this.userSession)) == null) {
                this.getLogger().error((Object)Messages.getErrorString("RuntimeContext.ERROR_0024_NO_CONTENT_REPOSITORY"));
                return null;
            }
            IContentItem contentItem = null;
            byte[] byArray = lock;
            // MONITORENTER : lock
            IContentLocation contentLocation = null;
            try {
                contentLocation = contentRepository.getContentLocationByPath(this.location);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (contentLocation == null) {
                contentLocation = contentRepository.newContentLocation(this.location, contentName, contentName, solution, true);
            }
            if (contentLocation == null) {
                this.getLogger().error((Object)Messages.getErrorString("RuntimeContext.ERROR_0025_INVALID_CONTENT_LOCATION"));
                // MONITOREXIT : byArray
                return null;
            }
            try {
                contentItem = contentLocation.getContentItemByName(this.contentGUID);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (contentItem == null) {
                contentItem = contentLocation.newContentItem(this.contentGUID, this.contentGUID, title, this.extension, this.mimeType, url, this.writeMode);
            }
            this.outputContentItem = contentItem;
            // MONITOREXIT : byArray
        }
        if (!objectName.equals("response")) return this.outputContentItem;
        if (!contentName.equals("content")) return this.outputContentItem;
        this.responseExpected = true;
        return this.outputContentItem;
    }

    public IOutputDef getOutputDef(String name) {
        return null;
    }

    public Map getOutputDefs() {
        return null;
    }

    public int getOutputPreference() {
        return this.outputType;
    }

    public void setContentItem(IContentItem content, String objectName, String contentName) {
        this.outputContentItem = content;
        if (objectName.equals("response") && contentName.equals("content")) {
            this.responseExpected = true;
        }
    }

    public void setOutput(String name, Object value) {
        if ("content".equalsIgnoreCase(name)) {
            if (value instanceof IContentItem) {
                this.outputContentItem = (IContentItem)value;
                this.contentGenerated = true;
            }
            this.responseExpected = true;
        }
    }

    public void setOutputPreference(int value) {
        this.outputType = value;
    }

    public IMimeTypeListener getMimeTypeListener() {
        return null;
    }

    public void setMimeTypeListener(IMimeTypeListener mimeTypeListener) {
    }

    public void setRuntimeContext(IRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }
}

