/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.datasource;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.CacheMode;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.api.repository.datasource.DatasourceMgmtServiceException;
import org.pentaho.platform.api.repository.datasource.DuplicateDatasourceException;
import org.pentaho.platform.api.repository.datasource.IDatasource;
import org.pentaho.platform.api.repository.datasource.IDatasourceMgmtService;
import org.pentaho.platform.api.repository.datasource.NonExistingDatasourceException;
import org.pentaho.platform.api.util.IPasswordService;
import org.pentaho.platform.api.util.PasswordServiceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.datasource.Datasource;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatasourceMgmtService
implements IDatasourceMgmtService {
    private static final Log logger = LogFactory.getLog(DatasourceMgmtService.class);

    public Log getLogger() {
        return logger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDatasource(IDatasource newDatasource) throws DuplicateDatasourceException, DatasourceMgmtServiceException {
        Session session = HibernateUtil.getSession();
        if (newDatasource == null) throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0010_NULL_DATASOURCE_OBJECT"));
        if (this.getDatasource(newDatasource.getName()) != null) throw new DuplicateDatasourceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0005_DATASOURCE_ALREADY_EXIST", newDatasource.getName()));
        try {
            session.setCacheMode(CacheMode.REFRESH);
            IPasswordService passwordService = (IPasswordService)PentahoSystem.getObjectFactory().get(IPasswordService.class, null);
            newDatasource.setPassword(passwordService.encrypt(newDatasource.getPassword()));
            session.save((Object)newDatasource);
        }
        catch (ObjectFactoryException objface) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0009_UNABLE_TO_INIT_PASSWORD_SERVICE"));
        }
        catch (PasswordServiceException pse) {
            session.evict((Object)newDatasource);
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0007_UNABLE_TO_ENCRYPT_PASSWORD"), (Throwable)pse);
        }
        catch (HibernateException ex) {
            session.evict((Object)newDatasource);
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0001_UNABLE_TO_CREATE_DATASOURCE", newDatasource.getName()), (Throwable)ex);
        }
        finally {
            session.setCacheMode(CacheMode.NORMAL);
        }
        session.setCacheMode(CacheMode.NORMAL);
        HibernateUtil.flushSession();
    }

    public void deleteDatasource(String jndiName) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        IDatasource datasource = this.getDatasource(jndiName);
        if (datasource == null) {
            throw new NonExistingDatasourceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0006_DATASOURCE_DOES_NOT_EXIST", jndiName));
        }
        this.deleteDatasource(datasource);
    }

    public void deleteDatasource(IDatasource datasource) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        Session session = HibernateUtil.getSession();
        if (datasource != null) {
            try {
                session.setCacheMode(CacheMode.REFRESH);
                session.delete(session.merge((Object)datasource));
            }
            catch (HibernateException ex) {
                throw new DatasourceMgmtServiceException(ex.getMessage(), (Throwable)ex);
            }
            finally {
                session.setCacheMode(CacheMode.NORMAL);
            }
        } else {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0010_NULL_DATASOURCE_OBJECT"));
        }
        HibernateUtil.flushSession();
    }

    public IDatasource getDatasource(String jndiName) throws DatasourceMgmtServiceException {
        Session session = HibernateUtil.getSession();
        IDatasource datasource = null;
        try {
            session.setCacheMode(CacheMode.REFRESH);
            IDatasource pentahoDatasource = (IDatasource)session.get(Datasource.class, (Serializable)((Object)jndiName));
            if (pentahoDatasource != null) {
                datasource = this.clone(pentahoDatasource);
                IPasswordService passwordService = (IPasswordService)PentahoSystem.getObjectFactory().get(IPasswordService.class, null);
                datasource.setPassword(passwordService.decrypt(datasource.getPassword()));
            }
            IDatasource iDatasource = datasource;
            return iDatasource;
        }
        catch (ObjectFactoryException objface) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0009_UNABLE_TO_INIT_PASSWORD_SERVICE"), (Throwable)objface);
        }
        catch (PasswordServiceException pse) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0008_UNABLE_TO_DECRYPT_PASSWORD"), (Throwable)pse);
        }
        catch (HibernateException ex) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE"), (Throwable)ex);
        }
        finally {
            session.setCacheMode(CacheMode.NORMAL);
        }
    }

    public List<IDatasource> getDatasources() throws DatasourceMgmtServiceException {
        Session session = HibernateUtil.getSession();
        try {
            session.setCacheMode(CacheMode.REFRESH);
            String nameQuery = "org.pentaho.platform.repository.datasource.Datasource.findAllDatasources";
            Query qry = session.getNamedQuery(nameQuery).setCacheable(true);
            List pentahoDatasourceList = qry.list();
            ArrayList<IDatasource> datasourceList = new ArrayList<IDatasource>();
            for (IDatasource pentahoDatasource : pentahoDatasourceList) {
                IDatasource datasource = this.clone(pentahoDatasource);
                IPasswordService passwordService = (IPasswordService)PentahoSystem.getObjectFactory().get(IPasswordService.class, null);
                datasource.setPassword(passwordService.decrypt(datasource.getPassword()));
                datasourceList.add(datasource);
            }
            ArrayList<IDatasource> arrayList = datasourceList;
            return arrayList;
        }
        catch (PasswordServiceException pse) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0007_UNABLE_TO_ENCRYPT_PASSWORD"), (Throwable)pse);
        }
        catch (ObjectFactoryException objface) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0009_UNABLE_TO_INIT_PASSWORD_SERVICE"), (Throwable)objface);
        }
        catch (HibernateException ex) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", ""), (Throwable)ex);
        }
        finally {
            session.setCacheMode(CacheMode.NORMAL);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateDatasource(IDatasource datasource) throws NonExistingDatasourceException, DatasourceMgmtServiceException {
        Session session = HibernateUtil.getSession();
        if (datasource == null) throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0010_NULL_DATASOURCE_OBJECT"));
        IDatasource tmpDatasource = this.getDatasource(datasource.getName());
        if (tmpDatasource == null) throw new NonExistingDatasourceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0006_DATASOURCE_DOES_NOT_EXIST", datasource.getName()));
        try {
            session.setCacheMode(CacheMode.REFRESH);
            IPasswordService passwordService = (IPasswordService)PentahoSystem.getObjectFactory().get(IPasswordService.class, null);
            datasource.setPassword(passwordService.encrypt(datasource.getPassword()));
            IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
            datasourceService.clearDataSource(datasource.getName());
            session.update(session.merge((Object)datasource));
            return;
        }
        catch (ObjectFactoryException objface) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0009_UNABLE_TO_INIT_PASSWORD_SERVICE"), (Throwable)objface);
        }
        catch (PasswordServiceException pse) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0007_UNABLE_TO_ENCRYPT_PASSWORD"), (Throwable)pse);
        }
        catch (HibernateException ex) {
            throw new DatasourceMgmtServiceException(Messages.getErrorString("DatasourceMgmtService.ERROR_0004_UNABLE_TO_RETRIEVE_DATASOURCE", datasource.getName()), (Throwable)ex);
        }
        finally {
            session.setCacheMode(CacheMode.NORMAL);
        }
    }

    public void init(IPentahoSession session) {
        HibernateUtil.beginTransaction();
    }

    private IDatasource clone(IDatasource datasource) throws ObjectFactoryException {
        IDatasource returnDatasource = (IDatasource)PentahoSystem.getObjectFactory().get(IDatasource.class, null);
        returnDatasource.setDriverClass(datasource.getDriverClass());
        returnDatasource.setIdleConn(datasource.getIdleConn());
        returnDatasource.setMaxActConn(datasource.getMaxActConn());
        returnDatasource.setName(datasource.getName());
        returnDatasource.setPassword(datasource.getPassword());
        returnDatasource.setQuery(datasource.getQuery());
        returnDatasource.setUrl(datasource.getUrl());
        returnDatasource.setUserName(datasource.getUserName());
        returnDatasource.setWait(datasource.getWait());
        return returnDatasource;
    }
}

