/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.hibernate.usertypes;

import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.UserType;
import org.hibernate.util.EqualsHelper;
import org.hibernate.util.SerializationHelper;
import org.pentaho.platform.repository.messages.Messages;

public class BlobUserType
implements UserType {
    private static final Log log = LogFactory.getLog(BlobUserType.class);
    private static final boolean debug = true;
    private static final int[] SQLTYPE = new int[]{2004};

    public int[] sqlTypes() {
        return SQLTYPE;
    }

    public Class returnedClass() {
        return Serializable.class;
    }

    public boolean equals(Object arg0, Object arg1) throws HibernateException {
        return EqualsHelper.equals((Object)arg0, (Object)arg1);
    }

    public int hashCode(Object arg0) throws HibernateException {
        return arg0.hashCode();
    }

    public Object nullSafeGet(ResultSet arg0, String[] arg1, Object arg2) throws HibernateException, SQLException {
        log.debug((Object)Messages.getString("BLOBUTYPE.DEBUG_NULL_SAFE_GET"));
        InputStream is = arg0.getBinaryStream(arg1[0]);
        if (is != null) {
            return SerializationHelper.deserialize((InputStream)is);
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement arg0, Object arg1, int arg2) throws HibernateException, SQLException {
        log.debug((Object)Messages.getString("BLOBUTYPE.DEBUG_NULL_SAFE_SET"));
        if (arg1 != null) {
            try {
                arg0.setBytes(arg2, SerializationHelper.serialize((Serializable)((Serializable)arg1)));
            }
            catch (SerializationException ex) {
                log.error((Object)Messages.getErrorString("BLOBUTYPE.ERROR_0001_SETTING_BLOB"), (Throwable)ex);
                throw new HibernateException(Messages.getErrorString("BLOBUTYPE.ERROR_0001_SETTING_BLOB"), (Throwable)ex);
            }
        } else {
            arg0.setNull(arg2, this.sqlTypes()[0]);
        }
    }

    public Object deepCopy(Object arg0) throws HibernateException {
        return SerializationHelper.clone((Serializable)((Serializable)arg0));
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object arg0) throws HibernateException {
        return (Serializable)SerializationHelper.clone((Serializable)((Serializable)arg0));
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        return SerializationHelper.clone((Serializable)arg0);
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return SerializationHelper.clone((Serializable)((Serializable)arg0));
    }
}

