/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.hibernate.usertypes;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.type.SerializationException;
import org.hibernate.usertype.UserType;
import org.pentaho.platform.repository.messages.Messages;

public class BlobtoByteArrayUserType
implements UserType {
    private static final Log log = LogFactory.getLog(BlobtoByteArrayUserType.class);
    private static final int[] SQLTYPE = new int[]{2004};

    public int[] sqlTypes() {
        return SQLTYPE;
    }

    public Class returnedClass() {
        return byte[].class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && y != null && Arrays.equals((byte[])x, (byte[])y);
    }

    public int hashCode(Object arg0) throws HibernateException {
        return arg0.hashCode();
    }

    public Object nullSafeGet(ResultSet arg0, String[] arg1, Object arg2) throws HibernateException, SQLException {
        Blob blob = arg0.getBlob(arg1[0]);
        if (blob != null) {
            byte[] bytes = blob.getBytes(1L, (int)blob.length());
            return bytes;
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement arg0, Object arg1, int arg2) throws HibernateException, SQLException {
        if (arg1 != null) {
            try {
                arg0.setBytes(arg2, (byte[])arg1);
            }
            catch (SerializationException ex) {
                log.error((Object)Messages.getErrorString("BLOBUTYPE.ERROR_0001_SETTING_BLOB"), (Throwable)ex);
                throw new HibernateException(Messages.getErrorString("BLOBUTYPE.ERROR_0001_SETTING_BLOB"), (Throwable)ex);
            }
        } else {
            arg0.setNull(arg2, this.sqlTypes()[0]);
        }
    }

    public Object deepCopy(Object value) {
        if (value == null) {
            return null;
        }
        byte[] bytes = (byte[])value;
        byte[] result = new byte[bytes.length];
        System.arraycopy(bytes, 0, result, 0, bytes.length);
        return result;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object arg0) throws HibernateException {
        return (Serializable)this.deepCopy(arg0);
    }

    public Object assemble(Serializable arg0, Object arg1) throws HibernateException {
        return this.deepCopy(arg0);
    }

    public Object replace(Object arg0, Object arg1, Object arg2) throws HibernateException {
        return this.deepCopy(arg0);
    }
}

