/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.runtime;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository.IRuntimeElement;
import org.pentaho.platform.api.repository.IRuntimeRepository;
import org.pentaho.platform.api.repository.RepositoryException;
import org.pentaho.platform.engine.core.system.PentahoBase;
import org.pentaho.platform.repository.hibernate.HibernateUtil;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.runtime.RuntimeElement;
import org.pentaho.platform.util.UUIDUtil;

public class RuntimeRepository
extends PentahoBase
implements IRuntimeRepository,
IPentahoInitializer {
    private static final long serialVersionUID = -6093228119094501691L;
    private static final boolean debug = true;
    private static final Log log = LogFactory.getLog(RuntimeRepository.class);
    private static final ThreadLocal threadSession = new ThreadLocal();

    public static IPentahoSession getUserSession() {
        IPentahoSession userSession = (IPentahoSession)threadSession.get();
        return userSession;
    }

    public List getMessages() {
        return null;
    }

    public void setSession(IPentahoSession sess) {
        threadSession.set(sess);
        if (sess != null) {
            this.genLogIdFromSession(sess);
            HibernateUtil.beginTransaction();
        }
    }

    public void init(IPentahoSession sess) {
        this.setSession(sess);
    }

    public IRuntimeElement loadElementById(String instId, Collection allowableReadAttributeNames) throws RepositoryException {
        this.debug(Messages.getString("RTREPO.DEBUG_LOAD_ELEMENT_BY_ID", instId));
        Session session = HibernateUtil.getSession();
        try {
            RuntimeElement runtimeElement = (RuntimeElement)((Object)session.load(RuntimeElement.class, (Serializable)((Object)instId)));
            runtimeElement.setAllowableAttributeNames(allowableReadAttributeNames);
            return runtimeElement;
        }
        catch (HibernateException ex) {
            this.error(Messages.getErrorString("RTREPO.ERROR_0001_LOAD_ELEMENT", instId), ex);
            throw new RepositoryException(Messages.getErrorString("RTREPO.ERROR_0001_LOAD_ELEMENT", instId), (Throwable)ex);
        }
    }

    public IRuntimeElement newRuntimeElement(String parId, String parType, boolean transientOnly) {
        this.debug(Messages.getString("RTREPO.DEBUG_NEW_ELEMENT_PARENT", parId, parType));
        Session session = HibernateUtil.getSession();
        String instanceId = UUIDUtil.getUUIDAsString();
        this.debug(Messages.getString("RTREPO.DEBUG_CREATE_INSTANCE", instanceId));
        RuntimeElement re = new RuntimeElement(instanceId, parId, parType);
        if (!transientOnly) {
            try {
                session.save((Object)re);
            }
            catch (HibernateException ex) {
                this.error(Messages.getErrorString("RTREPO.ERROR_0002_SAVING_ELEMENT"), ex);
                throw new RepositoryException(Messages.getErrorString("RTREPO.ERROR_0002_SAVING_ELEMENT"), (Throwable)ex);
            }
        }
        return re;
    }

    public IRuntimeElement newRuntimeElement(String parId, String parType, String solnId, boolean transientOnly) {
        this.debug(Messages.getString("RTREPO.DEBUG_NEW_ELEMENT_PARENT_SOLN", parId, parType, solnId));
        Session session = HibernateUtil.getSession();
        String instanceId = UUIDUtil.getUUIDAsString();
        this.debug(Messages.getString("RTREPO.DEBUG_CREATE_INSTANCE", instanceId));
        RuntimeElement re = new RuntimeElement(instanceId, parId, parType, solnId);
        if (!transientOnly) {
            try {
                session.save((Object)re);
            }
            catch (HibernateException ex) {
                this.error(Messages.getErrorString("RTREPO.ERROR_0003_SAVING_ELEMENT"), ex);
                throw new RepositoryException(Messages.getErrorString("RTREPO.ERROR_0003_SAVING_ELEMENT"), (Throwable)ex);
            }
        }
        return re;
    }

    public Log getLogger() {
        return log;
    }

    public boolean usesHibernate() {
        return true;
    }
}

