/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.repository.solution;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IDocumentResourceLoader;
import org.pentaho.platform.api.engine.IFileFilter;
import org.pentaho.platform.api.engine.IFileInfo;
import org.pentaho.platform.api.engine.IPentahoInitializer;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.ISessionContainer;
import org.pentaho.platform.api.engine.ISolutionAttributeContributor;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.audit.AuditHelper;
import org.pentaho.platform.engine.core.audit.MessageTypes;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.PentahoMessenger;
import org.pentaho.platform.engine.services.SolutionURIResolver;
import org.pentaho.platform.engine.services.actionsequence.ActionSequenceResource;
import org.pentaho.platform.engine.services.solution.SolutionReposHelper;
import org.pentaho.platform.repository.messages.Messages;
import org.pentaho.platform.repository.solution.filebased.FileSolutionFile;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.HttpUtil;
import org.pentaho.platform.util.xml.XmlHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public abstract class SolutionRepositoryBase
extends PentahoMessenger
implements ISolutionRepository,
IPentahoInitializer,
ISessionContainer {
    private static final long serialVersionUID = 6367444546398801343L;
    private IDocumentResourceLoader loader;
    protected static final Log logger = LogFactory.getLog(SolutionRepositoryBase.class);
    protected static final int BROWSE_DEPTH = 2;
    protected static final String ROOT_NODE_NAME = "repository";
    protected static final String LOCATION_ATTR_NAME = "location";
    protected static final String EMPTY_STR = "";
    protected static final boolean debug = true;
    protected static final String ENTRY_NODE_NAME = "entry";
    protected static final String TYPE_ATTR_NAME = "type";
    protected static final String NAME_ATTR_NAME = "name";
    protected static final String DIRECTORY_ATTR = "directory";
    protected static final String FILE_ATTR = "file";
    protected static final long PUBLISH_TIMEOUT = 1500L;
    protected static final Map<String, Properties> propertyMap = new HashMap<String, Properties>();
    protected static final String LOG_NAME = "SOLUTION-REPOSITORY";
    protected static final String PROPERTIES_SUFFIX = ".properties";
    protected static final String EMPTY_STRING = "";
    private static final String RE_SYSTEM_PATH = "^[/\\\\]?system($|[/\\\\].*$)";
    private static final String RE_SYSTEM_TMP_PATH = "^[/\\\\]?system/tmp($|[/\\\\].*$)";
    private static final Pattern SYSTEM_PATH_PATTERN = Pattern.compile("^[/\\\\]?system($|[/\\\\].*$)");
    private static final Pattern SYSTEM_TMP_PATH_PATTERN = Pattern.compile("^[/\\\\]?system/tmp($|[/\\\\].*$)");
    protected ThreadLocal session = new ThreadLocal();
    protected String rootPath;
    protected File rootFile;
    protected String rootCanonicalName;

    public SolutionRepositoryBase() {
        this.loader = new SolutionURIResolver((ISolutionRepository)this);
    }

    protected IDocumentResourceLoader getResourceLoader() {
        return this.loader;
    }

    public Log getLogger() {
        return logger;
    }

    protected Locale getLocale() {
        return LocaleHelper.getLocale();
    }

    protected void init() {
        this.rootFile = this.getFile("", false);
        this.rootPath = this.rootFile.getAbsolutePath() + File.separator;
        this.setLogId("SOLUTION-REPOSITORY: ");
        try {
            this.rootCanonicalName = this.rootFile.getCanonicalPath();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void init(IPentahoSession pentahoSession) {
        this.setSession(pentahoSession);
        this.init();
    }

    protected IPentahoSession getSession() {
        Object threadSession = this.session.get();
        return (IPentahoSession)threadSession;
    }

    public void setSession(IPentahoSession inSession) {
        this.session.set(inSession);
    }

    protected ISolutionFile getLocalizedFile(ISolutionFile resourceFile, int actionOperation) {
        String fileName = resourceFile.getFileName();
        int idx = fileName.lastIndexOf(46);
        String baseName = idx == -1 ? fileName : fileName.substring(0, idx);
        String extension = idx == -1 ? "" : fileName.substring(idx);
        String directory = resourceFile.getSolutionPath();
        if (directory.lastIndexOf(fileName) != -1) {
            directory = new StringBuffer(directory).delete(directory.lastIndexOf(fileName), directory.length()).toString();
        }
        if (!directory.endsWith("/")) {
            directory = directory + '/';
        }
        String language = this.getLocale().getLanguage();
        String country = this.getLocale().getCountry();
        String variant = this.getLocale().getVariant();
        ISolutionFile localeFile = null;
        if (!variant.equals("")) {
            localeFile = this.getFileByPath(directory + baseName + "_" + language + "_" + country + "_" + variant + extension, actionOperation);
        }
        if (localeFile == null) {
            localeFile = this.getFileByPath(directory + baseName + "_" + language + "_" + country + extension, actionOperation);
        }
        if (localeFile == null) {
            localeFile = this.getFileByPath(directory + baseName + "_" + language + extension, actionOperation);
        }
        if (localeFile == null) {
            localeFile = this.getFileByPath(directory + baseName + extension, actionOperation);
        }
        if (localeFile != null) {
            return localeFile;
        }
        return resourceFile;
    }

    protected ISolutionFile getFileByPath(String path, int actionOperation) {
        File file = new File(PentahoSystem.getApplicationContext().getSolutionPath(path));
        if (this.isPathedUnderSolutionRoot(file) && file.exists()) {
            return new FileSolutionFile(file, this.rootFile);
        }
        return null;
    }

    protected boolean isPathedUnderSolutionRoot(String fName) {
        return this.isPathedUnderSolutionRoot(new File(fName));
    }

    protected boolean isPathedUnderSolutionRoot(File aFile) {
        String fc = null;
        try {
            fc = aFile.getCanonicalPath();
        }
        catch (IOException logitOnly) {
            this.debug("", logitOnly);
            return false;
        }
        return fc.startsWith(this.rootCanonicalName);
    }

    protected File getFile(String path, boolean create) {
        File f = new File(PentahoSystem.getApplicationContext().getSolutionPath(path));
        if (this.rootFile != null && !this.isPathedUnderSolutionRoot(f)) {
            return null;
        }
        if (!f.exists() && !create) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0001_FILE_DOES_NOT_EXIST", path));
            return null;
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        this.debug(Messages.getErrorString("SolutionRepository.DEBUG_FILE_PATH", f.getAbsolutePath()));
        return f;
    }

    protected static boolean isSystemPath(String path) {
        Matcher m = SYSTEM_PATH_PATTERN.matcher(path.toLowerCase());
        return m.matches();
    }

    protected static boolean isSystemTmpPath(String path) {
        Matcher m = SYSTEM_TMP_PATH_PATTERN.matcher(path.toLowerCase());
        return m.matches();
    }

    public InputStream getResourceInputStream(IActionSequenceResource actionResource, boolean getLocalizedResource, int actionOperation) throws FileNotFoundException {
        int resourceSource = actionResource.getSourceType();
        InputStream inputStream = null;
        if (resourceSource == 2) {
            inputStream = HttpUtil.getURLInputStream((String)actionResource.getAddress());
        } else if (resourceSource == 1 || resourceSource == 3) {
            ISolutionFile solutionFile = this.getSolutionFile(actionResource, actionOperation);
            if (solutionFile == null) {
                String msg = "[" + actionResource.getAddress() + "] can not be found or you do not have permission to access it.";
                this.debug(msg);
                throw new FileNotFoundException(msg);
            }
            if (getLocalizedResource) {
                solutionFile = this.getLocalizedFile(solutionFile, actionOperation);
            }
            inputStream = new ByteArrayInputStream(solutionFile.getData());
        }
        return inputStream;
    }

    public void localizeDoc(Node document, ISolutionFile file) {
        String fileName = file.getFileName();
        int dotIndex = fileName.indexOf(46);
        String baseName = fileName.substring(0, dotIndex);
        try {
            List nodes = document.selectNodes("descendant::*");
            for (Node node : nodes) {
                String name = node.getText();
                if (!name.startsWith("%") || node.getPath().endsWith("/text()")) continue;
                try {
                    String localeText = this.getLocaleString(name, baseName, file, true);
                    if (localeText == null) continue;
                    node.setText(localeText);
                }
                catch (Exception e) {
                    this.warn(Messages.getString("SolutionRepository.WARN_MISSING_RESOURCE_PROPERTY", name.substring(1), baseName, this.getLocale().toString()));
                }
            }
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0007_COULD_NOT_READ_PROPERTIES", file.getFullPath()), e);
        }
    }

    protected String getLocaleString(String key, String baseName, String baseFilePath, int actionOperation) {
        ISolutionFile file = this.getFileByPath(baseFilePath, actionOperation);
        return this.getLocaleString(key, baseName, file, true);
    }

    protected String getLocaleString(String key, String baseName, ISolutionFile baseFile, boolean marchUpParents) {
        ISolutionFile searchDir = baseFile.retrieveParent();
        if (baseFile.isDirectory()) {
            searchDir = baseFile;
        }
        try {
            boolean searching = true;
            while (searching) {
                ISolutionFile[] propertyFiles = searchDir.listFiles(new IFileFilter(){

                    public boolean accept(ISolutionFile file) {
                        return file.getFileName().toLowerCase().endsWith(SolutionRepositoryBase.PROPERTIES_SUFFIX);
                    }
                });
                ISolutionFile blcv = null;
                ISolutionFile blc = null;
                ISolutionFile bl = null;
                ISolutionFile b = null;
                for (ISolutionFile element : propertyFiles) {
                    if (element.getFileName().equalsIgnoreCase(baseName + '_' + this.getLocale().getLanguage() + '_' + this.getLocale().getCountry() + '_' + this.getLocale().getVariant() + PROPERTIES_SUFFIX)) {
                        blcv = element;
                    }
                    if (element.getFileName().equalsIgnoreCase(baseName + '_' + this.getLocale().getLanguage() + '_' + this.getLocale().getCountry() + PROPERTIES_SUFFIX)) {
                        blc = element;
                    }
                    if (element.getFileName().equalsIgnoreCase(baseName + '_' + this.getLocale().getLanguage() + PROPERTIES_SUFFIX)) {
                        bl = element;
                    }
                    if (!element.getFileName().equalsIgnoreCase(baseName + PROPERTIES_SUFFIX)) continue;
                    b = element;
                }
                String localeText = this.getLocaleText(key, blcv);
                if (localeText == null && (localeText = this.getLocaleText(key, blc)) == null && (localeText = this.getLocaleText(key, bl)) == null) {
                    localeText = this.getLocaleText(key, b);
                }
                if (localeText != null) {
                    return localeText;
                }
                if (searching && marchUpParents) {
                    if (!baseName.equals("messages")) {
                        baseName = "messages";
                        continue;
                    }
                    if (searchDir.isRoot()) {
                        searching = false;
                        continue;
                    }
                    searchDir = searchDir.retrieveParent();
                    continue;
                }
                if (marchUpParents) continue;
                searching = false;
            }
            return null;
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0007_COULD_NOT_READ_PROPERTIES", baseFile.getFullPath()), e);
            return null;
        }
    }

    protected String getLocaleText(String key, ISolutionFile file) throws IOException {
        if (file != null) {
            String localeText;
            Properties p = propertyMap.get(file.getFullPath());
            if (p == null) {
                p = new Properties();
                p.load(new ByteArrayInputStream(file.getData()));
                propertyMap.put(file.getFullPath(), p);
            }
            if ((localeText = p.getProperty(key.substring(1))) == null) {
                localeText = p.getProperty(key);
            }
            if (localeText != null) {
                return localeText;
            }
        }
        return null;
    }

    public InputStream getResourceInputStream(String solutionPath, boolean getLocalizedResource, int actionOperation) throws FileNotFoundException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", solutionPath);
        return this.getResourceInputStream((IActionSequenceResource)resource, getLocalizedResource, actionOperation);
    }

    public Reader getResourceReader(IActionSequenceResource actionResource, int actionOperation) throws FileNotFoundException, IOException {
        return new InputStreamReader(this.getResourceInputStream(actionResource, true, actionOperation), LocaleHelper.getSystemEncoding());
    }

    public Reader getResourceReader(String solutionPath, int actionOperation) throws FileNotFoundException, IOException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", solutionPath);
        return this.getResourceReader((IActionSequenceResource)resource, actionOperation);
    }

    public String getResourceAsString(IActionSequenceResource actionResource, int actionOperation) throws IOException {
        return new String(this.getResourceAsBytes(actionResource, true, actionOperation), LocaleHelper.getSystemEncoding());
    }

    public String getResourceAsString(String solutionPath, int actionOperation) throws IOException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", solutionPath);
        return this.getResourceAsString((IActionSequenceResource)resource, actionOperation);
    }

    public byte[] getResourceAsBytes(IActionSequenceResource actionResource, boolean getLocalizedResource, int actionOperation) throws IOException {
        InputStream inputStream = this.getResourceInputStream(actionResource, getLocalizedResource, actionOperation);
        ByteArrayOutputStream bais = new ByteArrayOutputStream();
        int numRead = 0;
        byte[] buffer = new byte[16384];
        while ((numRead = inputStream.read(buffer)) != -1) {
            bais.write(buffer, 0, numRead);
        }
        bais.close();
        return bais.toByteArray();
    }

    public byte[] getResourceAsBytes(String solutionPath, boolean getLocalizedResource, int actionOperation) throws IOException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", solutionPath);
        return this.getResourceAsBytes((IActionSequenceResource)resource, getLocalizedResource, actionOperation);
    }

    public IPentahoStreamSource getResourceDataSource(IActionSequenceResource actionResource, int actionOperation) throws FileNotFoundException {
        return new ActionSequenceResourceWrapper(actionResource, this.getResourceInputStream(actionResource, true, actionOperation));
    }

    public IPentahoStreamSource getResourceDataSource(String solutionPath, int actionOperation) throws FileNotFoundException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", solutionPath);
        return this.getResourceDataSource((IActionSequenceResource)resource, actionOperation);
    }

    public Document getResourceAsDocument(String solutionPath, int actionOperation) throws IOException {
        ActionSequenceResource resource = new ActionSequenceResource("", 1, "text/xml", solutionPath);
        return this.getResourceAsDocument((IActionSequenceResource)resource, actionOperation);
    }

    public Document getResourceAsDocument(IActionSequenceResource actionResource, int actionOperation) throws IOException {
        byte[] b = this.getResourceAsBytes(actionResource, true, actionOperation);
        String tmpXml = new String(b);
        String encoding = XmlHelper.getEncoding((String)tmpXml);
        if (null == encoding) {
            encoding = LocaleHelper.getSystemEncoding();
        }
        String xml = new String(b, encoding);
        Document document = null;
        try {
            document = XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)this.loader);
        }
        catch (Throwable t) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0009_INVALID_DOCUMENT", actionResource.getAddress()), t);
            return null;
        }
        return document;
    }

    protected IFileInfo getFileInfo(String solution, String path, String fileName, String extension, IPluginManager pluginManager, int actionOperation) {
        IFileInfo fileInfo = null;
        String fullPath = solution + '/' + (StringUtil.isEmpty((String)path) ? "" : path + '/') + fileName;
        try {
            ISolutionFile file = this.getFileByPath(fullPath, actionOperation);
            InputStream in = this.getResourceInputStream(fullPath, true, actionOperation);
            fileInfo = pluginManager.getFileInfo(extension, this.getSession(), file, in);
        }
        catch (Exception e) {
            this.error(Messages.getErrorString("SolutionRepository.ERROR_0021_FILE_NOT_ADDED", fullPath), e);
        }
        return fileInfo;
    }

    public Document getSolutions(int actionOperation) {
        return this.getSolutions(null, null, actionOperation, false);
    }

    protected List getSolutionNames(String solutionName, String pathName, int actionOperation, boolean visibleOnly) {
        Document solns = this.getSolutions(solutionName, pathName, actionOperation, visibleOnly);
        String xPath = "/repository/file";
        return solns.selectNodes(xPath);
    }

    public void resetRepository() {
        ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)this.getSession());
        if (cacheManager != null) {
            cacheManager.killSessionCaches();
            cacheManager.clearRegionCache("repository-service-cache");
        }
        propertyMap.clear();
    }

    public ISolutionFile getRootFolder(int actionOperation) {
        return new FileSolutionFile(this.rootFile, this.rootFile);
    }

    public String getXSLName(Document document, String solution, String inputXSLName) {
        String displayType;
        Node node;
        String xslName = inputXSLName;
        if (solution == null) {
            String displayType2;
            Node node2;
            if (xslName == null && (node2 = document.selectSingleNode("/repository/@displaytype")) != null && (displayType2 = node2.getText()).endsWith(".xsl")) {
                xslName = displayType2;
            }
        } else if (xslName == null && (node = document.selectSingleNode("/files/@displaytype")) != null && (displayType = node.getText()).endsWith(".xsl")) {
            xslName = displayType;
        }
        return xslName;
    }

    public Document getNavigationUIDocument(String solution, String path, int actionOperation) {
        Document document = this.getSolutions(solution, path, 1, false);
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSolutionFile(String baseUrl, String path, String fileName, File f, boolean overwrite) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separator;
        }
        File fNew = new File(baseUrl + path + fileName);
        int status = 3;
        if (fNew.exists() && !overwrite) {
            status = 1;
        } else {
            FileChannel in = null;
            AbstractInterruptibleChannel out = null;
            try {
                in = new FileInputStream(f).getChannel();
                out = new FileOutputStream(fNew).getChannel();
                ((FileChannel)out).transferFrom(in, 0L, in.size());
                this.resetRepository();
            }
            catch (Exception e) {
                logger.error((Object)e.toString());
                status = 2;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSolutionFile(String baseUrl, String path, String fileName, byte[] data, boolean overwrite) {
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separator;
        }
        if (path.equals(File.separator)) {
            logger.error((Object)Messages.getErrorString("SolutionRepository.ERROR_0023_INVALID_PUBLISH_LOCATION_ROOT"));
            return 2;
        }
        File fNew = new File(baseUrl + path + fileName);
        int status = 3;
        if (fNew.exists() && !overwrite) {
            status = 1;
        } else {
            FileOutputStream fNewOut = null;
            try {
                if (!fNew.exists()) {
                    fNew.getParentFile().mkdirs();
                    fNew.createNewFile();
                }
                fNewOut = new FileOutputStream(fNew);
                fNewOut.write(data);
                this.resetRepository();
            }
            catch (Exception e) {
                status = 2;
                logger.error((Object)e.toString());
            }
            finally {
                try {
                    fNewOut.close();
                }
                catch (Exception e) {}
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeSolutionFile(String solutionPath) {
        if (SolutionRepositoryBase.isSystemPath(solutionPath)) {
            return false;
        }
        solutionPath = PentahoSystem.getApplicationContext().getSolutionPath(solutionPath);
        File deleteFile = new File(solutionPath);
        try {
            if (deleteFile.exists()) {
                if (!deleteFile.isDirectory()) {
                    boolean deleted = deleteFile.delete();
                    if (deleted) {
                        AuditHelper.audit((String)"", (String)this.getSession().getName(), (String)"", (String)((Object)((Object)this)).getClass().toString(), (String)"", (String)MessageTypes.UNKNOWN_ENTRY, (String)Messages.getString("SOLREPO.AUDIT_DEL_FILE", solutionPath), (String)"", (float)0.0f, null);
                    }
                    boolean bl = deleted;
                    return bl;
                }
                boolean bl = this.deleteFolder(deleteFile);
                return bl;
            }
        }
        finally {
            this.resetRepository();
        }
        return false;
    }

    public boolean removeSolutionFile(String solution, String path, String fileName) {
        return this.removeSolutionFile(solution + path + fileName);
    }

    private boolean deleteFolder(File dir) {
        String[] files;
        if (!dir.isDirectory()) {
            logger.warn((Object)Messages.getString("SolutionRepository.USER_DELETE_FOLDER_WARNING"));
            return false;
        }
        for (String element : files = dir.list()) {
            String filePath = dir.getAbsolutePath() + File.separator + element;
            File file = new File(filePath);
            if (file.isDirectory()) {
                if (!this.deleteFolder(file)) continue;
                AuditHelper.audit((String)"", (String)this.getSession().getName(), (String)"", (String)((Object)((Object)this)).getClass().toString(), (String)"", (String)MessageTypes.UNKNOWN_ENTRY, (String)Messages.getString("SOLREPO.AUDIT_DEL_FOLDER", filePath), (String)"", (float)0.0f, null);
                continue;
            }
            if (!file.delete()) continue;
            AuditHelper.audit((String)"", (String)this.getSession().getName(), (String)"", (String)((Object)((Object)this)).getClass().toString(), (String)"", (String)MessageTypes.UNKNOWN_ENTRY, (String)Messages.getString("SOLREPO.AUDIT_DEL_FILE", filePath), (String)"", (float)0.0f, null);
        }
        String filePath = dir.getAbsolutePath();
        boolean deleted = dir.delete();
        if (deleted) {
            AuditHelper.audit((String)"", (String)this.getSession().getName(), (String)"", (String)((Object)((Object)this)).getClass().toString(), (String)"", (String)MessageTypes.UNKNOWN_ENTRY, (String)Messages.getString("SOLREPO.AUDIT_DEL_FOLDER", filePath), (String)"", (float)0.0f, null);
        }
        return deleted;
    }

    public Document getFullSolutionTree(int actionOperation, ISolutionFilter filter) {
        return this.getFullSolutionTree(actionOperation, filter, null);
    }

    public Document getFullSolutionTree(int actionOperation, ISolutionFilter filter, ISolutionFile startingFile) {
        startingFile = startingFile == null ? new FileSolutionFile(this.rootFile, this.rootFile) : startingFile;
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("tree");
        SolutionReposHelper.processSolutionTree((Element)root, (ISolutionFile)startingFile, (ISolutionFilter)filter, (ISolutionAttributeContributor)SolutionReposHelper.ADD_NOTHING_CONTRIBUTOR, (int)actionOperation);
        return document;
    }

    protected boolean isCachingAvailable() {
        IPentahoSession pentahoSession = this.getSession();
        ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)pentahoSession);
        return cacheManager != null && cacheManager.cacheEnabled();
    }

    protected Object putRepositoryObjectInCache(String key, Object value) {
        if (this.isCachingAvailable()) {
            ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)this.getSession());
            cacheManager.putInSessionCache(this.getSession(), key, value);
            return value;
        }
        return null;
    }

    protected Object getRepositoryObjectFromCache(String key) {
        if (this.isCachingAvailable()) {
            ICacheManager cacheManager = PentahoSystem.getCacheManager((IPentahoSession)this.getSession());
            return cacheManager.getFromSessionCache(this.getSession(), key);
        }
        return null;
    }

    public ISolutionFile getSolutionFile(String path, int actionOperation) {
        ISolutionFile solutionFile = null;
        if (!SolutionRepositoryBase.isSystemPath(path)) {
            solutionFile = this.getFileByPath(path, actionOperation);
        } else {
            String solutionPath = PentahoSystem.getApplicationContext().getSolutionPath(path);
            if (this.isPathedUnderSolutionRoot(solutionPath)) {
                solutionFile = new FileSolutionFile(new File(solutionPath), this.rootFile);
            }
        }
        return solutionFile;
    }

    public ISolutionFile getSolutionFile(IActionSequenceResource actionResource, int actionOperation) {
        ISolutionFile solutionFile = null;
        int resourceSource = actionResource.getSourceType();
        String realPath = null;
        if (resourceSource == 1) {
            realPath = actionResource.getAddress();
            solutionFile = this.getSolutionFile(realPath, actionOperation);
        } else if (resourceSource == 3 && this.isPathedUnderSolutionRoot(realPath = actionResource.getAddress())) {
            solutionFile = new FileSolutionFile(new File(realPath), this.rootFile);
        }
        if (solutionFile == null || !solutionFile.exists()) {
            solutionFile = null;
        }
        return solutionFile;
    }

    public ISolutionFile createFolder(File newFolder) throws IOException {
        if (!this.isPathedUnderSolutionRoot(newFolder)) {
            throw new IOException(Messages.getErrorString("SolutionRepository.ERROR_0021_FILE_NOT_ADDED", newFolder.getName()));
        }
        newFolder.mkdirs();
        FileSolutionFile fsf = new FileSolutionFile(newFolder, this.rootFile);
        return fsf;
    }

    public String getLocalizedFileProperty(ISolutionFile resourceFile, String key, int actionOperation) {
        String localizedName;
        String baseName;
        if (!this.hasAccess(resourceFile, actionOperation)) {
            return null;
        }
        String fileName = resourceFile.getFileName();
        int idx = fileName.lastIndexOf(46);
        String string = baseName = idx == -1 ? fileName : fileName.substring(0, idx);
        if (resourceFile.isDirectory()) {
            ISolutionFile[] possibleIndexFiles = resourceFile.listFiles(new IFileFilter(){

                public boolean accept(ISolutionFile file) {
                    return file.getFileName().equals("index.xml");
                }
            });
            String value = null;
            if (possibleIndexFiles.length > 0) {
                String xml = new String(possibleIndexFiles[0].getData());
                Document document = null;
                try {
                    document = XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)this.getResourceLoader());
                    value = document.selectSingleNode("/index/" + key).getText();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    value = null;
                }
            }
            localizedName = value == null || "".equals(value) ? this.getLocaleString(key, "index", resourceFile, false) : (value.startsWith("%") ? this.getLocaleString(value.substring(1), "index", resourceFile, false) : value);
        } else {
            String value = null;
            if (resourceFile.getFileName().endsWith(".xaction")) {
                String xml = new String(resourceFile.getData());
                Document document = null;
                try {
                    document = XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)this.getResourceLoader());
                    value = document.selectSingleNode("/action-sequence/" + key).getText();
                }
                catch (Throwable t) {
                    value = null;
                }
            }
            localizedName = value == null || "".equals(value) ? this.getLocaleString(key, baseName, resourceFile, false) : (value.startsWith("%") ? this.getLocaleString(value.substring(1), baseName, resourceFile, false) : value);
        }
        return localizedName;
    }

    protected String buildDirectoryPath(String solution, String path, String action) {
        String localDirStr = "";
        localDirStr = localDirStr + '/';
        if (solution != null && solution.length() > 0) {
            localDirStr = localDirStr + solution;
            if (path != null && path.length() > 0) {
                localDirStr = localDirStr + '/';
                localDirStr = localDirStr + path;
            }
        }
        if (action != null && action.length() > 0) {
            String seperator = new String() + '/';
            if (!localDirStr.endsWith(seperator)) {
                localDirStr = localDirStr + '/';
            }
            localDirStr = localDirStr + action;
        }
        return localDirStr;
    }

    protected String buildDirectoryPath(String repositoryName, String path) {
        int start;
        String seperator = null;
        int initialStartingPoint = path.indexOf(repositoryName.replaceAll(seperator = seperator + '/', ""));
        if (initialStartingPoint >= 0 && (start = path.indexOf(47, initialStartingPoint)) >= 0) {
            return path.substring(start + 1, path.length());
        }
        return path;
    }

    protected String getValue(Document doc, String xPath, String defaultValue) {
        if (doc != null) {
            Node node = doc.selectSingleNode(xPath);
            if (node == null) {
                return defaultValue;
            }
            return node.getText();
        }
        return defaultValue;
    }

    @Deprecated
    public String[] getAllActionSequences() {
        return this.getAllActionSequences(1);
    }

    @Deprecated
    public String getLocalizedFileProperty(ISolutionFile resourceFile, String key) {
        return this.getLocalizedFileProperty(resourceFile, key, 1);
    }

    @Deprecated
    public byte[] getResourceAsBytes(String solutionPath, boolean getLocalizedResource) throws IOException {
        return this.getResourceAsBytes(solutionPath, getLocalizedResource, 1);
    }

    @Deprecated
    public byte[] getResourceAsBytes(IActionSequenceResource actionResource, boolean getLocalizedResource) throws IOException {
        return this.getResourceAsBytes(actionResource, getLocalizedResource, 1);
    }

    @Deprecated
    public Document getResourceAsDocument(String solutionPath) throws IOException {
        return this.getResourceAsDocument(solutionPath, 1);
    }

    @Deprecated
    public Document getResourceAsDocument(IActionSequenceResource actionResource) throws IOException {
        return this.getResourceAsDocument(actionResource, 1);
    }

    @Deprecated
    public String getResourceAsString(IActionSequenceResource actionResource) throws IOException {
        return this.getResourceAsString(actionResource, 1);
    }

    @Deprecated
    public String getResourceAsString(String solutionPath) throws IOException {
        return this.getResourceAsString(solutionPath, 1);
    }

    @Deprecated
    public IPentahoStreamSource getResourceDataSource(String solutionPath) throws FileNotFoundException {
        return this.getResourceDataSource(solutionPath, 1);
    }

    @Deprecated
    public IPentahoStreamSource getResourceDataSource(IActionSequenceResource actionResource) throws FileNotFoundException {
        return this.getResourceDataSource(actionResource, 1);
    }

    @Deprecated
    public InputStream getResourceInputStream(IActionSequenceResource actionResource, boolean getLocalizedResource) throws FileNotFoundException {
        return this.getResourceInputStream(actionResource, getLocalizedResource, 1);
    }

    @Deprecated
    public InputStream getResourceInputStream(String solutionPath, boolean getLocalizedResource) throws FileNotFoundException {
        return this.getResourceInputStream(solutionPath, getLocalizedResource, 1);
    }

    @Deprecated
    public Reader getResourceReader(IActionSequenceResource actionResource) throws FileNotFoundException, IOException {
        return this.getResourceReader(actionResource, 1);
    }

    @Deprecated
    public Reader getResourceReader(String solutionPath) throws FileNotFoundException, IOException {
        return this.getResourceReader(solutionPath, 1);
    }

    @Deprecated
    public ISolutionFile getSolutionFile(String path) {
        return this.getSolutionFile(path, 1);
    }

    @Deprecated
    public ISolutionFile getSolutionFile(IActionSequenceResource actionResource) {
        return this.getSolutionFile(actionResource, 1);
    }

    @Deprecated
    public long getSolutionFileLastModified(String path) {
        return this.getSolutionFileLastModified(path, 1);
    }

    @Deprecated
    public boolean resourceExists(String solutionPath) {
        return this.resourceExists(solutionPath, 1);
    }

    @Deprecated
    public long resourceSize(String solutionPath) {
        return this.resourceSize(solutionPath, 1);
    }

    @Deprecated
    public ISolutionFile getFileByPath(String path) {
        return this.getSolutionFile(path, 1);
    }

    protected static final class ActionSequenceResourceWrapper
    implements IPentahoStreamSource {
        private InputStream inputStream;
        private IActionSequenceResource resource;

        public ActionSequenceResourceWrapper(IActionSequenceResource actionResource, InputStream iStream) {
            assert (actionResource != null);
            assert (iStream != null);
            this.resource = actionResource;
            this.inputStream = iStream;
        }

        public String getContentType() {
            return this.resource.getMimeType();
        }

        public InputStream getInputStream() throws IOException {
            if (this.inputStream != null && this.inputStream.markSupported()) {
                try {
                    this.inputStream.reset();
                }
                catch (IOException e) {
                    return this.inputStream;
                }
            }
            return this.inputStream;
        }

        public String getName() {
            return this.resource.getName();
        }

        public OutputStream getOutputStream() throws IOException {
            return new ByteArrayOutputStream();
        }
    }
}

